/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock;

import java.io.IOException;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.aoneblock.AOneBlockPlaceholders;
import world.bentobox.aoneblock.Settings;
import world.bentobox.aoneblock.commands.admin.AdminCommand;
import world.bentobox.aoneblock.commands.island.PlayerCommand;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.aoneblock.generators.ChunkGeneratorWorld;
import world.bentobox.aoneblock.listeners.BlockListener;
import world.bentobox.aoneblock.listeners.BlockProtect;
import world.bentobox.aoneblock.listeners.BossBarListener;
import world.bentobox.aoneblock.listeners.HoloListener;
import world.bentobox.aoneblock.listeners.InfoListener;
import world.bentobox.aoneblock.listeners.ItemsAdderListener;
import world.bentobox.aoneblock.listeners.JoinLeaveListener;
import world.bentobox.aoneblock.listeners.NoBlockHandler;
import world.bentobox.aoneblock.listeners.StartSafetyListener;
import world.bentobox.aoneblock.oneblocks.OneBlockCustomBlockCreator;
import world.bentobox.aoneblock.oneblocks.OneBlocksManager;
import world.bentobox.aoneblock.oneblocks.customblock.ItemsAdderCustomBlock;
import world.bentobox.aoneblock.requests.IslandStatsHandler;
import world.bentobox.aoneblock.requests.LocationStatsHandler;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.configuration.Config;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.database.objects.Island;

public class AOneBlock
extends GameModeAddon {
    private static final String NETHER = "_nether";
    private static final String THE_END = "_the_end";
    private boolean hasItemsAdder = false;
    private Settings settings;
    private ChunkGeneratorWorld chunkGenerator;
    private final Config<Settings> configObject = new Config((Addon)this, Settings.class);
    private BlockListener blockListener;
    private OneBlocksManager oneBlockManager;
    private AOneBlockPlaceholders phManager;
    private HoloListener holoListener;
    public final Flag START_SAFETY = new Flag.Builder("START_SAFETY", Material.BAMBOO_BLOCK).mode(Flag.Mode.BASIC).type(Flag.Type.WORLD_SETTING).listener((Listener)new StartSafetyListener(this)).defaultSetting(false).build();
    private BossBarListener bossBar = new BossBarListener(this);
    public final Flag ONEBLOCK_BOSSBAR = new Flag.Builder("ONEBLOCK_BOSSBAR", Material.DRAGON_HEAD).mode(Flag.Mode.BASIC).type(Flag.Type.SETTING).listener((Listener)this.bossBar).defaultSetting(true).build();
    public final Flag ONEBLOCK_ACTIONBAR = new Flag.Builder("ONEBLOCK_ACTIONBAR", Material.IRON_BARS).mode(Flag.Mode.BASIC).type(Flag.Type.SETTING).listener((Listener)this.bossBar).defaultSetting(true).build();
    public final Flag MAGIC_BLOCK = new Flag.Builder("MAGIC_BLOCK", Material.GRASS_BLOCK).mode(Flag.Mode.BASIC).type(Flag.Type.PROTECTION).defaultRank(200).build();

    public void onLoad() {
        if (Bukkit.getPluginManager().getPlugin("ItemsAdder") != null) {
            this.registerListener(new ItemsAdderListener(this));
            OneBlockCustomBlockCreator.register(ItemsAdderCustomBlock::fromId);
            OneBlockCustomBlockCreator.register("itemsadder", ItemsAdderCustomBlock::fromMap);
            this.hasItemsAdder = true;
        }
        this.saveDefaultConfig();
        if (this.loadSettings()) {
            this.chunkGenerator = this.settings.isUseOwnGenerator() ? null : new ChunkGeneratorWorld(this);
            this.playerCommand = new PlayerCommand(this);
            this.adminCommand = new AdminCommand(this);
            this.getPlugin().getFlagsManager().registerFlag((Addon)this, this.START_SAFETY);
            this.getPlugin().getFlagsManager().registerFlag((Addon)this, this.ONEBLOCK_BOSSBAR);
            this.getPlugin().getFlagsManager().registerFlag((Addon)this, this.MAGIC_BLOCK);
        }
    }

    private boolean loadSettings() {
        this.settings = (Settings)this.configObject.loadConfigObject();
        if (this.settings == null) {
            this.logError("AOneBlock settings could not load! Addon disabled.");
            this.setState(Addon.State.DISABLED);
            return false;
        }
        this.configObject.saveConfigObject((Object)this.settings);
        return true;
    }

    public void onEnable() {
        this.oneBlockManager = new OneBlocksManager(this);
        if (this.loadData()) {
            return;
        }
        this.blockListener = new BlockListener(this);
        this.registerListener(this.blockListener);
        this.registerListener(new NoBlockHandler(this));
        this.registerListener(new BlockProtect(this));
        this.registerListener(new JoinLeaveListener(this));
        this.registerListener(new InfoListener(this));
        this.registerListener(this.bossBar);
        this.phManager = new AOneBlockPlaceholders(this, this.getPlugin().getPlaceholdersManager());
        this.registerRequestHandler(new IslandStatsHandler(this));
        this.registerRequestHandler(new LocationStatsHandler(this));
        this.holoListener = new HoloListener(this);
        this.registerListener(this.holoListener);
    }

    public boolean loadData() {
        try {
            this.oneBlockManager.loadPhases();
        }
        catch (IOException e) {
            this.logError("AOneBlock settings could not load (oneblock.yml error)! Addon disabled.");
            this.logError(e.getMessage());
            this.setState(Addon.State.DISABLED);
            return true;
        }
        return false;
    }

    public void onDisable() {
        if (this.blockListener != null) {
            this.blockListener.saveCache();
        }
        if (this.holoListener != null) {
            this.holoListener.onDisable();
        }
    }

    public void onReload() {
        this.blockListener.saveCache();
        if (this.loadSettings()) {
            this.log("Reloaded AOneBlock settings");
            this.loadData();
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void createWorlds() {
        String worldName = this.settings.getWorldName().toLowerCase();
        if (this.getServer().getWorld(worldName) == null) {
            this.log("Creating AOneBlock world ...");
        }
        this.islandWorld = this.getWorld(worldName, World.Environment.NORMAL, this.chunkGenerator);
        if (this.settings.isNetherGenerate()) {
            if (this.getServer().getWorld(worldName + NETHER) == null) {
                this.log("Creating AOneBlock's Nether...");
            }
            World world = this.netherWorld = this.settings.isNetherIslands() ? this.getWorld(worldName, World.Environment.NETHER, this.chunkGenerator) : this.getWorld(worldName, World.Environment.NETHER, null);
        }
        if (this.settings.isEndGenerate()) {
            if (this.getServer().getWorld(worldName + THE_END) == null) {
                this.log("Creating AOneBlock's End World...");
            }
            this.endWorld = this.settings.isEndIslands() ? this.getWorld(worldName, World.Environment.THE_END, this.chunkGenerator) : this.getWorld(worldName, World.Environment.THE_END, null);
        }
    }

    private World getWorld(String worldName2, World.Environment env, ChunkGeneratorWorld chunkGenerator2) {
        World w;
        worldName2 = env.equals((Object)World.Environment.NETHER) ? (String)worldName2 + NETHER : worldName2;
        worldName2 = env.equals((Object)World.Environment.THE_END) ? (String)worldName2 + THE_END : worldName2;
        WorldCreator wc = WorldCreator.name((String)worldName2).environment(env);
        World world = w = this.settings.isUseOwnGenerator() ? wc.createWorld() : wc.generator((ChunkGenerator)chunkGenerator2).createWorld();
        if (w != null) {
            this.setSpawnRates(w);
        }
        return w;
    }

    private void setSpawnRates(World w) {
        if (this.getSettings().getSpawnLimitMonsters() > 0) {
            w.setSpawnLimit(SpawnCategory.MONSTER, this.getSettings().getSpawnLimitMonsters());
        }
        if (this.getSettings().getSpawnLimitAmbient() > 0) {
            w.setSpawnLimit(SpawnCategory.AMBIENT, this.getSettings().getSpawnLimitAmbient());
        }
        if (this.getSettings().getSpawnLimitAnimals() > 0) {
            w.setSpawnLimit(SpawnCategory.ANIMAL, this.getSettings().getSpawnLimitAnimals());
        }
        if (this.getSettings().getSpawnLimitWaterAnimals() > 0) {
            w.setSpawnLimit(SpawnCategory.WATER_ANIMAL, this.getSettings().getSpawnLimitWaterAnimals());
        }
        if (this.getSettings().getTicksPerAnimalSpawns() > 0) {
            w.setTicksPerSpawns(SpawnCategory.ANIMAL, this.getSettings().getTicksPerAnimalSpawns());
        }
        if (this.getSettings().getTicksPerMonsterSpawns() > 0) {
            w.setTicksPerSpawns(SpawnCategory.MONSTER, this.getSettings().getTicksPerMonsterSpawns());
        }
    }

    public WorldSettings getWorldSettings() {
        return this.getSettings();
    }

    public @Nullable ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return this.chunkGenerator;
    }

    public void saveWorldSettings() {
        if (this.settings != null) {
            this.configObject.saveConfigObject((Object)this.settings);
        }
    }

    public void saveDefaultConfig() {
        super.saveDefaultConfig();
        this.saveResource("panels/phases_panel.yml", false);
    }

    public void allLoaded() {
        this.saveWorldSettings();
    }

    public @NonNull OneBlockIslands getOneBlocksIsland(@NonNull Island i) {
        return this.blockListener.getIsland(Objects.requireNonNull(i));
    }

    public OneBlocksManager getOneBlockManager() {
        return this.oneBlockManager;
    }

    public BlockListener getBlockListener() {
        return this.blockListener;
    }

    public AOneBlockPlaceholders getPlaceholdersManager() {
        return this.phManager;
    }

    public HoloListener getHoloListener() {
        return this.holoListener;
    }

    public boolean hasItemsAdder() {
        return this.hasItemsAdder;
    }

    public void setIslandWorld(World world) {
        this.islandWorld = world;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public BossBarListener getBossBar() {
        return this.bossBar;
    }
}

