/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.commands.island;

import java.util.List;
import java.util.Objects;
import org.bukkit.World;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class IslandCountCommand
extends CompositeCommand {
    private AOneBlock addon;

    public IslandCountCommand(CompositeCommand islandCommand, String label, String[] aliases) {
        super(islandCommand, label, aliases);
    }

    public void setup() {
        this.setDescription("aoneblock.commands.count.description");
        this.setOnlyPlayer(true);
        this.setPermission("count");
        this.addon = (AOneBlock)this.getAddon();
    }

    public boolean canExecute(User user, String label, List<String> args) {
        if (!Util.sameWorld((World)this.getWorld(), (World)user.getWorld())) {
            user.sendMessage("general.errors.wrong-world", new String[0]);
            return false;
        }
        if (!this.getIslands().locationIsOnIsland(user.getPlayer(), user.getLocation())) {
            user.sendMessage("commands.island.sethome.must-be-on-your-island", new String[0]);
            return false;
        }
        return true;
    }

    public boolean execute(User user, String label, List<String> args) {
        this.getIslands().getProtectedIslandAt(Objects.requireNonNull(user.getLocation())).ifPresent(island -> {
            OneBlockIslands i = this.addon.getOneBlocksIsland((Island)island);
            user.sendMessage("aoneblock.commands.count.info", new String[]{"[number]", String.valueOf(i.getBlockNumber()), "[name]", i.getPhaseName()});
        });
        return true;
    }
}

