/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.listeners;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.aoneblock.events.MagicBlockEvent;
import world.bentobox.bentobox.api.events.flags.FlagSettingChangeEvent;
import world.bentobox.bentobox.api.events.island.IslandEnterEvent;
import world.bentobox.bentobox.api.events.island.IslandExitEvent;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class BossBarListener
implements Listener {
    private static final String AONEBLOCK_BOSSBAR = "aoneblock.bossbar";
    private static final String AONEBLOCK_ACTIONBAR = "aoneblock.actionbar";
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.builder().character('&').hexColors().build();
    private AOneBlock addon;
    private final Map<Island, BossBar> islandBossBars = new HashMap<Island, BossBar>();

    public BossBarListener(AOneBlock addon) {
        this.addon = addon;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBreakBlockEvent(MagicBlockEvent e) {
        this.tryToShowBossBar(e.getPlayerUUID(), e.getIsland());
        this.tryToShowActionBar(e.getPlayerUUID(), e.getIsland());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEnterIsland(IslandEnterEvent event) {
        if (this.addon.inWorld(event.getIsland().getWorld())) {
            this.tryToShowBossBar(event.getPlayerUUID(), event.getIsland());
            this.tryToShowActionBar(event.getPlayerUUID(), event.getIsland());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFlagChange(FlagSettingChangeEvent e) {
        if (e.getEditedFlag() == this.addon.ONEBLOCK_BOSSBAR) {
            e.getIsland().getPlayersOnIsland().stream().map(OfflinePlayer::getUniqueId).forEach(uuid -> {
                this.tryToShowBossBar((UUID)uuid, e.getIsland());
                this.tryToShowActionBar((UUID)uuid, e.getIsland());
            });
        }
    }

    public static Component bukkitToAdventure(String legacyString) {
        if (legacyString == null) {
            return Component.empty();
        }
        return LEGACY_SERIALIZER.deserialize(legacyString);
    }

    private void tryToShowActionBar(UUID uuid, Island island) {
        User user = User.getInstance((UUID)uuid);
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (!island.isAllowed(this.addon.ONEBLOCK_ACTIONBAR)) {
            return;
        }
        if (!user.getMetaData(AONEBLOCK_ACTIONBAR).map(MetaDataValue::asBoolean).orElse(true).booleanValue()) {
            this.removeBar(user, island);
            return;
        }
        @NonNull OneBlockIslands obi = this.addon.getOneBlocksIsland(island);
        int numBlocksToGo = this.addon.getOneBlockManager().getNextPhaseBlocks(obi);
        int phaseBlocks = this.addon.getOneBlockManager().getPhaseBlocks(obi);
        int done = phaseBlocks - numBlocksToGo;
        String translation = user.getTranslationOrNothing("aoneblock.actionbar.status", new String[]{"[togo]", String.valueOf(numBlocksToGo), "[total]", String.valueOf(phaseBlocks), "[done]", String.valueOf(done), "[phase-name]", obi.getPhaseName(), "[percent-done]", Math.round(this.addon.getOneBlockManager().getPercentageDone(obi)) + "%"});
        player.sendActionBar(BossBarListener.bukkitToAdventure(translation));
    }

    private void tryToShowBossBar(UUID uuid, Island island) {
        BarColor c;
        User user = User.getInstance((UUID)uuid);
        if (!island.isAllowed(this.addon.ONEBLOCK_BOSSBAR)) {
            BossBar removed = this.islandBossBars.remove(island);
            if (removed != null) {
                removed.removeAll();
            }
            return;
        }
        if (!user.getMetaData(AONEBLOCK_BOSSBAR).map(MetaDataValue::asBoolean).orElse(true).booleanValue()) {
            this.removeBar(user, island);
            return;
        }
        String title = user.getTranslationOrNothing("aoneblock.bossbar.title", new String[0]);
        try {
            c = BarColor.valueOf((String)user.getTranslation("aoneblock.bossbar.color", new String[0]).toUpperCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            c = BarColor.RED;
            this.addon.logError("Bossbar color unknown. Pick from RED, WHITE, PINK, BLUE, GREEN, YELLOW, or PURPLE");
        }
        BarStyle s = BarStyle.SOLID;
        try {
            s = BarStyle.valueOf((String)user.getTranslation("aoneblock.bossbar.style", new String[0]).toUpperCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            s = BarStyle.SOLID;
            this.addon.logError("Bossbar style unknow. Pick from SOLID, SEGMENTED_6,  SEGMENTED_10, SEGMENTED_12, SEGMENTED_20");
        }
        BossBar bar = this.islandBossBars.getOrDefault(island, Bukkit.createBossBar((String)title, (BarColor)c, (BarStyle)s, (BarFlag[])new BarFlag[0]));
        @NonNull OneBlockIslands obi = this.addon.getOneBlocksIsland(island);
        bar.setProgress(this.addon.getOneBlockManager().getPercentageDone(obi) / 100.0);
        int numBlocksToGo = this.addon.getOneBlockManager().getNextPhaseBlocks(obi);
        int phaseBlocks = this.addon.getOneBlockManager().getPhaseBlocks(obi);
        int done = phaseBlocks - numBlocksToGo;
        String translation = user.getTranslationOrNothing("aoneblock.bossbar.status", new String[]{"[togo]", String.valueOf(numBlocksToGo), "[total]", String.valueOf(phaseBlocks), "[done]", String.valueOf(done), "[phase-name]", obi.getPhaseName(), "[percent-done]", Math.round(this.addon.getOneBlockManager().getPercentageDone(obi)) + "%"});
        bar.setTitle(translation);
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (!bar.getPlayers().contains(player)) {
            bar.addPlayer(player);
        }
        this.islandBossBars.put(island, bar);
    }

    private void removeBar(User user, Island island) {
        if (!(this.addon.inWorld(island.getWorld()) && user.isPlayer() && user.isOnline())) {
            return;
        }
        BossBar bossBar = this.islandBossBars.get(island);
        if (bossBar != null) {
            bossBar.removePlayer(user.getPlayer());
            if (bossBar.getPlayers().isEmpty()) {
                this.islandBossBars.remove(island);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onExitIsland(IslandExitEvent event) {
        User user = User.getInstance((UUID)event.getPlayerUUID());
        this.removeBar(user, event.getIsland());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent e) {
        if (!this.addon.inWorld(e.getPlayer().getLocation())) {
            return;
        }
        this.addon.getIslands().getIslandAt(e.getPlayer().getLocation()).ifPresent(is -> this.tryToShowBossBar(e.getPlayer().getUniqueId(), (Island)is));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onQuit(PlayerQuitEvent e) {
        this.islandBossBars.values().stream().forEach(bb -> bb.removePlayer(e.getPlayer()));
        this.islandBossBars.values().removeIf(bb -> bb.getPlayers().isEmpty());
    }

    public void toggleUser(User user) {
        boolean newState = user.getMetaData(AONEBLOCK_BOSSBAR).map(MetaDataValue::asBoolean).orElse(true) == false;
        user.putMetaData(AONEBLOCK_BOSSBAR, new MetaDataValue((Object)newState));
        if (newState) {
            this.addon.getIslands().getIslandAt(user.getLocation()).filter(is -> this.addon.inWorld(is.getWorld())).ifPresent(is -> this.tryToShowBossBar(user.getUniqueId(), (Island)is));
            user.sendMessage("aoneblock.commands.island.bossbar.status_on", new String[0]);
        } else {
            this.islandBossBars.forEach((k, v) -> v.removePlayer(user.getPlayer()));
            user.sendMessage("aoneblock.commands.island.bossbar.status_off", new String[0]);
        }
    }
}

