/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.listeners;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.events.BlockClearEvent;

public class MakeSpace {
    static final List<EntityType> WATER_ENTITIES = List.of(EntityType.GUARDIAN, EntityType.ELDER_GUARDIAN, EntityType.COD, EntityType.SALMON, EntityType.PUFFERFISH, EntityType.TROPICAL_FISH, EntityType.DROWNED, EntityType.DOLPHIN, EntityType.TADPOLE, EntityType.SQUID, EntityType.AXOLOTL, EntityType.GLOW_SQUID);
    private final AOneBlock addon;

    public MakeSpace(AOneBlock addon) {
        this.addon = addon;
    }

    public void makeSpace(@NonNull Entity entity, @NonNull Location spawnLocation) {
        World world = entity.getWorld();
        ArrayList<Block> airBlocks = new ArrayList<Block>();
        ArrayList<Block> waterBlocks = new ArrayList<Block>();
        BoundingBox boundingBox = entity.getBoundingBox();
        boolean isWaterProtected = this.addon.getSettings().isWaterMobProtection() && WATER_ENTITIES.contains(entity.getType());
        for (double y = boundingBox.getMinY(); y <= Math.min(boundingBox.getMaxY(), (double)world.getMaxHeight()); y += 1.0) {
            double x;
            Block block2 = world.getBlockAt(new Location(world, (double)spawnLocation.getBlockX(), y, (double)spawnLocation.getBlockZ()));
            this.checkBlock(block2, boundingBox, isWaterProtected, airBlocks, waterBlocks);
            if (isWaterProtected && y + 1.0 < (double)world.getMaxHeight()) {
                airBlocks.add(block2.getRelative(BlockFace.UP));
            }
            if (boundingBox.getWidthX() > 1.0 && boundingBox.getWidthZ() > 1.0) {
                for (x = boundingBox.getMinX() - 0.5; x < boundingBox.getMaxX() + 0.5; x += 1.0) {
                    for (double z = boundingBox.getMinZ() - 0.5; z < boundingBox.getMaxZ() + 0.5; z += 1.0) {
                        block2 = world.getBlockAt(new Location(world, x, y, z));
                        this.checkBlock(block2, boundingBox, isWaterProtected, airBlocks, waterBlocks);
                    }
                }
                continue;
            }
            if (boundingBox.getWidthX() > 1.0) {
                for (x = boundingBox.getMinX() - 0.5; x < boundingBox.getMaxX() + 0.5; x += 1.0) {
                    block2 = world.getBlockAt(new Location(world, x, y, spawnLocation.getZ()));
                    this.checkBlock(block2, boundingBox, isWaterProtected, airBlocks, waterBlocks);
                }
                continue;
            }
            if (!(boundingBox.getWidthZ() > 1.0)) continue;
            for (double z = boundingBox.getMinZ() - 0.5; z < boundingBox.getMaxZ() + 0.5; z += 1.0) {
                block2 = world.getBlockAt(new Location(world, spawnLocation.getX(), y, z));
                this.checkBlock(block2, boundingBox, isWaterProtected, airBlocks, waterBlocks);
            }
        }
        BlockClearEvent event = new BlockClearEvent(entity, airBlocks, waterBlocks);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        airBlocks.forEach(Block::breakNaturally);
        airBlocks.forEach(b -> b.setType(Material.AIR));
        waterBlocks.forEach(block -> {
            BlockData patt0$temp = block.getBlockData();
            if (patt0$temp instanceof Waterlogged) {
                Waterlogged waterlogged = (Waterlogged)patt0$temp;
                waterlogged.setWaterlogged(true);
            } else {
                block.setType(Material.WATER);
            }
        });
    }

    private void checkBlock(Block block, BoundingBox boundingBox, boolean isWaterEntity, List<Block> airBlocks, List<Block> waterBlocks) {
        if (block.getBoundingBox().overlaps(boundingBox)) {
            airBlocks.add(block);
        }
        if (isWaterEntity) {
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Waterlogged) {
                Waterlogged waterlogged = (Waterlogged)blockData;
                if (block.getBoundingBox().overlaps(boundingBox) || !waterlogged.isWaterlogged()) {
                    waterBlocks.add(block);
                }
            } else if (block.getType() != Material.WATER) {
                waterBlocks.add(block);
            }
        }
    }
}

