/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.bentobox.api.events.island.IslandCreatedEvent;
import world.bentobox.bentobox.api.events.island.IslandResetEvent;
import world.bentobox.bentobox.api.user.User;

public class StartSafetyListener
implements Listener {
    private final AOneBlock addon;
    private final Map<UUID, Long> newIslands = new HashMap<UUID, Long>();

    public StartSafetyListener(AOneBlock addon) {
        this.addon = addon;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onNewIsland(IslandCreatedEvent e) {
        this.store(e.getIsland().getWorld(), e.getPlayerUUID());
    }

    private void store(World world, UUID playerUUID) {
        if (this.addon.inWorld(world) && this.addon.START_SAFETY.isSetForWorld(world) && !this.newIslands.containsKey(playerUUID)) {
            long time = this.addon.getSettings().getStartingSafetyDuration();
            if (time < 0L) {
                time = 10L;
            }
            this.newIslands.put(playerUUID, System.currentTimeMillis() + time * 1000L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.addon.getPlugin(), () -> {
                this.newIslands.remove(playerUUID);
                User.getInstance((UUID)playerUUID).sendMessage("protection.flags.START_SAFETY.free-to-move", new String[0]);
            }, time);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onResetIsland(IslandResetEvent e) {
        this.store(e.getIsland().getWorld(), e.getPlayerUUID());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent e) {
        if (this.addon.inWorld(e.getPlayer().getWorld()) && this.newIslands.containsKey(e.getPlayer().getUniqueId()) && e.getTo() != null && !e.getPlayer().isSneaking() && (e.getFrom().getX() != e.getTo().getX() || e.getFrom().getZ() != e.getTo().getZ())) {
            e.setTo(new Location(e.getFrom().getWorld(), e.getFrom().getX(), e.getTo().getY(), e.getFrom().getZ(), e.getTo().getYaw(), e.getTo().getPitch()));
            String waitTime = String.valueOf((int)((this.newIslands.get(e.getPlayer().getUniqueId()) - System.currentTimeMillis()) / 1000L));
            User.getInstance((Player)e.getPlayer()).notify(this.addon.START_SAFETY.getHintReference(), new String[]{"[number]", waitTime});
        }
    }
}

