/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.oneblocks;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import world.bentobox.aoneblock.oneblocks.OneBlockCustomBlock;
import world.bentobox.aoneblock.oneblocks.customblock.BlockDataCustomBlock;
import world.bentobox.aoneblock.oneblocks.customblock.MobCustomBlock;

public final class OneBlockCustomBlockCreator {
    private static final Map<String, Function<Map<?, ?>, Optional<? extends OneBlockCustomBlock>>> creatorMap = new LinkedHashMap();
    private static final List<Function<String, Optional<? extends OneBlockCustomBlock>>> shortCreatorList = new ArrayList<Function<String, Optional<? extends OneBlockCustomBlock>>>();

    private OneBlockCustomBlockCreator() {
    }

    public static void register(String type, Function<Map<?, ?>, Optional<? extends OneBlockCustomBlock>> creator) {
        creatorMap.put(type, creator);
    }

    public static void register(Function<String, Optional<? extends OneBlockCustomBlock>> creator) {
        shortCreatorList.add(creator);
    }

    public static Optional<OneBlockCustomBlock> create(Map<?, ?> map) {
        String type = Objects.toString(map.get("type"), null);
        if (type == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(creatorMap.get(type)).flatMap(builder -> (Optional)builder.apply(map));
    }

    public static Optional<OneBlockCustomBlock> create(String value) {
        for (Function<String, Optional<? extends OneBlockCustomBlock>> creator : shortCreatorList) {
            Optional<? extends OneBlockCustomBlock> customBlock = creator.apply(value);
            if (!customBlock.isPresent()) continue;
            return Optional.of(customBlock.get());
        }
        return Optional.empty();
    }

    static {
        OneBlockCustomBlockCreator.register("block-data", BlockDataCustomBlock::fromMap);
        OneBlockCustomBlockCreator.register("mob", MobCustomBlock::fromMap);
        OneBlockCustomBlockCreator.register("short", map -> {
            String type = Objects.toString(map.get("data"), null);
            if (type == null) {
                return Optional.empty();
            }
            return OneBlockCustomBlockCreator.create(type);
        });
    }
}

