/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.oneblocks.customblock;

import com.google.common.base.Enums;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.listeners.MakeSpace;
import world.bentobox.aoneblock.oneblocks.OneBlockCustomBlock;
import world.bentobox.bentobox.BentoBox;

public class MobCustomBlock
implements OneBlockCustomBlock {
    private final EntityType mob;
    private final Material underlyingBlock;

    public MobCustomBlock(EntityType mob, Material underlyingBlock) {
        this.mob = mob;
        this.underlyingBlock = underlyingBlock;
    }

    public static Optional<MobCustomBlock> fromMap(Map<?, ?> map) {
        String entityTypeValue = Objects.toString(map.get("mob"), null);
        if (entityTypeValue == null) {
            return Optional.empty();
        }
        String underlyingBlockValue = Objects.toString(map.get("underlying-block"), null);
        EntityType entityType = MobCustomBlock.maybeEntity(entityTypeValue);
        Material underlyingBlock = Material.getMaterial((String)underlyingBlockValue);
        if (underlyingBlock == null) {
            BentoBox.getInstance().logWarning("Underlying block " + underlyingBlockValue + " does not exist and will be replaced with STONE.");
        }
        return Optional.of(new MobCustomBlock(entityType, underlyingBlock));
    }

    private static EntityType maybeEntity(String entityTypeValue) {
        String name = entityTypeValue.toUpperCase(Locale.ENGLISH);
        EntityType et = name.equals("PIG_ZOMBIE") || name.equals("ZOMBIFIED_PIGLIN") ? (EntityType)Enums.getIfPresent(EntityType.class, (String)"ZOMBIFIED_PIGLIN").or((Object)((EntityType)Enums.getIfPresent(EntityType.class, (String)"PIG_ZOMBIE").or((Object)EntityType.PIG))) : (EntityType)Enums.getIfPresent(EntityType.class, (String)name).orNull();
        if (et == null) {
            BentoBox.getInstance().logWarning("Entity " + name + " does not exist and will not spawn when block is shown.");
            return null;
        }
        if (et.isSpawnable() && et.isAlive()) {
            return et;
        }
        BentoBox.getInstance().logWarning("Entity " + et.name() + " is not spawnable and will not spawn when block is shown.");
        return null;
    }

    @Override
    public void execute(AOneBlock addon, Block block) {
        try {
            block.setType(Objects.requireNonNullElse(this.underlyingBlock, Material.STONE));
            this.spawnEntity(addon, block, this.mob);
        }
        catch (Exception e) {
            BentoBox.getInstance().logError("Could not spawn entity " + this.mob.name() + " on block " + String.valueOf(block.getType()));
        }
    }

    private void spawnEntity(AOneBlock addon, @NonNull Block block, @NonNull EntityType mob) {
        Location spawnLoc = block.getLocation().add(new Vector(0.5, 1.0, 0.5));
        Entity entity = block.getWorld().spawnEntity(spawnLoc, mob);
        if (addon.getSettings().isClearBlocks()) {
            new MakeSpace(addon).makeSpace(entity, spawnLoc);
        }
        block.getWorld().playSound(block.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 2.0f);
    }

    public EntityType getMob() {
        return this.mob;
    }
}

