/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.panels;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.aoneblock.oneblocks.OneBlockPhase;
import world.bentobox.aoneblock.oneblocks.Requirement;
import world.bentobox.bank.Bank;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.TemplatedPanel;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.panels.builders.TemplatedPanelBuilder;
import world.bentobox.bentobox.api.panels.reader.ItemTemplateRecord;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.hooks.LangUtilsHook;
import world.bentobox.bentobox.util.Util;
import world.bentobox.level.Level;

public class PhasesPanel {
    private static final String PHASE = "PHASE";
    private static final String PREVIOUS = "PREVIOUS";
    private static final String NEXT = "NEXT";
    private static final String BIOME = "[biome]";
    private static final String BANK = "[bank]";
    private static final String ECONOMY = "[economy]";
    private static final String PERMISSION = "[permission]";
    private static final String LEVEL = "[level]";
    private static final String PHASE2 = "[phase]";
    private static final String INDEXING = "indexing";
    private static final String BLOCKS = "[blocks]";
    public static final String REFERENCE = "aoneblock.gui.buttons.phase.";
    private final AOneBlock addon;
    private final User user;
    private final World world;
    private final List<Map.Entry<Integer, OneBlockPhase>> elementList;
    private final OneBlockIslands oneBlockIsland;
    private final Island island;
    private int pageIndex;

    private PhasesPanel(AOneBlock addon, World world, User user) {
        this.addon = addon;
        this.user = user;
        this.world = world;
        this.elementList = addon.getOneBlockManager().getBlockProbs().entrySet().stream().filter(en -> !((OneBlockPhase)en.getValue()).isGotoPhase()).sorted(Comparator.comparingInt(Map.Entry::getKey)).toList();
        this.island = this.addon.getIslandsManager().getIsland(world, user);
        this.oneBlockIsland = this.island == null ? null : this.addon.getBlockListener().getIsland(this.island);
    }

    private void build() {
        if (this.elementList.isEmpty()) {
            this.addon.logError("There are no available phases for selection!");
            this.user.sendMessage("no-phases", new String[]{"[gamemode]", this.addon.getDescription().getName()});
            return;
        }
        TemplatedPanelBuilder panelBuilder = new TemplatedPanelBuilder();
        panelBuilder.template("phases_panel", new File(this.addon.getDataFolder(), "panels"));
        panelBuilder.user(this.user);
        panelBuilder.world(this.user.getWorld());
        panelBuilder.registerTypeBuilder(PHASE, this::createPhaseButton);
        panelBuilder.registerTypeBuilder(NEXT, this::createNextButton);
        panelBuilder.registerTypeBuilder(PREVIOUS, this::createPreviousButton);
        panelBuilder.build();
    }

    private @Nullable PanelItem createNextButton(@NonNull ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        int size = this.elementList.size();
        if (size <= slot.amountMap().getOrDefault(PHASE, 1) || 1.0 * (double)size / (double)slot.amountMap().getOrDefault(PHASE, 1).intValue() <= (double)(this.pageIndex + 1)) {
            return null;
        }
        int nextPageIndex = this.pageIndex + 2;
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            ItemStack clone = template.icon().clone();
            if (template.dataMap().getOrDefault(INDEXING, false).booleanValue()) {
                clone.setAmount(nextPageIndex);
            }
            builder.icon(clone);
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.world, template.title(), new String[0]));
        }
        if (template.description() != null) {
            builder.description(this.user.getTranslation(this.world, template.description(), new String[]{"[number]", String.valueOf(nextPageIndex)}));
        }
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && NEXT.equalsIgnoreCase(action.actionType())) {
                    ++this.pageIndex;
                    this.build();
                }
            });
            return true;
        });
        List tooltips = template.actions().stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.world, action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(template.actions().size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    private @Nullable PanelItem createPreviousButton(@NonNull ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.pageIndex == 0) {
            return null;
        }
        int previousPageIndex = this.pageIndex;
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            ItemStack clone = template.icon().clone();
            if (template.dataMap().getOrDefault(INDEXING, false).booleanValue()) {
                clone.setAmount(previousPageIndex);
            }
            builder.icon(clone);
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.world, template.title(), new String[0]));
        }
        if (template.description() != null) {
            builder.description(this.user.getTranslation(this.world, template.description(), new String[]{"[number]", String.valueOf(previousPageIndex)}));
        }
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && PREVIOUS.equalsIgnoreCase(action.actionType())) {
                    --this.pageIndex;
                    this.build();
                }
            });
            return true;
        });
        List tooltips = template.actions().stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.world, action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(template.actions().size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    private @Nullable PanelItem createPhaseButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.elementList.isEmpty()) {
            return null;
        }
        int index = this.pageIndex * slot.amountMap().getOrDefault(PHASE, 1) + slot.slot();
        if (index >= this.elementList.size()) {
            return null;
        }
        return this.createPhaseButton(template, this.elementList.get(index));
    }

    private PanelItem createPhaseButton(ItemTemplateRecord template, Map.Entry<Integer, OneBlockPhase> phaseEntry) {
        boolean canApply;
        String descriptionText;
        if (phaseEntry == null || phaseEntry.getValue() == null) {
            return null;
        }
        OneBlockPhase phase = phaseEntry.getValue();
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            builder.icon(template.icon().clone());
        } else {
            ItemStack firstBlock = phase.getFirstBlock() == null ? new ItemStack(Material.STONE) : new ItemStack(phase.getFirstBlock().getMaterial());
            builder.icon(phase.getIconBlock() == null ? firstBlock : phase.getIconBlock());
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.world, template.title(), new String[]{PHASE2, phase.getPhaseName()}));
        } else {
            builder.name(this.user.getTranslation("aoneblock.gui.buttons.phase.name", new String[]{PHASE2, phase.getPhaseName()}));
        }
        StringBuilder bankText = new StringBuilder();
        StringBuilder economyText = new StringBuilder();
        StringBuilder permissionText = new StringBuilder();
        StringBuilder levelText = new StringBuilder();
        phase.getRequirements().forEach(requirement -> {
            switch (requirement.getType()) {
                case ECO: {
                    economyText.append(this.user.getTranslationOrNothing("aoneblock.gui.buttons.phase.economy", new String[]{"[number]", String.valueOf(requirement.getEco())}));
                    break;
                }
                case BANK: {
                    bankText.append(this.user.getTranslationOrNothing("aoneblock.gui.buttons.phase.bank", new String[]{"[number]", String.valueOf(requirement.getBank())}));
                    break;
                }
                case LEVEL: {
                    levelText.append(this.user.getTranslationOrNothing("aoneblock.gui.buttons.phase.level", new String[]{"[number]", String.valueOf(requirement.getLevel())}));
                    break;
                }
                case PERMISSION: {
                    permissionText.append(this.user.getTranslationOrNothing("aoneblock.gui.buttons.phase.permission", new String[]{PERMISSION, requirement.getPermission()}));
                    break;
                }
                case COOLDOWN: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)requirement.getType()));
                }
            }
        });
        Object blocksText = this.user.getTranslation("aoneblock.gui.buttons.phase.blocks-prefix", new String[0]) + phase.getBlocks().keySet().stream().map(m -> this.getMaterialName(this.user, (Material)m)).map(string -> this.user.getTranslation("aoneblock.gui.buttons.phase.blocks", new String[]{"[name]", string})).collect(Collectors.joining());
        blocksText = ((String)blocksText).trim();
        if (((String)blocksText).endsWith("\n") || ((String)blocksText).endsWith(",")) {
            blocksText = ((String)blocksText).substring(0, ((String)blocksText).length() - 1);
        }
        int wrapAt = 50;
        try {
            wrapAt = Integer.valueOf(this.user.getTranslation("aoneblock.gui.buttons.phase.wrap-at", new String[0]));
        }
        catch (NumberFormatException e) {
            this.addon.logError("Warning: Unable to parse 'wrap-at' value, using default of 50.");
        }
        String formattedText = PhasesPanel.insertNewlines((String)blocksText, wrapAt);
        if (template.description() != null) {
            String biomeText = phase.getPhaseBiome() == null ? "" : LangUtilsHook.getBiomeName((Biome)phase.getPhaseBiome(), (User)this.user);
            descriptionText = this.user.getTranslationOrNothing(template.description(), new String[]{"[number]", phase.getBlockNumber(), BIOME, biomeText, BANK, bankText.toString(), ECONOMY, economyText.toString(), LEVEL, levelText.toString(), PERMISSION, permissionText.toString(), BLOCKS, formattedText});
        } else {
            String blockText = this.user.getTranslationOrNothing("aoneblock.gui.buttons.phase.starting-block", new String[]{"[number]", phase.getBlockNumber()});
            String biomeText = phase.getPhaseBiome() == null ? "" : this.user.getTranslationOrNothing("aoneblock.gui.buttons.phase.biome", new String[]{BIOME, LangUtilsHook.getBiomeName((Biome)phase.getPhaseBiome(), (User)this.user)});
            descriptionText = this.user.getTranslationOrNothing("aoneblock.gui.buttons.phase.description", new String[]{"[starting-block]", biomeText, BIOME, blockText, BANK, bankText.toString(), ECONOMY, economyText.toString(), LEVEL, levelText.toString(), PERMISSION, permissionText.toString(), BLOCKS, formattedText});
        }
        descriptionText = descriptionText.replaceAll("(?m)^[ \\t]*\\r?\\n", "").replaceAll("(?<!\\\\)\\|", "\n").replaceAll("\\\\\\|", "|");
        builder.description(descriptionText);
        if (this.island != null && this.oneBlockIsland != null) {
            long lifetime = this.oneBlockIsland.getLifetime();
            canApply = (long)phase.getBlockNumberValue() < lifetime ? !this.phaseRequirementsFail(phase, this.oneBlockIsland) : false;
        } else {
            canApply = false;
        }
        List<ItemTemplateRecord.ActionRecords> actions = template.actions().stream().filter(action -> switch (action.actionType().toUpperCase()) {
            case "SELECT" -> canApply;
            case "VIEW" -> true;
            default -> false;
        }).toList();
        builder.glow(this.oneBlockIsland != null && this.oneBlockIsland.getPhaseName().equals(phase.getPhaseName()));
        builder.clickHandler((panel, user, clickType, i) -> {
            actions.forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && "SELECT".equalsIgnoreCase(action.actionType())) {
                    this.runCommandCall(this.addon.getSettings().getSetCountCommand().split(" ")[0], phase);
                }
            });
            return true;
        });
        List tooltips = actions.stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.world, action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(actions.size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    private String getMaterialName(User user, Material m) {
        return this.addon.getPlugin().getHooks().getHook("LangUtils").map(hook -> LangUtilsHook.getMaterialName((Material)m, (User)user)).orElse(Util.prettifyText((String)m.name()));
    }

    private static String insertNewlines(String input, int interval) {
        StringBuilder result = new StringBuilder(input.length());
        int index = 0;
        char activeColor = 'a';
        int lastAmpIndex = -2;
        while (index < input.length()) {
            if (input.charAt(index) == '\u00a7' && index < input.length() - 1) {
                lastAmpIndex = index;
                activeColor = input.charAt(index + 1);
            }
            if (input.length() < index + interval) {
                result.append(input.substring(index));
                break;
            }
            int breakPoint = input.lastIndexOf(32, index + interval);
            if (breakPoint <= index) {
                breakPoint = index + interval;
            }
            result.append(input.substring(index, breakPoint)).append('\n');
            if (lastAmpIndex >= 0) {
                result.append('\u00a7');
                result.append(activeColor);
                result.append(" ");
            }
            index = breakPoint + 1;
        }
        return result.toString();
    }

    private boolean phaseRequirementsFail(OneBlockPhase phase, OneBlockIslands is) {
        block7: for (Requirement requirement : phase.getRequirements()) {
            switch (requirement.getType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case LEVEL: {
                    if (!this.addon.getAddonByName("Level").filter(Addon::isEnabled).map(a -> ((Level)a).getIslandLevel(this.world, this.island.getOwner()) < requirement.getLevel()).orElse(false).booleanValue()) continue block7;
                    break;
                }
                case BANK: {
                    if (!this.addon.getAddonByName("Bank").filter(Addon::isEnabled).map(a -> ((Bank)a).getBankManager().getBalance(this.island).getValue() < requirement.getBank()).orElse(false).booleanValue()) continue block7;
                    break;
                }
                case ECO: {
                    if (!this.addon.getPlugin().getVault().map(a -> a.getBalance(this.user, this.world) < requirement.getEco()).orElse(false).booleanValue()) continue block7;
                    break;
                }
                case PERMISSION: {
                    if (this.user == null || this.user.hasPermission(requirement.getPermission())) continue block7;
                    break;
                }
                case COOLDOWN: {
                    if (requirement.getCooldown() - (System.currentTimeMillis() - is.getLastPhaseChangeTime()) / 1000L <= 0L) continue block7;
                }
            }
            return true;
        }
        return false;
    }

    private void runCommandCall(String command, OneBlockPhase phase) {
        this.addon.getPlayerCommand().ifPresent(mainCommand -> mainCommand.getSubCommand(command).ifPresent(subCommand -> {
            if (Arrays.stream(this.addon.getSettings().getSetCountCommand().split(" ")).anyMatch(text -> text.equalsIgnoreCase(subCommand.getLabel()))) {
                this.addon.log(this.user.getName() + " called: `" + mainCommand.getTopLabel() + " " + subCommand.getLabel() + " " + phase.getBlockNumber());
                this.user.performCommand(mainCommand.getTopLabel() + " " + subCommand.getLabel() + " " + phase.getBlockNumber());
            }
        }));
        this.user.closeInventory();
    }

    public static void openPanel(AOneBlock addon, World world, User user) {
        new PhasesPanel(addon, world, user).build();
    }
}

