/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bukkit.Material;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.hooks.LangUtilsHook;
import world.bentobox.bentobox.managers.PlaceholdersManager;
import world.bentobox.bentobox.util.Util;

public class AOneBlockPlaceholders {
    private static final TreeMap<Double, String> SCALE = new TreeMap();
    private static final String INFINITE = "aoneblock.placeholders.infinite";
    private final AOneBlock addon;

    public AOneBlockPlaceholders(AOneBlock addon, PlaceholdersManager placeholdersManager) {
        this.addon = addon;
        placeholdersManager.registerPlaceholder((Addon)addon, "visited_island_phase", this::getPhaseByLocation);
        placeholdersManager.registerPlaceholder((Addon)addon, "visited_island_count", this::getCountByLocation);
        placeholdersManager.registerPlaceholder((Addon)addon, "my_island_phase", this::getPhase);
        placeholdersManager.registerPlaceholder((Addon)addon, "my_island_count", this::getCount);
        placeholdersManager.registerPlaceholder((Addon)addon, "visited_island_next_phase", this::getNextPhaseByLocation);
        placeholdersManager.registerPlaceholder((Addon)addon, "my_island_next_phase", this::getNextPhase);
        placeholdersManager.registerPlaceholder((Addon)addon, "my_island_blocks_for_phase", this::getPhaseBlocks);
        placeholdersManager.registerPlaceholder((Addon)addon, "my_island_blocks_to_next_phase", this::getNextPhaseBlocks);
        placeholdersManager.registerPlaceholder((Addon)addon, "visited_island_blocks_to_next_phase", this::getNextPhaseBlocksByLocation);
        placeholdersManager.registerPlaceholder((Addon)addon, "my_island_percent_done", this::getPercentDone);
        placeholdersManager.registerPlaceholder((Addon)addon, "visited_island_percent_done", this::getPercentDoneByLocation);
        placeholdersManager.registerPlaceholder((Addon)addon, "my_island_done_scale", this::getDoneScale);
        placeholdersManager.registerPlaceholder((Addon)addon, "visited_island_done_scale", this::getDoneScaleByLocation);
        placeholdersManager.registerPlaceholder((Addon)addon, "visited_island_lifetime_count", this::getLifetimeByLocation);
        placeholdersManager.registerPlaceholder((Addon)addon, "my_island_lifetime_count", this::getLifetime);
        placeholdersManager.registerPlaceholder((Addon)addon, "visited_island_phase_block_list", this::getPhaseBlocksNamesByLocation);
        placeholdersManager.registerPlaceholder((Addon)addon, "my_island_phase_block_list", this::getPhaseBlocksNames);
    }

    private Optional<Island> getUsersIsland(User user) {
        Island i = this.addon.getIslands().getIsland(this.addon.getOverWorld(), user);
        if (i != null && i.getOwner() != null && user.getUniqueId().equals(i.getOwner())) {
            return Optional.ofNullable(i);
        }
        List<Island> ownedIslands = this.addon.getIslands().getIslands(this.addon.getOverWorld(), user).stream().filter(is -> user.getUniqueId().equals(is.getOwner())).toList();
        if (ownedIslands.size() == 1) {
            i = ownedIslands.get(0);
        }
        return Optional.ofNullable(i);
    }

    public String getPhaseBlocksNames(User user) {
        if (user == null || user.getUniqueId() == null) {
            return "";
        }
        return this.getUsersIsland(user).map(i -> this.getPhaseBlocksForIsland(user, (Island)i)).orElse("");
    }

    private String getPhaseBlocksForIsland(User user, Island i) {
        String phaseName = this.addon.getOneBlocksIsland(i).getPhaseName();
        Set set = this.addon.getOneBlockManager().getPhase(phaseName).map(phase -> phase.getBlocks().keySet()).orElse(null);
        if (set == null) {
            return "";
        }
        String result = set.stream().map(m -> this.getMaterialName(user, (Material)m)).map(string -> user.getTranslation("aoneblock.gui.buttons.phase.blocks", new String[]{"[name]", string})).collect(Collectors.joining());
        if ((result = result.trim()).endsWith("\n") || result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private String getMaterialName(User user, Material m) {
        return this.addon.getPlugin().getHooks().getHook("LangUtils").map(hook -> LangUtilsHook.getMaterialName((Material)m, (User)user)).orElse(Util.prettifyText((String)m.name()));
    }

    public String getPhaseBlocksNamesByLocation(User user) {
        if (user == null || user.getUniqueId() == null || !this.addon.inWorld(user.getWorld())) {
            return "";
        }
        return this.addon.getIslands().getIslandAt(user.getLocation()).map(i -> this.getPhaseBlocksForIsland(user, (Island)i)).orElse("");
    }

    public String getPhaseByLocation(User user) {
        if (user == null || user.getUniqueId() == null) {
            return "";
        }
        return this.addon.getIslands().getProtectedIslandAt(Objects.requireNonNull(user.getLocation())).map(this.addon::getOneBlocksIsland).map(OneBlockIslands::getPhaseName).orElse("");
    }

    public String getCountByLocation(User user) {
        if (user == null || user.getUniqueId() == null || !this.addon.inWorld(user.getWorld())) {
            return "";
        }
        return this.addon.getIslands().getProtectedIslandAt(Objects.requireNonNull(user.getLocation())).map(this.addon::getOneBlocksIsland).map(OneBlockIslands::getBlockNumber).map(String::valueOf).orElse("");
    }

    public String getPhase(User user) {
        if (user == null || user.getUniqueId() == null) {
            return "";
        }
        return this.getUsersIsland(user).map(i -> this.addon.getOneBlocksIsland((Island)i).getPhaseName()).orElse("");
    }

    public String getCount(User user) {
        if (user == null || user.getUniqueId() == null) {
            return "";
        }
        return this.getUsersIsland(user).map(i -> String.valueOf(this.addon.getOneBlocksIsland((Island)i).getBlockNumber())).orElse("");
    }

    public String getNextPhaseByLocation(User user) {
        if (user == null || user.getUniqueId() == null || !this.addon.inWorld(user.getWorld())) {
            return "";
        }
        return this.addon.getIslands().getProtectedIslandAt(Objects.requireNonNull(user.getLocation())).map(this.addon::getOneBlocksIsland).map(this.addon.getOneBlockManager()::getNextPhase).orElse("");
    }

    public String getNextPhase(User user) {
        if (user == null || user.getUniqueId() == null) {
            return "";
        }
        return this.getUsersIsland(user).map(i -> this.addon.getOneBlockManager().getNextPhase(this.addon.getOneBlocksIsland((Island)i))).orElse("");
    }

    public String getNextPhaseBlocksByLocation(User user) {
        if (user == null || user.getUniqueId() == null || !this.addon.inWorld(user.getWorld())) {
            return "";
        }
        return this.addon.getIslands().getProtectedIslandAt(Objects.requireNonNull(user.getLocation())).map(this.addon::getOneBlocksIsland).map(this.addon.getOneBlockManager()::getNextPhaseBlocks).map(num -> num < 0 ? user.getTranslation(INFINITE, new String[0]) : String.valueOf(num)).orElse("");
    }

    public String getNextPhaseBlocks(User user) {
        if (user == null || user.getUniqueId() == null) {
            return "";
        }
        return this.getUsersIsland(user).map(i -> {
            int num = this.addon.getOneBlockManager().getNextPhaseBlocks(this.addon.getOneBlocksIsland((Island)i));
            return num < 0 ? user.getTranslation(INFINITE, new String[0]) : String.valueOf(num);
        }).orElse("");
    }

    public String getPhaseBlocks(User user) {
        if (user == null || user.getUniqueId() == null) {
            return "";
        }
        return this.getUsersIsland(user).map(i -> {
            int num = this.addon.getOneBlockManager().getPhaseBlocks(this.addon.getOneBlocksIsland((Island)i));
            return num < 0 ? user.getTranslation(INFINITE, new String[0]) : String.valueOf(num);
        }).orElse("");
    }

    public String getPercentDoneByLocation(User user) {
        if (user == null || user.getUniqueId() == null || !this.addon.inWorld(user.getWorld())) {
            return "";
        }
        return this.addon.getIslands().getProtectedIslandAt(Objects.requireNonNull(user.getLocation())).map(this.addon::getOneBlocksIsland).map(this.addon.getOneBlockManager()::getPercentageDone).map(num -> Math.round(num) + "%").orElse("");
    }

    public String getPercentDone(User user) {
        if (user == null || user.getUniqueId() == null) {
            return "";
        }
        return this.getUsersIsland(user).map(i -> {
            double num = this.addon.getOneBlockManager().getPercentageDone(this.addon.getOneBlocksIsland((Island)i));
            return Math.round(num) + "%";
        }).orElse("");
    }

    public String getDoneScaleByLocation(User user) {
        if (user == null || user.getUniqueId() == null || !this.addon.inWorld(user.getWorld())) {
            return "";
        }
        return this.addon.getIslands().getProtectedIslandAt(Objects.requireNonNull(user.getLocation())).map(this.addon::getOneBlocksIsland).map(this.addon.getOneBlockManager()::getPercentageDone).map(num -> SCALE.floorEntry((Double)num).getValue()).map(s -> s.replace("\u254d", this.addon.getSettings().getPercentCompleteSymbol())).orElse("");
    }

    public String getDoneScale(User user) {
        if (user == null || user.getUniqueId() == null) {
            return "";
        }
        return this.getUsersIsland(user).map(i -> {
            double num = this.addon.getOneBlockManager().getPercentageDone(this.addon.getOneBlocksIsland((Island)i));
            return SCALE.floorEntry(num).getValue().replace("\u254d", this.addon.getSettings().getPercentCompleteSymbol());
        }).orElse("");
    }

    public String getLifetime(User user) {
        if (user == null || user.getUniqueId() == null) {
            return "";
        }
        return this.getUsersIsland(user).map(i -> String.valueOf(this.addon.getOneBlocksIsland((Island)i).getLifetime())).orElse("");
    }

    public String getLifetimeByLocation(User user) {
        if (user == null || user.getUniqueId() == null || !this.addon.inWorld(user.getWorld())) {
            return "";
        }
        return this.addon.getIslands().getProtectedIslandAt(Objects.requireNonNull(user.getLocation())).map(this.addon::getOneBlocksIsland).map(OneBlockIslands::getLifetime).map(String::valueOf).orElse("");
    }

    static {
        SCALE.put(0.0, "&c\u254d\u254d\u254d\u254d\u254d\u254d\u254d\u254d");
        SCALE.put(12.5, "&a\u254d&c\u254d\u254d\u254d\u254d\u254d\u254d\u254d");
        SCALE.put(25.0, "&a\u254d\u254d&c\u254d\u254d\u254d\u254d\u254d\u254d");
        SCALE.put(37.5, "&a\u254d\u254d\u254d&c\u254d\u254d\u254d\u254d\u254d");
        SCALE.put(50.0, "&a\u254d\u254d\u254d\u254d&c\u254d\u254d\u254d\u254d");
        SCALE.put(62.5, "&a\u254d\u254d\u254d\u254d\u254d&c\u254d\u254d\u254d");
        SCALE.put(75.0, "&a\u254d\u254d\u254d\u254d\u254d\u254d&c\u254d\u254d");
        SCALE.put(87.5, "&a\u254d\u254d\u254d\u254d\u254d\u254d\u254d&c\u254d");
        SCALE.put(100.0, "&a\u254d\u254d\u254d\u254d\u254d\u254d\u254d\u254d");
    }
}

