/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.configuration.ConfigComment;
import world.bentobox.bentobox.api.configuration.ConfigEntry;
import world.bentobox.bentobox.api.configuration.StoreAt;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.database.objects.adapters.Adapter;
import world.bentobox.bentobox.database.objects.adapters.FlagBooleanSerializer;

@StoreAt(filename="config.yml", path="addons/AOneBlock")
@ConfigComment(value="AOneBlock Configuration [version]")
public class Settings
implements WorldSettings {
    @ConfigComment.Line(value={@ConfigComment(value="Player command. What command users will run to access their island."), @ConfigComment(value="To define alias, just separate commands with white space.")})
    @ConfigEntry(path="aoneblock.command.island", since="1.3.0")
    private String playerCommandAliases = "ob oneblock";
    @ConfigComment.Line(value={@ConfigComment(value="The admin command."), @ConfigComment(value="To define alias, just separate commands with white space.")})
    @ConfigEntry(path="aoneblock.command.admin", since="1.3.0")
    private String adminCommandAliases = "oba obadmin";
    @ConfigComment.Line(value={@ConfigComment(value="The default action for new player command call."), @ConfigComment(value="Sub-command of main player command that will be run on first player command call."), @ConfigComment(value="By default it is sub-command 'create'.")})
    @ConfigEntry(path="aoneblock.command.new-player-action", since="1.2.0")
    private String defaultNewPlayerAction = "create";
    @ConfigComment.Line(value={@ConfigComment(value="The default action for player command."), @ConfigComment(value="Sub-command of main player command that will be run on each player command call."), @ConfigComment(value="By default it is sub-command 'go'.")})
    @ConfigEntry(path="aoneblock.command.default-action", since="1.2.0")
    private String defaultPlayerAction = "go";
    @ConfigComment.Line(value={@ConfigComment(value="The command label that shows current phase progress."), @ConfigComment(value="By default it is 'count'.")})
    @ConfigEntry(path="aoneblock.command.count-command", since="1.10.0")
    private String countCommand = "count";
    @ConfigComment.Line(value={@ConfigComment(value="The command label that opens phases GUI."), @ConfigComment(value="By default it is 'phases'.")})
    @ConfigEntry(path="aoneblock.command.phases-command", since="1.10.0")
    private String phasesCommand = "phases";
    @ConfigComment.Line(value={@ConfigComment(value="The command label that allows to change island phase."), @ConfigComment(value="By default it is 'setCount'.")})
    @ConfigEntry(path="aoneblock.command.set-count-command", since="1.10.0")
    private String setCountCommand = "setCount";
    @ConfigComment.Line(value={@ConfigComment(value="The command label that toggers the progress bar."), @ConfigComment(value="By default it is 'bossbar'.")})
    @ConfigEntry(path="aoneblock.command.bossbar-command", since="1.19.0")
    private String bossBarCommand = "bossbar";
    @ConfigComment.Line(value={@ConfigComment(value="How long a player must wait until they can use the setCount command again. In minutes."), @ConfigComment(value="This is the command that is run from the phases panel.")})
    @ConfigEntry(path="aoneblock.command.set-count-cooldown", since="1.13.0")
    private int setCountCooldown = 5;
    @ConfigComment.Line(value={@ConfigComment(value="The command label that allows to check if magic block is present and respawns it if not."), @ConfigComment(value="By default it is 'respawnBlock check'.")})
    @ConfigEntry(path="aoneblock.command.respawn-block-command", since="1.10.0")
    private String respawnBlockCommand = "respawnBlock check";
    @ConfigComment.Line(value={@ConfigComment(value="Placeholder customization"), @ConfigComment(value="Symbol for the percentage completed scale bar")})
    @ConfigEntry(path="aoneblock.placeholders.scale-symbol", since="1.9.0")
    private String percentCompleteSymbol = "\u25a0";
    @ConfigComment(value="Friendly name for this world. Used in admin commands. Must be a single word")
    @ConfigEntry(path="world.friendly-name")
    private String friendlyName = "OneBlock";
    @ConfigComment.Line(value={@ConfigComment(value="Name of the world - if it does not exist then it will be generated."), @ConfigComment(value="It acts like a prefix for nether and end (e.g. oneblock_world, oneblock_world_nether, oneblock_world_end)")})
    @ConfigEntry(path="world.world-name")
    private String worldName = "oneblock_world";
    @ConfigComment.Line(value={@ConfigComment(value="World difficulty setting - PEACEFUL, EASY, NORMAL, HARD"), @ConfigComment(value="Other plugins may override this setting")})
    @ConfigEntry(path="world.difficulty")
    private Difficulty difficulty = Difficulty.NORMAL;
    @ConfigComment(value="Display holograms")
    @ConfigEntry(path="world.holograms")
    private boolean useHolograms = true;
    @ConfigComment(value="Hologram position - the offset to the magic block where holograms will appear")
    @ConfigEntry(path="world.hologram-offset")
    private String offset = "0.5, 1.1, 0.5";
    @ConfigComment.Line(value={@ConfigComment(value="Duration in seconds that phase holograms will exist after being displayed, if used."), @ConfigComment(value="If set to 0, then holograms will persist until cleared some other way.")})
    @ConfigEntry(path="world.hologram-duration")
    private int hologramDuration = 10;
    @ConfigComment.Line(value={@ConfigComment(value="Duration in seconds that players cannot move when they start a new one block."), @ConfigComment(value="Used only if the Starting Safety world setting is active.")})
    @ConfigEntry(path="world.starting-safety-duration")
    private int startingSafetyDuration = 10;
    @ConfigComment.Line(value={@ConfigComment(value="Block identification appearance."), @ConfigComment(value="Click type that will make particles appear. Options are:"), @ConfigComment(value="LEFT (default), RIGHT, or NONE")})
    @ConfigEntry(path="world.block-id.click-type")
    private String clickType = "LEFT";
    @ConfigComment(value="Size of particles. Default is 0.5. Must be greater than 0.")
    @ConfigEntry(path="world.block-id.particle-size")
    private Double particleSize = 0.5;
    @ConfigComment(value="Density of particles - Value from 0.1 to 1. Default is 0.65. Smaller values are more dense, higher are less.")
    @ConfigEntry(path="world.block-id.particle-density")
    private Double particleDensity = 0.65;
    @ConfigComment(value="Color of particles")
    @ConfigEntry(path="world.block-id.particle-color")
    private Color particleColor = Color.GREEN;
    @ConfigComment.Line(value={@ConfigComment(value="Clear blocks when spawning mobs."), @ConfigComment(value="Mobs break blocks when they spawn is to prevent players from building a box around the magic block,"), @ConfigComment(value="having the mob spawn, and then die by suffocation, i.e., it's a cheat prevention.")})
    @ConfigEntry(path="world.mobs-clear-blocks")
    private boolean clearBlocks = true;
    @ConfigComment.Line(value={@ConfigComment(value="Spawn limits. These override the limits set in bukkit.yml"), @ConfigComment(value="If set to a negative number, the server defaults will be used")})
    @ConfigEntry(path="world.spawn-limits.monsters", since="1.11.2")
    private int spawnLimitMonsters = -1;
    @ConfigEntry(path="world.spawn-limits.animals", since="1.11.2")
    private int spawnLimitAnimals = -1;
    @ConfigEntry(path="world.spawn-limits.water-animals", since="1.11.2")
    private int spawnLimitWaterAnimals = -1;
    @ConfigEntry(path="world.spawn-limits.ambient", since="1.11.2")
    private int spawnLimitAmbient = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Setting to 0 will disable animal spawns, but this is not recommended. Minecraft default is 400."), @ConfigComment(value="A negative value uses the server default")})
    @ConfigEntry(path="world.spawn-limits.ticks-per-animal-spawns", since="1.11.2")
    private int ticksPerAnimalSpawns = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Setting to 0 will disable monster spawns, but this is not recommended. Minecraft default is 400."), @ConfigComment(value="A negative value uses the server default")})
    @ConfigEntry(path="world.spawn-limits.ticks-per-monster-spawns", since="1.11.2")
    private int ticksPerMonsterSpawns = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Radius of island in blocks. (So distance between islands is twice this)"), @ConfigComment(value="It is the same for every dimension : Overworld, Nether and End."), @ConfigComment(value="This value cannot be changed mid-game and the plugin will not start if it is different.")})
    @ConfigEntry(path="world.distance-between-islands", needsReset=true)
    private int islandDistance = 400;
    @ConfigComment.Line(value={@ConfigComment(value="Default protection range radius in blocks. Cannot be larger than distance."), @ConfigComment(value="Admins can change protection sizes for players individually using /obadmin range set <player> <new range>"), @ConfigComment(value="or set this permission: aoneblock.island.range.<number>")})
    @ConfigEntry(path="world.protection-range")
    private int islandProtectionRange = 50;
    @ConfigComment.Line(value={@ConfigComment(value="Start islands at these coordinates. This is where new islands will start in the"), @ConfigComment(value="world. These must be a factor of your island distance, but the plugin will auto"), @ConfigComment(value="calculate the closest location on the grid. Islands develop around this location"), @ConfigComment(value="both positively and negatively in a square grid."), @ConfigComment(value="If none of this makes sense, leave it at 0,0.")})
    @ConfigEntry(path="world.start-x", needsReset=true)
    private int islandStartX = 0;
    @ConfigEntry(path="world.start-z", needsReset=true)
    private int islandStartZ = 0;
    @ConfigEntry(path="world.offset-x")
    private int islandXOffset;
    @ConfigEntry(path="world.offset-z")
    private int islandZOffset;
    @ConfigComment.Line(value={@ConfigComment(value="Island height - Lowest is 5."), @ConfigComment(value="It is the y coordinate of the bedrock block in the schem.")})
    @ConfigEntry(path="world.island-height")
    private int islandHeight = 120;
    @ConfigComment.Line(value={@ConfigComment(value="The number of concurrent islands a player can have in the world"), @ConfigComment(value="A value of 0 will use the BentoBox config.yml default")})
    @ConfigEntry(path="world.concurrent-islands")
    private int concurrentIslands = 0;
    @ConfigComment(value="Disallow team members from having their own islands.")
    @ConfigEntry(path="world.disallow-team-member-islands")
    private boolean disallowTeamMemberIslands = true;
    @ConfigComment.Line(value={@ConfigComment(value="Use your own world generator for this world."), @ConfigComment(value="In this case, the plugin will not generate anything."), @ConfigComment(value="If used, you must specify the world name and generator in the bukkit.yml file."), @ConfigComment(value="See https://bukkit.gamepedia.com/Bukkit.yml#.2AOPTIONAL.2A_worlds")})
    @ConfigEntry(path="world.use-own-generator")
    private boolean useOwnGenerator;
    @ConfigComment.Line(value={@ConfigComment(value="Sea height (don't changes this mid-game unless you delete the world)"), @ConfigComment(value="Minimum is 0"), @ConfigComment(value="If sea height is less than about 10, then players will drop right through it"), @ConfigComment(value="if it exists.")})
    @ConfigEntry(path="world.sea-height", needsReset=true)
    private int seaHeight = 0;
    @ConfigComment.Line(value={@ConfigComment(value="Maximum number of islands in the world. Set to -1 or 0 for unlimited."), @ConfigComment(value="If the number of islands is greater than this number, it will stop players from creating islands.")})
    @ConfigEntry(path="world.max-islands")
    private int maxIslands = -1;
    @ConfigComment.Line(value={@ConfigComment(value="The default game mode for this world. Players will be set to this mode when they create"), @ConfigComment(value="a new island for example. Options are SURVIVAL, CREATIVE, ADVENTURE, SPECTATOR")})
    @ConfigEntry(path="world.default-game-mode")
    private GameMode defaultGameMode = GameMode.SURVIVAL;
    @ConfigComment(value="The default biome for the overworld")
    @ConfigEntry(path="world.default-biome")
    private Biome defaultBiome;
    @ConfigComment(value="The default biome for the nether world (this may affect what mobs can spawn)")
    @ConfigEntry(path="world.default-nether-biome")
    private Biome defaultNetherBiome;
    @ConfigComment(value="The default biome for the end world (this may affect what mobs can spawn)")
    @ConfigEntry(path="world.default-end-biome")
    private Biome defaultEndBiome;
    @ConfigComment.Line(value={@ConfigComment(value="The maximum number of players a player can ban at any one time in this game mode."), @ConfigComment(value="The permission acidisland.ban.maxlimit.X where X is a number can also be used per player"), @ConfigComment(value="-1 = unlimited")})
    @ConfigEntry(path="world.ban-limit")
    private int banLimit = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Generate Nether - if this is false, the nether world will not be made and access to"), @ConfigComment(value="the nether will not occur. Other plugins may still enable portal usage."), @ConfigComment(value="Note: Some default challenges will not be possible if there is no nether."), @ConfigComment(value="Note that with a standard nether all players arrive at the same portal and entering a"), @ConfigComment(value="portal will return them back to their islands.")})
    @ConfigEntry(path="world.nether.generate")
    private boolean netherGenerate = true;
    @ConfigComment.Line(value={@ConfigComment(value="Islands in Nether. Change to false for standard vanilla nether."), @ConfigComment(value="Note that there is currently no magic block in the Nether")})
    @ConfigEntry(path="world.nether.islands", needsReset=true)
    private boolean netherIslands = false;
    @ConfigComment.Line(value={@ConfigComment(value="Make the nether roof, if false, there is nothing up there"), @ConfigComment(value="Change to false if lag is a problem from the generation"), @ConfigComment(value="Only applies to islands Nether")})
    @ConfigEntry(path="world.nether.roof")
    private boolean netherRoof = false;
    @ConfigComment.Line(value={@ConfigComment(value="Nether spawn protection radius - this is the distance around the nether spawn"), @ConfigComment(value="that will be protected from player interaction (breaking blocks, pouring lava etc.)"), @ConfigComment(value="Minimum is 0 (not recommended), maximum is 100. Default is 25."), @ConfigComment(value="Only applies to vanilla nether")})
    @ConfigEntry(path="world.nether.spawn-radius")
    private int netherSpawnRadius = 32;
    @ConfigComment.Line(value={@ConfigComment(value="This option indicates if nether portals should be linked via dimensions."), @ConfigComment(value="Option will simulate vanilla portal mechanics that links portals together"), @ConfigComment(value="or creates a new portal, if there is not a portal in that dimension."), @ConfigComment(value="This option requires `allow-nether=true` in server.properties.")})
    @ConfigEntry(path="world.nether.create-and-link-portals", since="1.16")
    private boolean makeNetherPortals = false;
    @ConfigComment.Line(value={@ConfigComment(value="End Nether - if this is false, the end world will not be made and access to"), @ConfigComment(value="the end will not occur. Other plugins may still enable portal usage.")})
    @ConfigEntry(path="world.end.generate")
    private boolean endGenerate = false;
    @ConfigComment.Line(value={@ConfigComment(value="Islands in The End. Change to false for standard vanilla end."), @ConfigComment(value="Note that there is currently no magic block in the End")})
    @ConfigEntry(path="world.end.islands", needsReset=true)
    private boolean endIslands = false;
    @ConfigComment.Line(value={@ConfigComment(value="This option indicates if obsidian platform in the end should be generated"), @ConfigComment(value="when player enters the end world."), @ConfigComment(value="This option requires `allow-end=true` in bukkit.yml.")})
    @ConfigEntry(path="world.end.create-obsidian-platform", since="1.16")
    private boolean makeEndPortals = false;
    @ConfigComment(value="Mob white list - these mobs will NOT be removed when logging in or doing /island")
    @ConfigEntry(path="world.remove-mobs-whitelist")
    private Set<EntityType> removeMobsWhitelist = new HashSet<EntityType>();
    @ConfigComment(value="World flags. These are boolean settings for various flags for this world")
    @ConfigEntry(path="world.flags")
    private Map<String, Boolean> worldFlags = new HashMap<String, Boolean>();
    @ConfigComment.Line(value={@ConfigComment(value="These are the default protection settings for new islands."), @ConfigComment(value="The value is the minimum island rank required allowed to do the action"), @ConfigComment(value="Ranks are the following:"), @ConfigComment(value="  VISITOR   = 0"), @ConfigComment(value="  COOP      = 200"), @ConfigComment(value="  TRUSTED   = 400"), @ConfigComment(value="  MEMBER    = 500"), @ConfigComment(value="  SUB-OWNER = 900"), @ConfigComment(value="  OWNER     = 1000")})
    @ConfigEntry(path="world.default-island-flags")
    private Map<String, Integer> defaultIslandFlagNames = new HashMap<String, Integer>();
    @ConfigComment(value="These are the default settings for new islands")
    @ConfigEntry(path="world.default-island-settings")
    @Adapter(value=FlagBooleanSerializer.class)
    private Map<String, Integer> defaultIslandSettingNames = new HashMap<String, Integer>();
    @ConfigComment.Line(value={@ConfigComment(value="These settings/flags are hidden from users"), @ConfigComment(value="Ops can toggle hiding in-game using SHIFT-LEFT-CLICK on flags in settings")})
    @ConfigEntry(path="world.hidden-flags", since="1.4.1")
    private List<String> hiddenFlags = new ArrayList<String>();
    @ConfigComment(value="Visitor banned commands - Visitors to islands cannot use these commands in this world")
    @ConfigEntry(path="world.visitor-banned-commands")
    private List<String> visitorBannedCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Falling banned commands - players cannot use these commands when falling"), @ConfigComment(value="if the PREVENT_TELEPORT_WHEN_FALLING world setting flag is active")})
    @ConfigEntry(path="world.falling-banned-commands", since="1.8.0")
    private List<String> fallingBannedCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Drop broken blocks on top of magic block"), @ConfigComment(value="If you want Jobs or other plugins to recognize magic block breaking this must be false")})
    @ConfigEntry(path="island.drop-on-top", since="1.3.0")
    private boolean dropOnTop = true;
    @ConfigComment.Line(value={@ConfigComment(value="Magic block mob warning"), @ConfigComment(value="Players might be able to hear hostile mobs up to this many blocks away"), @ConfigComment(value="Minimum is 0 (no warning), max is 5")})
    @ConfigEntry(path="island.mob-warning")
    private int mobWarning = 5;
    @ConfigComment(value="Whether spawned mobs that need water to survive will spawn in a generated water block")
    @ConfigEntry(path="island.water-mob-protection")
    private boolean waterMobProtection = true;
    @ConfigComment.Line(value={@ConfigComment(value="Default max team size"), @ConfigComment(value="Permission size cannot be less than the default below. ")})
    @ConfigEntry(path="island.max-team-size")
    private int maxTeamSize = 4;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of coop rank members per island"), @ConfigComment(value="Players can have the aoneblock.coop.maxsize.<number> permission to be bigger but"), @ConfigComment(value="permission size cannot be less than the default below. ")})
    @ConfigEntry(path="island.max-coop-size", since="1.13.0")
    private int maxCoopSize = 4;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of trusted rank members per island"), @ConfigComment(value="Players can have the aoneblock.trust.maxsize.<number> permission to be bigger but"), @ConfigComment(value="permission size cannot be less than the default below. ")})
    @ConfigEntry(path="island.max-trusted-size", since="1.13.0")
    private int maxTrustSize = 4;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of homes a player can have. Min = 1"), @ConfigComment(value="Accessed via /is sethome <number> or /is go <number>")})
    @ConfigEntry(path="island.max-homes")
    private int maxHomes = 5;
    @ConfigComment.Line(value={@ConfigComment(value="How many resets a player is allowed (manage with /obadmin reset add/remove/reset/set command)"), @ConfigComment(value="Value of -1 means unlimited, 0 means hardcore - no resets."), @ConfigComment(value="Example, 2 resets means they get 2 resets or 3 islands lifetime")})
    @ConfigEntry(path="island.reset.reset-limit")
    private int resetLimit = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Kicked or leaving players lose resets"), @ConfigComment(value="Players who leave a team will lose an island reset chance"), @ConfigComment(value="If a player has zero resets left and leaves a team, they cannot make a new"), @ConfigComment(value="island by themselves and can only join a team."), @ConfigComment(value="Leave this true to avoid players exploiting free islands")})
    @ConfigEntry(path="island.reset.leavers-lose-reset")
    private boolean leaversLoseReset = false;
    @ConfigComment.Line(value={@ConfigComment(value="Allow kicked players to keep their inventory."), @ConfigComment(value="Overrides the on-leave inventory reset for kicked players.")})
    @ConfigEntry(path="island.reset.kicked-keep-inventory")
    private boolean kickedKeepInventory = false;
    @ConfigComment.Line(value={@ConfigComment(value="What the addon should reset when the player joins or creates an island"), @ConfigComment(value="Reset Money - if this is true, will reset the player's money to the starting money"), @ConfigComment(value="Recommendation is that this is set to true, but if you run multi-worlds"), @ConfigComment(value="make sure your economy handles multi-worlds too.")})
    @ConfigEntry(path="island.reset.on-join.money")
    private boolean onJoinResetMoney = false;
    @ConfigComment.Line(value={@ConfigComment(value="Reset inventory - if true, the player's inventory will be cleared."), @ConfigComment(value="Note: if you have MultiInv running or a similar inventory control plugin, that"), @ConfigComment(value="plugin may still reset the inventory when the world changes.")})
    @ConfigEntry(path="island.reset.on-join.inventory")
    private boolean onJoinResetInventory = true;
    @ConfigComment(value="Reset health - if true, the player's health will be reset.")
    @ConfigEntry(path="island.reset.on-join.health", since="1.8.0")
    private boolean onJoinResetHealth = true;
    @ConfigComment(value="Reset hunger - if true, the player's hunger will be reset.")
    @ConfigEntry(path="island.reset.on-join.hunger", since="1.8.0")
    private boolean onJoinResetHunger = true;
    @ConfigComment(value="Reset experience points - if true, the player's experience will be reset.")
    @ConfigEntry(path="island.reset.on-join.exp", since="1.8.0")
    private boolean onJoinResetXP = true;
    @ConfigComment(value="Reset Ender Chest - if true, the player's Ender Chest will be cleared.")
    @ConfigEntry(path="island.reset.on-join.ender-chest")
    private boolean onJoinResetEnderChest = false;
    @ConfigComment.Line(value={@ConfigComment(value="What the plugin should reset when the player leaves or is kicked from an island"), @ConfigComment(value="Reset Money - if this is true, will reset the player's money to the starting money"), @ConfigComment(value="Recommendation is that this is set to true, but if you run multi-worlds"), @ConfigComment(value="make sure your economy handles multi-worlds too.")})
    @ConfigEntry(path="island.reset.on-leave.money")
    private boolean onLeaveResetMoney = false;
    @ConfigComment.Line(value={@ConfigComment(value="Reset inventory - if true, the player's inventory will be cleared."), @ConfigComment(value="Note: if you have MultiInv running or a similar inventory control plugin, that"), @ConfigComment(value="plugin may still reset the inventory when the world changes.")})
    @ConfigEntry(path="island.reset.on-leave.inventory")
    private boolean onLeaveResetInventory = false;
    @ConfigComment(value="Reset health - if true, the player's health will be reset.")
    @ConfigEntry(path="island.reset.on-leave.health", since="1.8.0")
    private boolean onLeaveResetHealth = false;
    @ConfigComment(value="Reset hunger - if true, the player's hunger will be reset.")
    @ConfigEntry(path="island.reset.on-leave.hunger", since="1.8.0")
    private boolean onLeaveResetHunger = false;
    @ConfigComment(value="Reset experience - if true, the player's experience will be reset.")
    @ConfigEntry(path="island.reset.on-leave.exp", since="1.8.0")
    private boolean onLeaveResetXP = false;
    @ConfigComment(value="Reset Ender Chest - if true, the player's Ender Chest will be cleared.")
    @ConfigEntry(path="island.reset.on-leave.ender-chest")
    private boolean onLeaveResetEnderChest = false;
    @ConfigComment.Line(value={@ConfigComment(value="Toggles the automatic island creation upon the player's first login on your server."), @ConfigComment(value="If set to true,"), @ConfigComment(value="   * Upon connecting to your server for the first time, the player will be told that"), @ConfigComment(value="    an island will be created for him."), @ConfigComment(value="  * Make sure you have a Blueprint Bundle called \"default\": this is the one that will"), @ConfigComment(value="    be used to create the island."), @ConfigComment(value="  * An island will be created for the player without needing him to run the create command."), @ConfigComment(value="If set to false, this will disable this feature entirely."), @ConfigComment(value="Warning:"), @ConfigComment(value="  * If you are running multiple gamemodes on your server, and all of them have"), @ConfigComment(value="    this feature enabled, an island in all the gamemodes will be created simultaneously."), @ConfigComment(value="    However, it is impossible to know on which island the player will be teleported to afterwards."), @ConfigComment(value="  * Island creation can be resource-intensive, please consider the options below to help mitigate"), @ConfigComment(value="    the potential issues, especially if you expect a lot of players to connect to your server"), @ConfigComment(value="    in a limited period of time.")})
    @ConfigEntry(path="island.create-island-on-first-login.enable", since="1.9.0")
    private boolean createIslandOnFirstLoginEnabled;
    @ConfigComment.Line(value={@ConfigComment(value="Time in seconds after the player logged in, before his island gets created."), @ConfigComment(value="If set to 0 or less, the island will be created directly upon the player's login."), @ConfigComment(value="It is recommended to keep this value under a minute's time.")})
    @ConfigEntry(path="island.create-island-on-first-login.delay", since="1.9.0")
    private int createIslandOnFirstLoginDelay = 5;
    @ConfigComment.Line(value={@ConfigComment(value="Toggles whether the island creation should be aborted if the player logged off while the"), @ConfigComment(value="delay (see the option above) has not worn off yet."), @ConfigComment(value="If set to true,"), @ConfigComment(value="  * If the player has logged off the server while the delay (see the option above) has not"), @ConfigComment(value="    worn off yet, this will cancel the island creation."), @ConfigComment(value="  * If the player relogs afterward, since he will not be recognized as a new player, no island"), @ConfigComment(value="    would be created for him."), @ConfigComment(value="  * If the island creation started before the player logged off, it will continue."), @ConfigComment(value="If set to false, the player's island will be created even if he went offline in the meantime."), @ConfigComment(value="Note this option has no effect if the delay (see the option above) is set to 0 or less.")})
    @ConfigEntry(path="island.create-island-on-first-login.abort-on-logout", since="1.9.0")
    private boolean createIslandOnFirstLoginAbortOnLogout = true;
    @ConfigComment.Line(value={@ConfigComment(value="Toggles whether the player should be teleported automatically to his island when it is created."), @ConfigComment(value="If set to false, the player will be told his island is ready but will have to teleport to his island using the command.")})
    @ConfigEntry(path="island.teleport-player-to-island-when-created", since="1.10.0")
    private boolean teleportPlayerToIslandUponIslandCreation = true;
    @ConfigComment.Line(value={@ConfigComment(value="Create Nether or End islands if they are missing when a player goes through a portal."), @ConfigComment(value="Nether and End islands are usually pasted when a player makes their island, but if they are"), @ConfigComment(value="missing for some reason, you can switch this on."), @ConfigComment(value="Note that bedrock removal glitches can exploit this option.")})
    @ConfigEntry(path="island.create-missing-nether-end-islands", since="1.10.0")
    private boolean pasteMissingIslands = false;
    @ConfigComment.Line(value={@ConfigComment(value="List of commands to run when a player joins an island or creates one."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * \"[SUDO] bbox version\""), @ConfigComment(value="   * \"obadmin deaths set [player] 0\"")})
    @ConfigEntry(path="island.commands.on-join", since="1.8.0")
    private List<String> onJoinCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="List of commands to run when a player leaves an island, resets his island or gets kicked from it."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * '[SUDO] bbox version'"), @ConfigComment(value="   * 'obadmin deaths set [player] 0'"), @ConfigComment(value=""), @ConfigComment(value="Note that player-executed commands might not work, as these commands can be run with said player being offline.")})
    @ConfigEntry(path="island.commands.on-leave", since="1.8.0")
    private List<String> onLeaveCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="List of commands that should be executed when the player respawns after death if Flags.ISLAND_RESPAWN is true."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * '[SUDO] bbox version'"), @ConfigComment(value="   * 'obadmin deaths set [player] 0'"), @ConfigComment(value=""), @ConfigComment(value="Note that player-executed commands might not work, as these commands can be run with said player being offline.")})
    @ConfigEntry(path="island.commands.on-respawn", since="1.14.0")
    private List<String> onRespawnCommands = new ArrayList<String>();
    @ConfigEntry(path="island.sethome.nether.allow")
    private boolean allowSetHomeInNether = true;
    @ConfigEntry(path="island.sethome.nether.require-confirmation")
    private boolean requireConfirmationToSetHomeInNether = true;
    @ConfigEntry(path="island.sethome.the-end.allow")
    private boolean allowSetHomeInTheEnd = true;
    @ConfigEntry(path="island.sethome.the-end.require-confirmation")
    private boolean requireConfirmationToSetHomeInTheEnd = true;
    @ConfigComment(value="Whether deaths are counted or not.")
    @ConfigEntry(path="island.deaths.counted")
    private boolean deathsCounted = true;
    @ConfigComment(value="Maximum number of deaths to count. The death count can be used by add-ons.")
    @ConfigEntry(path="island.deaths.max")
    private int deathsMax = 10;
    @ConfigComment(value="When a player joins a team, reset their death count")
    @ConfigEntry(path="island.deaths.team-join-reset")
    private boolean teamJoinDeathReset = true;
    @ConfigComment(value="Reset player death count when they start a new island or reset an island")
    @ConfigEntry(path="island.deaths.reset-on-new-island", since="1.6.0")
    private boolean deathsResetOnNewIsland = true;
    @ConfigComment.Line(value={@ConfigComment(value="Geo restrict mobs."), @ConfigComment(value="Mobs that exit the island space where they were spawned will be removed.")})
    @ConfigEntry(path="protection.geo-limit-settings")
    private List<String> geoLimitSettings = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="AOneBlock blocked mobs."), @ConfigComment(value="List of mobs that should not spawn in AOneBlock.")})
    @ConfigEntry(path="protection.block-mobs", since="1.2.0")
    private List<String> mobLimitSettings = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Invincible visitors. List of damages that will not affect visitors."), @ConfigComment(value="Make list blank if visitors should receive all damages")})
    @ConfigEntry(path="protection.invincible-visitors")
    private List<String> ivSettings = new ArrayList<String>();
    @ConfigComment(value="These settings should not be edited")
    @ConfigEntry(path="do-not-edit-these-settings.reset-epoch")
    private long resetEpoch = 0L;

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public int getIslandDistance() {
        return this.islandDistance;
    }

    public int getIslandProtectionRange() {
        return this.islandProtectionRange;
    }

    public int getIslandStartX() {
        return this.islandStartX;
    }

    public int getIslandStartZ() {
        return this.islandStartZ;
    }

    public int getIslandXOffset() {
        return this.islandXOffset;
    }

    public int getIslandZOffset() {
        return this.islandZOffset;
    }

    public int getIslandHeight() {
        return this.islandHeight;
    }

    public boolean isUseOwnGenerator() {
        return this.useOwnGenerator;
    }

    public int getSeaHeight() {
        return this.seaHeight;
    }

    public int getMaxIslands() {
        return this.maxIslands;
    }

    public GameMode getDefaultGameMode() {
        return this.defaultGameMode;
    }

    public boolean isNetherGenerate() {
        return this.netherGenerate;
    }

    public boolean isNetherIslands() {
        return this.netherIslands;
    }

    public boolean isNetherRoof() {
        return this.netherRoof;
    }

    public int getNetherSpawnRadius() {
        return this.netherSpawnRadius;
    }

    public boolean isEndGenerate() {
        return this.endGenerate;
    }

    public boolean isEndIslands() {
        return this.endIslands;
    }

    public boolean isDragonSpawn() {
        return false;
    }

    public Set<EntityType> getRemoveMobsWhitelist() {
        return this.removeMobsWhitelist;
    }

    public Map<String, Boolean> getWorldFlags() {
        return this.worldFlags;
    }

    public Map<String, Integer> getDefaultIslandFlagNames() {
        return this.defaultIslandFlagNames;
    }

    public Map<String, Integer> getDefaultIslandSettingNames() {
        return this.defaultIslandSettingNames;
    }

    @Deprecated
    public Map<Flag, Integer> getDefaultIslandFlags() {
        return Collections.emptyMap();
    }

    @Deprecated
    public Map<Flag, Integer> getDefaultIslandSettings() {
        return Collections.emptyMap();
    }

    public List<String> getHiddenFlags() {
        return this.hiddenFlags;
    }

    public List<String> getVisitorBannedCommands() {
        return this.visitorBannedCommands;
    }

    public List<String> getFallingBannedCommands() {
        return this.fallingBannedCommands;
    }

    public int getMaxTeamSize() {
        return this.maxTeamSize;
    }

    public int getMaxHomes() {
        return this.maxHomes;
    }

    public int getResetLimit() {
        return this.resetLimit;
    }

    public boolean isLeaversLoseReset() {
        return this.leaversLoseReset;
    }

    public boolean isKickedKeepInventory() {
        return this.kickedKeepInventory;
    }

    public boolean isCreateIslandOnFirstLoginEnabled() {
        return this.createIslandOnFirstLoginEnabled;
    }

    public int getCreateIslandOnFirstLoginDelay() {
        return this.createIslandOnFirstLoginDelay;
    }

    public boolean isCreateIslandOnFirstLoginAbortOnLogout() {
        return this.createIslandOnFirstLoginAbortOnLogout;
    }

    public boolean isOnJoinResetMoney() {
        return this.onJoinResetMoney;
    }

    public boolean isOnJoinResetInventory() {
        return this.onJoinResetInventory;
    }

    public boolean isOnJoinResetEnderChest() {
        return this.onJoinResetEnderChest;
    }

    public boolean isOnLeaveResetMoney() {
        return this.onLeaveResetMoney;
    }

    public boolean isOnLeaveResetInventory() {
        return this.onLeaveResetInventory;
    }

    public boolean isOnLeaveResetEnderChest() {
        return this.onLeaveResetEnderChest;
    }

    public boolean isDeathsCounted() {
        return this.deathsCounted;
    }

    public boolean isAllowSetHomeInNether() {
        return this.allowSetHomeInNether;
    }

    public boolean isAllowSetHomeInTheEnd() {
        return this.allowSetHomeInTheEnd;
    }

    public boolean isRequireConfirmationToSetHomeInNether() {
        return this.requireConfirmationToSetHomeInNether;
    }

    public boolean isRequireConfirmationToSetHomeInTheEnd() {
        return this.requireConfirmationToSetHomeInTheEnd;
    }

    public int getDeathsMax() {
        return this.deathsMax;
    }

    public boolean isTeamJoinDeathReset() {
        return this.teamJoinDeathReset;
    }

    public List<String> getGeoLimitSettings() {
        return this.geoLimitSettings;
    }

    public List<String> getIvSettings() {
        return this.ivSettings;
    }

    public long getResetEpoch() {
        return this.resetEpoch;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public void setIslandDistance(int islandDistance) {
        this.islandDistance = islandDistance;
    }

    public void setIslandProtectionRange(int islandProtectionRange) {
        this.islandProtectionRange = islandProtectionRange;
    }

    public void setIslandStartX(int islandStartX) {
        this.islandStartX = islandStartX;
    }

    public void setIslandStartZ(int islandStartZ) {
        this.islandStartZ = islandStartZ;
    }

    public void setIslandXOffset(int islandXOffset) {
        this.islandXOffset = islandXOffset;
    }

    public void setIslandZOffset(int islandZOffset) {
        this.islandZOffset = islandZOffset;
    }

    public void setIslandHeight(int islandHeight) {
        this.islandHeight = islandHeight;
    }

    public void setUseOwnGenerator(boolean useOwnGenerator) {
        this.useOwnGenerator = useOwnGenerator;
    }

    public void setSeaHeight(int seaHeight) {
        this.seaHeight = seaHeight;
    }

    public void setMaxIslands(int maxIslands) {
        this.maxIslands = maxIslands;
    }

    public void setDefaultGameMode(GameMode defaultGameMode) {
        this.defaultGameMode = defaultGameMode;
    }

    public void setNetherGenerate(boolean netherGenerate) {
        this.netherGenerate = netherGenerate;
    }

    public void setNetherIslands(boolean netherIslands) {
        this.netherIslands = netherIslands;
    }

    public void setNetherRoof(boolean netherRoof) {
        this.netherRoof = netherRoof;
    }

    public void setNetherSpawnRadius(int netherSpawnRadius) {
        this.netherSpawnRadius = netherSpawnRadius;
    }

    public void setEndGenerate(boolean endGenerate) {
        this.endGenerate = endGenerate;
    }

    public void setEndIslands(boolean endIslands) {
        this.endIslands = endIslands;
    }

    public void setRemoveMobsWhitelist(Set<EntityType> removeMobsWhitelist) {
        this.removeMobsWhitelist = removeMobsWhitelist;
    }

    public void setWorldFlags(Map<String, Boolean> worldFlags) {
        this.worldFlags = worldFlags;
    }

    public void setDefaultIslandFlagNames(Map<String, Integer> defaultIslandFlagNames) {
        this.defaultIslandFlagNames = defaultIslandFlagNames;
    }

    public void setDefaultIslandSettingNames(Map<String, Integer> defaultIslandSettingNames) {
        this.defaultIslandSettingNames = defaultIslandSettingNames;
    }

    public void setHiddenFlags(List<String> hiddenFlags) {
        this.hiddenFlags = hiddenFlags;
    }

    public void setVisitorBannedCommands(List<String> visitorBannedCommands) {
        this.visitorBannedCommands = visitorBannedCommands;
    }

    public void setFallingBannedCommands(List<String> fallingBannedCommands) {
        this.fallingBannedCommands = fallingBannedCommands;
    }

    public void setMaxTeamSize(int maxTeamSize) {
        this.maxTeamSize = maxTeamSize;
    }

    public void setMaxHomes(int maxHomes) {
        this.maxHomes = maxHomes;
    }

    public void setResetLimit(int resetLimit) {
        this.resetLimit = resetLimit;
    }

    public void setLeaversLoseReset(boolean leaversLoseReset) {
        this.leaversLoseReset = leaversLoseReset;
    }

    public void setKickedKeepInventory(boolean kickedKeepInventory) {
        this.kickedKeepInventory = kickedKeepInventory;
    }

    public void setOnJoinResetMoney(boolean onJoinResetMoney) {
        this.onJoinResetMoney = onJoinResetMoney;
    }

    public void setOnJoinResetInventory(boolean onJoinResetInventory) {
        this.onJoinResetInventory = onJoinResetInventory;
    }

    public void setOnJoinResetEnderChest(boolean onJoinResetEnderChest) {
        this.onJoinResetEnderChest = onJoinResetEnderChest;
    }

    public void setOnLeaveResetMoney(boolean onLeaveResetMoney) {
        this.onLeaveResetMoney = onLeaveResetMoney;
    }

    public void setOnLeaveResetInventory(boolean onLeaveResetInventory) {
        this.onLeaveResetInventory = onLeaveResetInventory;
    }

    public void setOnLeaveResetEnderChest(boolean onLeaveResetEnderChest) {
        this.onLeaveResetEnderChest = onLeaveResetEnderChest;
    }

    public void setCreateIslandOnFirstLoginEnabled(boolean createIslandOnFirstLoginEnabled) {
        this.createIslandOnFirstLoginEnabled = createIslandOnFirstLoginEnabled;
    }

    public void setCreateIslandOnFirstLoginDelay(int createIslandOnFirstLoginDelay) {
        this.createIslandOnFirstLoginDelay = createIslandOnFirstLoginDelay;
    }

    public void setCreateIslandOnFirstLoginAbortOnLogout(boolean createIslandOnFirstLoginAbortOnLogout) {
        this.createIslandOnFirstLoginAbortOnLogout = createIslandOnFirstLoginAbortOnLogout;
    }

    public void setDeathsCounted(boolean deathsCounted) {
        this.deathsCounted = deathsCounted;
    }

    public void setDeathsMax(int deathsMax) {
        this.deathsMax = deathsMax;
    }

    public void setTeamJoinDeathReset(boolean teamJoinDeathReset) {
        this.teamJoinDeathReset = teamJoinDeathReset;
    }

    public void setGeoLimitSettings(List<String> geoLimitSettings) {
        this.geoLimitSettings = geoLimitSettings;
    }

    public void setIvSettings(List<String> ivSettings) {
        this.ivSettings = ivSettings;
    }

    public void setAllowSetHomeInNether(boolean allowSetHomeInNether) {
        this.allowSetHomeInNether = allowSetHomeInNether;
    }

    public void setAllowSetHomeInTheEnd(boolean allowSetHomeInTheEnd) {
        this.allowSetHomeInTheEnd = allowSetHomeInTheEnd;
    }

    public void setRequireConfirmationToSetHomeInNether(boolean requireConfirmationToSetHomeInNether) {
        this.requireConfirmationToSetHomeInNether = requireConfirmationToSetHomeInNether;
    }

    public void setRequireConfirmationToSetHomeInTheEnd(boolean requireConfirmationToSetHomeInTheEnd) {
        this.requireConfirmationToSetHomeInTheEnd = requireConfirmationToSetHomeInTheEnd;
    }

    public void setResetEpoch(long resetEpoch) {
        this.resetEpoch = resetEpoch;
    }

    public String getPermissionPrefix() {
        return "aoneblock";
    }

    public boolean isWaterUnsafe() {
        return false;
    }

    public Biome getDefaultBiome() {
        return this.defaultBiome == null ? Biome.PLAINS : this.defaultBiome;
    }

    public void setDefaultBiome(Biome defaultBiome) {
        this.defaultBiome = defaultBiome;
    }

    public int getBanLimit() {
        return this.banLimit;
    }

    public void setBanLimit(int banLimit) {
        this.banLimit = banLimit;
    }

    public String getPlayerCommandAliases() {
        return this.playerCommandAliases;
    }

    public void setPlayerCommandAliases(String playerCommandAliases) {
        this.playerCommandAliases = playerCommandAliases;
    }

    public String getAdminCommandAliases() {
        return this.adminCommandAliases;
    }

    public void setAdminCommandAliases(String adminCommandAliases) {
        this.adminCommandAliases = adminCommandAliases;
    }

    public boolean isDeathsResetOnNewIsland() {
        return this.deathsResetOnNewIsland;
    }

    public void setDeathsResetOnNewIsland(boolean deathsResetOnNew) {
        this.deathsResetOnNewIsland = deathsResetOnNew;
    }

    public List<String> getOnJoinCommands() {
        return this.onJoinCommands;
    }

    public void setOnJoinCommands(List<String> onJoinCommands) {
        this.onJoinCommands = onJoinCommands;
    }

    public List<String> getOnLeaveCommands() {
        return this.onLeaveCommands;
    }

    public void setOnLeaveCommands(List<String> onLeaveCommands) {
        this.onLeaveCommands = onLeaveCommands;
    }

    public List<String> getOnRespawnCommands() {
        return this.onRespawnCommands;
    }

    public void setOnRespawnCommands(List<String> onRespawnCommands) {
        this.onRespawnCommands = onRespawnCommands;
    }

    public boolean isOnJoinResetHealth() {
        return this.onJoinResetHealth;
    }

    public void setOnJoinResetHealth(boolean onJoinResetHealth) {
        this.onJoinResetHealth = onJoinResetHealth;
    }

    public boolean isOnJoinResetHunger() {
        return this.onJoinResetHunger;
    }

    public void setOnJoinResetHunger(boolean onJoinResetHunger) {
        this.onJoinResetHunger = onJoinResetHunger;
    }

    public boolean isOnJoinResetXP() {
        return this.onJoinResetXP;
    }

    public void setOnJoinResetXP(boolean onJoinResetXP) {
        this.onJoinResetXP = onJoinResetXP;
    }

    public boolean isOnLeaveResetHealth() {
        return this.onLeaveResetHealth;
    }

    public void setOnLeaveResetHealth(boolean onLeaveResetHealth) {
        this.onLeaveResetHealth = onLeaveResetHealth;
    }

    public boolean isOnLeaveResetHunger() {
        return this.onLeaveResetHunger;
    }

    public void setOnLeaveResetHunger(boolean onLeaveResetHunger) {
        this.onLeaveResetHunger = onLeaveResetHunger;
    }

    public boolean isOnLeaveResetXP() {
        return this.onLeaveResetXP;
    }

    public void setOnLeaveResetXP(boolean onLeaveResetXP) {
        this.onLeaveResetXP = onLeaveResetXP;
    }

    public boolean isPasteMissingIslands() {
        return this.pasteMissingIslands;
    }

    public void setPasteMissingIslands(boolean pasteMissingIslands) {
        this.pasteMissingIslands = pasteMissingIslands;
    }

    public boolean isTeleportPlayerToIslandUponIslandCreation() {
        return this.teleportPlayerToIslandUponIslandCreation;
    }

    public void setTeleportPlayerToIslandUponIslandCreation(boolean teleportPlayerToIslandUponIslandCreation) {
        this.teleportPlayerToIslandUponIslandCreation = teleportPlayerToIslandUponIslandCreation;
    }

    public int getSpawnLimitMonsters() {
        return this.spawnLimitMonsters;
    }

    public void setSpawnLimitMonsters(int spawnLimitMonsters) {
        this.spawnLimitMonsters = spawnLimitMonsters;
    }

    public int getSpawnLimitAnimals() {
        return this.spawnLimitAnimals;
    }

    public void setSpawnLimitAnimals(int spawnLimitAnimals) {
        this.spawnLimitAnimals = spawnLimitAnimals;
    }

    public int getSpawnLimitWaterAnimals() {
        return this.spawnLimitWaterAnimals;
    }

    public void setSpawnLimitWaterAnimals(int spawnLimitWaterAnimals) {
        this.spawnLimitWaterAnimals = spawnLimitWaterAnimals;
    }

    public int getSpawnLimitAmbient() {
        return this.spawnLimitAmbient;
    }

    public void setSpawnLimitAmbient(int spawnLimitAmbient) {
        this.spawnLimitAmbient = spawnLimitAmbient;
    }

    public int getTicksPerAnimalSpawns() {
        return this.ticksPerAnimalSpawns;
    }

    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.ticksPerAnimalSpawns = ticksPerAnimalSpawns;
    }

    public int getTicksPerMonsterSpawns() {
        return this.ticksPerMonsterSpawns;
    }

    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.ticksPerMonsterSpawns = ticksPerMonsterSpawns;
    }

    public int getMaxCoopSize() {
        return this.maxCoopSize;
    }

    public void setMaxCoopSize(int maxCoopSize) {
        this.maxCoopSize = maxCoopSize;
    }

    public int getMaxTrustSize() {
        return this.maxTrustSize;
    }

    public void setMaxTrustSize(int maxTrustSize) {
        this.maxTrustSize = maxTrustSize;
    }

    public int getMobWarning() {
        if (this.mobWarning < 0) {
            this.mobWarning = 0;
        } else if (this.mobWarning > 5) {
            this.mobWarning = 5;
        }
        return this.mobWarning;
    }

    public void setMobWarning(int mobWarning) {
        this.mobWarning = mobWarning;
    }

    public boolean isWaterMobProtection() {
        return this.waterMobProtection;
    }

    public void setWaterMobProtection(boolean waterMobProtection) {
        this.waterMobProtection = waterMobProtection;
    }

    public String getDefaultNewPlayerAction() {
        return this.defaultNewPlayerAction;
    }

    public void setDefaultNewPlayerAction(String defaultNewPlayerAction) {
        this.defaultNewPlayerAction = defaultNewPlayerAction;
    }

    public String getDefaultPlayerAction() {
        return this.defaultPlayerAction;
    }

    public void setDefaultPlayerAction(String defaultPlayerAction) {
        this.defaultPlayerAction = defaultPlayerAction;
    }

    public List<String> getMobLimitSettings() {
        return this.mobLimitSettings;
    }

    public void setMobLimitSettings(List<String> mobLimitSettings) {
        this.mobLimitSettings = mobLimitSettings;
    }

    public boolean isDropOnTop() {
        return this.dropOnTop;
    }

    public void setDropOnTop(boolean dropOnTop) {
        this.dropOnTop = dropOnTop;
    }

    public Biome getDefaultNetherBiome() {
        return this.defaultNetherBiome == null ? Biome.NETHER_WASTES : this.defaultNetherBiome;
    }

    public void setDefaultNetherBiome(Biome defaultNetherBiome) {
        this.defaultNetherBiome = defaultNetherBiome;
    }

    public Biome getDefaultEndBiome() {
        return this.defaultEndBiome == null ? Biome.THE_END : this.defaultEndBiome;
    }

    public void setDefaultEndBiome(Biome defaultEndBiome) {
        this.defaultEndBiome = defaultEndBiome;
    }

    public boolean isMakeNetherPortals() {
        return this.makeNetherPortals;
    }

    public boolean isMakeEndPortals() {
        return this.makeEndPortals;
    }

    public void setMakeNetherPortals(boolean makeNetherPortals) {
        this.makeNetherPortals = makeNetherPortals;
    }

    public void setMakeEndPortals(boolean makeEndPortals) {
        this.makeEndPortals = makeEndPortals;
    }

    public String getPercentCompleteSymbol() {
        return this.percentCompleteSymbol;
    }

    public void setPercentCompleteSymbol(String percentCompleteSymbol) {
        this.percentCompleteSymbol = percentCompleteSymbol;
    }

    public String getCountCommand() {
        return this.countCommand;
    }

    public void setCountCommand(String countCommand) {
        this.countCommand = countCommand;
    }

    public String getPhasesCommand() {
        return this.phasesCommand;
    }

    public void setPhasesCommand(String phasesCommand) {
        this.phasesCommand = phasesCommand;
    }

    public String getSetCountCommand() {
        return this.setCountCommand;
    }

    public void setSetCountCommand(String setCountCommand) {
        this.setCountCommand = setCountCommand;
    }

    public String getRespawnBlockCommand() {
        return this.respawnBlockCommand;
    }

    public void setRespawnBlockCommand(String respawnBlockCommand) {
        this.respawnBlockCommand = respawnBlockCommand;
    }

    public int getHologramDuration() {
        return this.hologramDuration;
    }

    public void setHologramDuration(int hologramDuration) {
        this.hologramDuration = hologramDuration;
    }

    public int getSetCountCooldown() {
        return this.setCountCooldown;
    }

    public void setSetCountCooldown(int setCountCooldown) {
        this.setCountCooldown = setCountCooldown;
    }

    public boolean isUseHolograms() {
        return this.useHolograms;
    }

    public void setUseHolograms(boolean useHolograms) {
        this.useHolograms = useHolograms;
    }

    public boolean isClearBlocks() {
        return this.clearBlocks;
    }

    public void setClearBlocks(boolean clearBlocks) {
        this.clearBlocks = clearBlocks;
    }

    public int getStartingSafetyDuration() {
        return this.startingSafetyDuration;
    }

    public void setStartingSafetyDuration(int startingSafetyDuration) {
        this.startingSafetyDuration = startingSafetyDuration;
    }

    public Double getParticleSize() {
        if (this.particleSize == null) {
            this.particleSize = 0.8;
        }
        if (this.particleSize < 0.0) {
            this.particleSize = 0.0;
        }
        return this.particleSize;
    }

    public void setParticleSize(Double particleSize) {
        this.particleSize = particleSize;
    }

    public Color getParticleColor() {
        if (this.particleColor == null) {
            this.particleColor = Color.GREEN;
        }
        return this.particleColor;
    }

    public void setParticleColor(Color particleColor) {
        this.particleColor = particleColor;
    }

    public Double getParticleDensity() {
        if (this.particleDensity == null) {
            this.particleDensity = 0.5;
        }
        if (this.particleDensity < 0.1) {
            this.particleDensity = 0.1;
        }
        if (this.particleDensity > 1.0) {
            this.particleDensity = 1.0;
        }
        return this.particleDensity;
    }

    public void setParticleDensity(Double particleDensity) {
        this.particleDensity = particleDensity;
    }

    public String getClickType() {
        if (this.clickType == null || !this.clickType.equalsIgnoreCase("LEFT") && !this.clickType.equalsIgnoreCase("RIGHT") && !this.clickType.equalsIgnoreCase("NONE")) {
            this.clickType = "LEFT";
        }
        return this.clickType;
    }

    public void setClickType(String clickType) {
        this.clickType = clickType;
    }

    public boolean isDisallowTeamMemberIslands() {
        return this.disallowTeamMemberIslands;
    }

    public void setDisallowTeamMemberIslands(boolean disallowTeamMemberIslands) {
        this.disallowTeamMemberIslands = disallowTeamMemberIslands;
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public int getConcurrentIslands() {
        if (this.concurrentIslands <= 0) {
            return BentoBox.getInstance().getSettings().getIslandNumber();
        }
        return this.concurrentIslands;
    }

    public void setConcurrentIslands(int concurrentIslands) {
        this.concurrentIslands = concurrentIslands;
    }

    public String getBossBarCommand() {
        return this.bossBarCommand;
    }

    public void setBossBarCommand(String bossBarCommand) {
        this.bossBarCommand = bossBarCommand;
    }
}

