/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.commands.admin;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminSetCountCommand
extends CompositeCommand {
    private AOneBlock addon;

    public AdminSetCountCommand(CompositeCommand islandCommand) {
        super(islandCommand, "setcount", new String[0]);
    }

    public void setup() {
        this.setParametersHelp("aoneblock.commands.admin.setcount.parameters");
        this.setDescription("aoneblock.commands.admin.setcount.description");
        this.setPermission("admin.setcount");
        this.addon = (AOneBlock)this.getAddon();
    }

    public boolean execute(User user, String label, List<String> args) {
        if (args.size() < 2 || args.size() > 3 || args.size() == 3 && !args.get(2).equalsIgnoreCase("lifetime")) {
            this.showHelp(this, user);
            return false;
        }
        if (!Util.isInteger((String)args.get(1), (boolean)true) || Integer.parseInt(args.get(1)) < 0) {
            user.sendMessage("general.errors.must-be-positive-number", new String[]{"[number]", args.get(1)});
            return false;
        }
        int count = Integer.parseInt(args.get(1));
        UUID targetUUID = this.getPlayers().getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", new String[]{"[name]", args.get(0)});
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), targetUUID);
        if (island == null) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        OneBlockIslands i = this.addon.getOneBlocksIsland(island);
        if (args.size() == 3 && args.get(2).equalsIgnoreCase("lifetime")) {
            i.setLifetime(count);
            user.sendMessage("aoneblock.commands.admin.setcount.set-lifetime", new String[]{"[number]", String.valueOf(count), "[name]", this.getPlayers().getName(targetUUID)});
        } else {
            i.setBlockNumber(count);
            i.clearQueue();
            user.sendMessage("aoneblock.commands.admin.setcount.set", new String[]{"[number]", String.valueOf(count), "[name]", this.getPlayers().getName(targetUUID)});
        }
        return true;
    }

    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        return args.size() == 2 ? Optional.of(Util.getOnlinePlayerList((User)user)) : Optional.empty();
    }
}

