/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Brushable;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.aoneblock.events.MagicBlockEntityEvent;
import world.bentobox.aoneblock.events.MagicBlockEvent;
import world.bentobox.aoneblock.events.MagicBlockPhaseEvent;
import world.bentobox.aoneblock.listeners.CheckPhase;
import world.bentobox.aoneblock.listeners.MakeSpace;
import world.bentobox.aoneblock.listeners.WarningSounder;
import world.bentobox.aoneblock.oneblocks.OneBlockObject;
import world.bentobox.aoneblock.oneblocks.OneBlockPhase;
import world.bentobox.aoneblock.oneblocks.OneBlocksManager;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.events.island.IslandCreatedEvent;
import world.bentobox.bentobox.api.events.island.IslandDeleteEvent;
import world.bentobox.bentobox.api.events.island.IslandResettedEvent;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class BlockListener
implements Listener {
    private final AOneBlock addon;
    private final OneBlocksManager oneBlocksManager;
    private final Database<OneBlockIslands> handler;
    private final Map<String, OneBlockIslands> cache;
    private final CheckPhase check;
    private final WarningSounder warningSounder;
    public static final int MAX_LOOK_AHEAD = 5;
    public static final int SAVE_EVERY = 50;
    private static final Map<Material, Double> LOOT;

    public BlockListener(@NonNull AOneBlock addon) {
        this.addon = addon;
        this.handler = new Database((Addon)addon, OneBlockIslands.class);
        this.cache = new HashMap<String, OneBlockIslands>();
        this.oneBlocksManager = addon.getOneBlockManager();
        this.check = new CheckPhase(addon, this);
        this.warningSounder = new WarningSounder(addon);
    }

    public void saveCache() {
        this.cache.values().forEach(arg_0 -> this.handler.saveObjectAsync(arg_0));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onNewIsland(IslandCreatedEvent e) {
        if (this.addon.inWorld(e.getIsland().getWorld())) {
            this.setUp(e.getIsland());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onNewIsland(IslandResettedEvent e) {
        if (this.addon.inWorld(e.getIsland().getWorld())) {
            this.setUp(e.getIsland());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onDeletedIsland(IslandDeleteEvent e) {
        if (this.addon.inWorld(e.getIsland().getWorld())) {
            this.cache.remove(e.getIsland().getUniqueId());
            this.handler.deleteID(e.getIsland().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent e) {
        if (!this.addon.inWorld(e.getBlock().getWorld())) {
            return;
        }
        Location l = e.getToBlock().getLocation();
        e.setCancelled(this.addon.getIslands().getIslandAt(l).filter(i -> l.equals((Object)i.getCenter())).isPresent());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (!this.addon.inWorld(e.getBlock().getWorld())) {
            return;
        }
        Location l = e.getBlock().getLocation();
        this.addon.getIslands().getIslandAt(l).filter(i -> l.equals((Object)i.getCenter())).ifPresent(i -> this.process((Cancellable)e, (Island)i, e.getPlayer(), e.getPlayer().getWorld()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBreakByMinion(EntityInteractEvent e) {
        if (!this.addon.inWorld(e.getBlock().getWorld()) || !e.getEntityType().equals((Object)EntityType.ARMOR_STAND)) {
            return;
        }
        Location l = e.getBlock().getLocation();
        this.addon.getIslands().getIslandAt(l).filter(i -> l.equals((Object)i.getCenter())).ifPresent(i -> this.process((Cancellable)e, (Island)i, null, e.getBlock().getWorld()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBreak(PlayerBucketFillEvent e) {
        if (this.addon.inWorld(e.getBlock().getWorld())) {
            Location l = e.getBlock().getLocation();
            this.addon.getIslands().getIslandAt(l).filter(i -> l.equals((Object)i.getCenter())).ifPresent(i -> this.process((Cancellable)e, (Island)i, e.getPlayer(), e.getPlayer().getWorld()));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onItemSpawn(ItemSpawnEvent event) {
        if (!this.addon.getSettings().isDropOnTop()) {
            return;
        }
        Location spawnLocation = event.getLocation();
        if (!this.addon.inWorld(spawnLocation.getWorld())) {
            return;
        }
        Optional<Island> optionalIsland = this.addon.getIslands().getIslandAt(spawnLocation).filter(island -> {
            Location blockLocation = spawnLocation.getBlock().getLocation();
            return blockLocation.equals((Object)island.getCenter());
        });
        if (optionalIsland.isPresent()) {
            event.setCancelled(true);
            Island island2 = optionalIsland.get();
            ItemStack itemStack = event.getEntity().getItemStack();
            Location newDropLocation = island2.getCenter().add(0.5, 1.0, 0.5);
            spawnLocation.getWorld().dropItem(newDropLocation, itemStack);
        }
    }

    private void setUp(@NonNull Island island) {
        Util.getChunkAtAsync((Location)Objects.requireNonNull(island.getCenter())).thenRun(() -> island.getCenter().getBlock().setType(Material.GRASS_BLOCK));
        OneBlockIslands is = new OneBlockIslands(island.getUniqueId());
        this.cache.put(island.getUniqueId(), is);
        this.handler.saveObjectAsync((Object)is);
        this.addon.getHoloListener().setUp(island, is, true);
    }

    private void process(@NonNull Cancellable e, @NonNull Island i, @Nullable Player player, @NonNull World world) {
        Block block = Objects.requireNonNull(i.getCenter()).toVector().toLocation(world).getBlock();
        OneBlockIslands is = this.getIsland(i);
        ProcessPhaseResult phaseResult = this.processPhase(e, i, is, player, world, block);
        if (e.isCancelled()) {
            return;
        }
        this.initializeQueue(is, phaseResult.phase, phaseResult.isCurrPhaseNew);
        this.processHologramAndWarnings(i, is, phaseResult.phase, block);
        this.processNextBlock(e, i, player, block, is, phaseResult);
    }

    private ProcessPhaseResult processPhase(Cancellable e, Island i, OneBlockIslands is, Player player, World world, Block block) {
        boolean isCurrPhaseNew;
        OneBlockPhase phase = this.oneBlocksManager.getPhase(is.getBlockNumber());
        String prevPhaseName = is.getPhaseName();
        if (Objects.requireNonNull(phase).getGotoBlock() != null) {
            phase = this.handleGoto(is, phase.getGotoBlock());
        }
        String currPhaseName = phase.getPhaseName() == null ? "" : phase.getPhaseName();
        this.handlePhaseChange(is, phase, currPhaseName);
        boolean bl = isCurrPhaseNew = !is.getPhaseName().equalsIgnoreCase(currPhaseName);
        if (isCurrPhaseNew) {
            if (this.check.phaseRequirementsFail(player, i, is, phase, world)) {
                e.setCancelled(true);
                return new ProcessPhaseResult(phase, true, 0);
            }
            this.handleNewPhase(player, i, is, phase, block, prevPhaseName);
        } else if (is.getBlockNumber() % 50 == 0) {
            this.saveIsland(i);
        }
        int materialBlocksInQueue = (int)is.getQueue().stream().filter(obo -> obo.isMaterial() || obo.isCustomBlock()).count();
        int blockNumber = is.getBlockNumber() - (phase.getBlockNumberValue() - 1) + materialBlocksInQueue;
        return new ProcessPhaseResult(phase, isCurrPhaseNew, blockNumber);
    }

    private void handleNewPhase(Player player, Island i, OneBlockIslands is, OneBlockPhase phase, Block block, String prevPhaseName) {
        this.check.setNewPhase(player, i, is, phase);
        is.clearQueue();
        this.setBiome(block, phase.getPhaseBiome());
        Bukkit.getPluginManager().callEvent((Event)new MagicBlockPhaseEvent(i, player == null ? null : player.getUniqueId(), block, phase.getPhaseName(), prevPhaseName, is.getBlockNumber()));
    }

    private void handlePhaseChange(OneBlockIslands is, OneBlockPhase phase, String currPhaseName) {
        String nextPhaseName;
        OneBlockPhase nextPhase = this.oneBlocksManager.getPhase(is.getBlockNumber() + 1);
        if (Objects.requireNonNull(nextPhase).getGotoBlock() != null) {
            nextPhase = this.oneBlocksManager.getPhase(nextPhase.getGotoBlock());
        }
        String string = nextPhaseName = nextPhase == null || nextPhase.getPhaseName() == null ? "" : nextPhase.getPhaseName();
        if (!currPhaseName.equalsIgnoreCase(nextPhaseName)) {
            is.setLastPhaseChangeTime(System.currentTimeMillis());
        }
    }

    private void initializeQueue(OneBlockIslands is, OneBlockPhase phase, boolean isCurrPhaseNew) {
        if (is.getQueue().isEmpty() || isCurrPhaseNew) {
            for (int j = 0; j < 5; ++j) {
                is.add(phase.getNextBlock(this.addon, j));
            }
        }
    }

    private void processHologramAndWarnings(Island i, OneBlockIslands is, OneBlockPhase phase, Block block) {
        this.addon.getHoloListener().process(i, is, phase);
        if (this.addon.getSettings().getMobWarning() > 0) {
            this.warningSounder.play(is, block);
        }
    }

    private void processNextBlock(Cancellable e, Island i, Player player, Block block, OneBlockIslands is, ProcessPhaseResult phaseResult) {
        OneBlockObject nextBlock;
        OneBlockObject oneBlockObject = nextBlock = phaseResult.isCurrPhaseNew && phaseResult.phase.getFirstBlock() != null ? phaseResult.phase.getFirstBlock() : is.pollAndAdd(phaseResult.phase.getNextBlock(this.addon, phaseResult.blockNumber));
        if (nextBlock.isEntity()) {
            this.handleEntitySpawn(e, i, player, block, nextBlock);
            return;
        }
        is.incrementBlockNumber();
        this.handleBlockBreak(e, i, player, block, nextBlock);
    }

    private void handleEntitySpawn(Cancellable e, Island i, Player player, Block block, OneBlockObject nextBlock) {
        if (!(e instanceof EntitySpawnEvent)) {
            e.setCancelled(true);
        }
        this.spawnEntity(nextBlock, block);
        Bukkit.getPluginManager().callEvent((Event)new MagicBlockEntityEvent(i, player == null ? null : player.getUniqueId(), block, nextBlock.getEntityType()));
    }

    private void handleBlockBreak(Cancellable e, Island i, Player player, Block block, OneBlockObject nextBlock) {
        if (e instanceof BlockBreakEvent) {
            this.breakBlock(player, block, nextBlock, i);
        } else if (e instanceof PlayerBucketFillEvent) {
            this.handleBucketFill(player, i, block, nextBlock);
        } else if (e instanceof EntitySpawnEvent || e instanceof EntityInteractEvent) {
            this.handleEntityBreak(i, block, nextBlock, e instanceof EntityInteractEvent);
        }
    }

    private void handleBucketFill(Player player, Island i, Block block, OneBlockObject nextBlock) {
        Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> this.spawnBlock(nextBlock, block));
        ItemStack tool = Objects.requireNonNull(player).getInventory().getItemInMainHand();
        Bukkit.getPluginManager().callEvent((Event)new MagicBlockEvent(i, player.getUniqueId(), tool, block, nextBlock.getMaterial()));
    }

    private void handleEntityBreak(Island i, Block block, OneBlockObject nextBlock, boolean isMinion) {
        Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> this.spawnBlock(nextBlock, block));
        if (isMinion) {
            Bukkit.getPluginManager().callEvent((Event)new MagicBlockEvent(i, null, null, block, nextBlock.getMaterial()));
        }
    }

    private OneBlockPhase handleGoto(OneBlockIslands is, int gotoBlock) {
        is.setLifetime(is.getLifetime() + (long)gotoBlock);
        is.setBlockNumber(gotoBlock);
        return this.oneBlocksManager.getPhase(gotoBlock);
    }

    private void setBiome(@NonNull Block block, @Nullable Biome biome) {
        if (biome == null) {
            return;
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                for (int y = -4; y <= 4; ++y) {
                    block.getWorld().setBiome(block.getX() + x, block.getY() + y, block.getZ() + z, biome);
                }
            }
        }
    }

    private void breakBlock(@Nullable Player player, Block block, @NonNull OneBlockObject nextBlock, @NonNull Island island) {
        ItemStack tool = Objects.requireNonNull(player).getInventory().getItemInMainHand();
        Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> this.spawnBlock(nextBlock, block));
        if (player.getLocation().getBlock().equals((Object)block)) {
            double delta = 1.0 - (player.getLocation().getY() - (double)block.getY());
            player.teleport(player.getLocation().add(new Vector(0.0, delta, 0.0)));
            player.setVelocity(new Vector(0, 0, 0));
        } else if (player.getLocation().getBlock().equals((Object)block.getRelative(BlockFace.UP))) {
            player.teleport(player.getLocation());
            player.setVelocity(new Vector(0, 0, 0));
        }
        Bukkit.getPluginManager().callEvent((Event)new MagicBlockEvent(island, player.getUniqueId(), tool, block, nextBlock.getMaterial()));
    }

    private void spawnBlock(@NonNull OneBlockObject nextBlock, @NonNull Block block) {
        if (nextBlock.isCustomBlock()) {
            nextBlock.getCustomBlock().execute(this.addon, block);
        } else {
            @NonNull Material type = nextBlock.getMaterial();
            block.setType(type, false);
            if (type.equals((Object)Material.CHEST) && nextBlock.getChest() != null) {
                this.fillChest(nextBlock, block);
                return;
            }
            if (Tag.LEAVES.isTagged((Keyed)type)) {
                Leaves leaves = (Leaves)block.getState().getBlockData();
                leaves.setPersistent(true);
                block.setBlockData((BlockData)leaves);
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        BlockData blockData;
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getClickedBlock() == null) {
            return;
        }
        if (e.getClickedBlock().getType() != Material.SUSPICIOUS_GRAVEL && e.getClickedBlock().getType() != Material.SUSPICIOUS_SAND) {
            return;
        }
        if (e.getPlayer().getInventory().getItemInMainHand().getType() != Material.BRUSH) {
            return;
        }
        BentoBox.getInstance().logDebug((Object)("Brushing " + String.valueOf(e.getClickedBlock())));
        if (e.getClickedBlock() != null && (blockData = e.getClickedBlock().getBlockData()) instanceof Brushable) {
            Brushable bb = (Brushable)blockData;
            BentoBox.getInstance().logDebug((Object)("item is brushable " + bb.getDusted()));
        }
    }

    private static Material getRandomLoot(Random random) {
        double roll = random.nextDouble();
        double cumulative = 0.0;
        for (Map.Entry<Material, Double> entry : LOOT.entrySet()) {
            if (!(roll <= (cumulative += entry.getValue().doubleValue()))) continue;
            return entry.getKey();
        }
        ArrayList<Material> materials = new ArrayList<Material>(LOOT.keySet());
        return (Material)materials.get(random.nextInt(materials.size()));
    }

    private void spawnEntity(@NonNull OneBlockObject nextBlock, @NonNull Block block) {
        if (block.isEmpty()) {
            block.setType(Material.STONE);
        }
        Location spawnLoc = block.getLocation().add(new Vector(0.5, 1.0, 0.5));
        Entity entity = block.getWorld().spawnEntity(spawnLoc, nextBlock.getEntityType());
        if (this.addon.getSettings().isClearBlocks()) {
            new MakeSpace(this.addon).makeSpace(entity, spawnLoc);
        }
        block.getWorld().playSound(block.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 2.0f);
    }

    private void fillChest(@NonNull OneBlockObject nextBlock, @NonNull Block block) {
        Chest chest = (Chest)block.getState();
        nextBlock.getChest().forEach((arg_0, arg_1) -> ((Inventory)chest.getBlockInventory()).setItem(arg_0, arg_1));
        Color color = Color.fromBGR((int)0, (int)255, (int)255);
        switch (nextBlock.getRarity()) {
            case EPIC: {
                color = Color.fromBGR((int)255, (int)0, (int)255);
                break;
            }
            case RARE: {
                color = Color.fromBGR((int)255, (int)255, (int)255);
                break;
            }
            case UNCOMMON: {
                break;
            }
            default: {
                return;
            }
        }
        block.getWorld().spawnParticle(Particle.DUST, block.getLocation().add(new Vector(0.5, 1.0, 0.5)), 50, 0.5, 0.0, 0.5, 1.0, (Object)new Particle.DustOptions(color, 1.0f));
    }

    public @NonNull OneBlockIslands getIsland(@NonNull Island i) {
        return this.cache.containsKey(i.getUniqueId()) ? this.cache.get(i.getUniqueId()) : this.loadIsland(i.getUniqueId());
    }

    public List<OneBlockIslands> getAllIslands() {
        return this.handler.loadObjects();
    }

    private @NonNull OneBlockIslands loadIsland(@NonNull String uniqueId) {
        OneBlockIslands island;
        if (this.handler.objectExists(uniqueId) && (island = (OneBlockIslands)this.handler.loadObject(uniqueId)) != null) {
            this.cache.put(island.getUniqueId(), island);
            return island;
        }
        return this.cache.computeIfAbsent(uniqueId, OneBlockIslands::new);
    }

    public OneBlocksManager getOneBlocksManager() {
        return this.oneBlocksManager;
    }

    public CompletableFuture<Boolean> saveIsland(@NonNull Island island) {
        if (this.cache.containsKey(island.getUniqueId())) {
            return this.handler.saveObjectAsync((Object)this.cache.get(island.getUniqueId()));
        }
        return CompletableFuture.completedFuture(true);
    }

    static {
        HashMap<Material, Double> loot = new HashMap<Material, Double>();
        loot.put(Material.BLUE_DYE, 0.044);
        loot.put(Material.BRICK, 0.044);
        loot.put(Material.BROWN_CANDLE, 0.044);
        loot.put(Material.EMERALD, 0.044);
        loot.put(Material.GREEN_CANDLE, 0.044);
        loot.put(Material.LIGHT_BLUE_DYE, 0.044);
        loot.put(Material.ORANGE_DYE, 0.044);
        loot.put(Material.PURPLE_CANDLE, 0.044);
        loot.put(Material.RED_CANDLE, 0.044);
        loot.put(Material.WHEAT, 0.044);
        loot.put(Material.WOODEN_HOE, 0.044);
        loot.put(Material.YELLOW_DYE, 0.044);
        loot.put(Material.BEETROOT_SEEDS, 0.022);
        loot.put(Material.BLUE_STAINED_GLASS_PANE, 0.022);
        loot.put(Material.COAL, 0.022);
        loot.put(Material.DEAD_BUSH, 0.022);
        loot.put(Material.FLOWER_POT, 0.022);
        loot.put(Material.LEAD, 0.022);
        loot.put(Material.LIGHT_BLUE_STAINED_GLASS_PANE, 0.022);
        loot.put(Material.MAGENTA_STAINED_GLASS_PANE, 0.022);
        loot.put(Material.OAK_HANGING_SIGN, 0.022);
        loot.put(Material.PINK_STAINED_GLASS_PANE, 0.022);
        loot.put(Material.PURPLE_STAINED_GLASS_PANE, 0.022);
        loot.put(Material.RED_STAINED_GLASS_PANE, 0.022);
        loot.put(Material.SPRUCE_HANGING_SIGN, 0.022);
        loot.put(Material.STRING, 0.022);
        loot.put(Material.WHEAT_SEEDS, 0.022);
        loot.put(Material.YELLOW_STAINED_GLASS_PANE, 0.022);
        loot.put(Material.GOLD_NUGGET, 0.022);
        LOOT = loot;
    }

    private record ProcessPhaseResult(OneBlockPhase phase, boolean isCurrPhaseNew, int blockNumber) {
    }
}

