/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.listeners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.bentobox.database.objects.Island;

public class BlockProtect
implements Listener {
    public static final Color GREEN = Color.fromBGR((int)0, (int)100, (int)0);
    private static final List<Particle> PARTICLES = new ArrayList<Particle>(List.of(Particle.DUST));
    private Iterator<Particle> particleIterator = Collections.emptyIterator();
    private final AOneBlock addon;

    public BlockProtect(AOneBlock addon) {
        this.addon = addon;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockDamage(PlayerInteractEvent e) {
        Action action = e.getAction();
        String clickType = this.addon.getSettings().getClickType();
        if (clickType.equalsIgnoreCase("NONE") || !this.addon.inWorld(e.getPlayer().getWorld()) || e.getClickedBlock() == null) {
            return;
        }
        if (action == Action.LEFT_CLICK_BLOCK && clickType.equalsIgnoreCase("LEFT") || action == Action.RIGHT_CLICK_BLOCK && clickType.equalsIgnoreCase("RIGHT")) {
            Location l = e.getClickedBlock().getLocation();
            this.addon.getIslands().getIslandAt(l).map(Island::getCenter).filter(center -> center.equals((Object)l)).ifPresent(this::showSparkles);
        }
    }

    public void showSparkles(Location location) {
        if (!this.particleIterator.hasNext()) {
            Collections.shuffle(PARTICLES);
            this.particleIterator = PARTICLES.iterator();
        }
        Particle p = this.particleIterator.next();
        for (double x = -0.5; x <= 1.5; x += this.addon.getSettings().getParticleDensity().doubleValue()) {
            for (double y = 0.0; y <= 1.5; y += this.addon.getSettings().getParticleDensity().doubleValue()) {
                for (double z = -0.5; z < 1.5; z += this.addon.getSettings().getParticleDensity().doubleValue()) {
                    location.getWorld().spawnParticle(p, location.clone().add(new Vector(x, y, z)), 5, 0.1, 0.0, 0.1, 1.0, (Object)new Particle.DustOptions(this.addon.getSettings().getParticleColor(), this.addon.getSettings().getParticleSize().floatValue()));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockChange(EntityChangeBlockEvent e) {
        if (!this.addon.inWorld(e.getBlock().getWorld())) {
            return;
        }
        Location l = e.getBlock().getLocation();
        this.addon.getIslands().getIslandAt(l).filter(i -> l.equals((Object)i.getCenter())).ifPresent(i -> e.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onExplosion(EntityExplodeEvent e) {
        if (!this.addon.inWorld(e.getLocation().getWorld())) {
            return;
        }
        e.blockList().removeIf(b -> this.addon.getIslands().getIslandAt(b.getLocation()).filter(i -> b.getLocation().equals((Object)i.getCenter())).isPresent());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent e) {
        this.checkPiston((Cancellable)e, e.getBlock(), e.getBlocks());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent e) {
        this.checkPiston((Cancellable)e, e.getBlock(), e.getBlocks());
    }

    private void checkPiston(Cancellable e, Block block, List<Block> blocks) {
        if (!this.addon.inWorld(block.getWorld())) {
            return;
        }
        Location l = block.getLocation();
        this.addon.getIslands().getIslandAt(l).map(Island::getCenter).ifPresent(c -> e.setCancelled(blocks.stream().map(Block::getLocation).anyMatch(loc -> loc.equals(c))));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFallingBlockSpawn(EntitySpawnEvent e) {
        if (!e.getEntityType().equals((Object)EntityType.FALLING_BLOCK) || !this.addon.inWorld(e.getEntity().getWorld())) {
            return;
        }
        Location l = e.getLocation();
        this.addon.getIslands().getIslandAt(l).filter(i -> l.getBlockX() == i.getCenter().getBlockX() && l.getBlockY() == i.getCenter().getBlockY() && l.getBlockZ() == i.getCenter().getBlockZ()).ifPresent(i -> e.setCancelled(true));
    }
}

