/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.listeners;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.aoneblock.oneblocks.OneBlockPhase;
import world.bentobox.bentobox.api.events.island.IslandDeleteEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class HoloListener
implements Listener {
    private final AOneBlock addon;
    private final Set<Location> activeHolograms;
    private static final Vector DEFAULT_OFFSET = new Vector(0.5, 1.1, 0.5);

    public HoloListener(@NonNull AOneBlock addon) {
        this.addon = addon;
        this.activeHolograms = new HashSet<Location>();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onDeletedIsland(IslandDeleteEvent e) {
        this.removeHologramAt(e.getIsland());
    }

    public void onDisable() {
        this.activeHolograms.forEach(this::cleanupHologram);
        this.activeHolograms.clear();
    }

    protected void setUp(@NonNull Island island, @NonNull OneBlockIslands is, boolean newIsland) {
        if (!this.addon.getSettings().isUseHolograms() || island.getOwner() == null) {
            return;
        }
        if (newIsland) {
            String startingText = User.getInstance((UUID)island.getOwner()).getTranslation("aoneblock.island.starting-hologram", new String[0]);
            is.setHologram(startingText == null ? "" : startingText);
        }
        this.updateHologram(island, is.getHologram());
    }

    protected void process(@NonNull Island i, @NonNull OneBlockIslands is, @NonNull OneBlockPhase phase) {
        String holoText = phase.getHologramLine(is.getBlockNumber());
        is.setHologram(holoText == null ? "" : Util.translateColorCodes((String)holoText));
        this.updateHologram(i, is.getHologram());
    }

    private void updateHologram(Island island, String text) {
        if (!this.addon.getSettings().isUseHolograms() || text.isBlank()) {
            return;
        }
        this.removeHologramAt(island);
        Location pos = this.getHologramLocation(island);
        this.createHologram(pos, text);
        if (this.addon.getSettings().getHologramDuration() > 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.addon.getPlugin(), () -> this.removeHologramAt(island), (long)this.addon.getSettings().getHologramDuration() * 20L);
        }
    }

    private Location getHologramLocation(Island island) {
        Vector offset = HoloListener.parseVector(this.addon.getSettings().getOffset());
        return island.getCenter().clone().add(offset);
    }

    private void createHologram(Location pos, String text) {
        TextDisplay display = (TextDisplay)pos.getWorld().spawn(pos, TextDisplay.class);
        display.setAlignment(TextDisplay.TextAlignment.CENTER);
        display.setBillboard(Display.Billboard.CENTER);
        display.setPersistent(true);
        display.setText(text);
        this.activeHolograms.add(pos);
    }

    private void removeHologramAt(@NonNull Island island) {
        if (island.getWorld() == null) {
            return;
        }
        this.cleanupHologram(this.getHologramLocation(island));
    }

    private void cleanupHologram(Location pos) {
        this.activeHolograms.remove(pos);
        Util.getChunkAtAsync((Location)pos).thenRun(() -> pos.getWorld().getNearbyEntities(pos, 1.0, 1.0, 1.0).stream().filter(e -> e.getType() == EntityType.TEXT_DISPLAY).forEach(Entity::remove));
    }

    private static Vector parseVector(String str) {
        if (str == null) {
            return DEFAULT_OFFSET;
        }
        try {
            String[] parts = str.split(",");
            return parts.length == 3 ? new Vector(Double.parseDouble(parts[0].trim()), Double.parseDouble(parts[1].trim()), Double.parseDouble(parts[2].trim())) : DEFAULT_OFFSET;
        }
        catch (NumberFormatException e) {
            return DEFAULT_OFFSET;
        }
    }
}

