/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.oneblocks;

import com.google.common.base.Enums;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.dataobjects.OneBlockIslands;
import world.bentobox.aoneblock.oneblocks.OneBlockCustomBlock;
import world.bentobox.aoneblock.oneblocks.OneBlockCustomBlockCreator;
import world.bentobox.aoneblock.oneblocks.OneBlockObject;
import world.bentobox.aoneblock.oneblocks.OneBlockPhase;
import world.bentobox.aoneblock.oneblocks.Requirement;
import world.bentobox.bentobox.util.ItemParser;
import world.bentobox.bentobox.util.Util;

public class OneBlocksManager {
    private static final String ONE_BLOCKS_YML = "oneblocks.yml";
    private static final String NAME = "name";
    private static final String BIOME = "biome";
    private static final String FIRST_BLOCK = "firstBlock";
    private static final String ICON = "icon";
    private static final String FIXED_BLOCKS = "fixedBlocks";
    private static final String HOLOGRAMS = "holograms";
    private static final String CHESTS = "chests";
    private static final String RARITY = "rarity";
    private static final String CONTENTS = "contents";
    private static final String MOBS = "mobs";
    private static final String BLOCKS = "blocks";
    private static final String PHASES = "phases";
    private static final String GOTO_BLOCK = "gotoBlock";
    private static final String START_COMMANDS = "start-commands";
    private static final String END_COMMANDS = "end-commands";
    private static final String END_COMMANDS_FIRST_TIME = "end-commands-first-time";
    private static final String REQUIREMENTS = "requirements";
    private static final String BLOCK = "Block ";
    private static final String BUT_ALREADY_SET_TO = " but already set to ";
    private static final String DUPLICATE = " Duplicate phase file?";
    private final AOneBlock addon;
    private TreeMap<Integer, OneBlockPhase> blockProbs;

    public OneBlocksManager(AOneBlock addon) {
        this.addon = addon;
        this.blockProbs = new TreeMap();
    }

    public void loadPhases() throws IOException {
        this.blockProbs = new TreeMap();
        File check = new File(this.addon.getDataFolder(), PHASES);
        if (check.mkdirs()) {
            this.addon.log(check.getAbsolutePath() + " does not exist, made folder.");
            File oneblockFile = new File(this.addon.getDataFolder(), ONE_BLOCKS_YML);
            if (oneblockFile.exists()) {
                File renamedFile = new File(check, ONE_BLOCKS_YML);
                com.google.common.io.Files.move((File)oneblockFile, (File)renamedFile);
                this.loadPhase(renamedFile);
                this.saveOneBlockConfig();
                Files.delete(oneblockFile.toPath());
                Files.delete(renamedFile.toPath());
                this.blockProbs.clear();
            } else {
                this.copyPhasesFromAddonJar(check);
            }
        }
        FilenameFilter ymlFilter = (dir, name) -> name.toLowerCase(Locale.ENGLISH).endsWith(".yml");
        for (File phaseFile : Objects.requireNonNull(check.listFiles(ymlFilter))) {
            this.loadPhase(phaseFile);
        }
    }

    void copyPhasesFromAddonJar(File file) {
        try (JarFile jar = new JarFile(this.addon.getFile());){
            Util.listJarFiles((JarFile)jar, (String)PHASES, (String)".yml").forEach(lf -> this.addon.saveResource((String)lf, file, false, true));
        }
        catch (Exception e) {
            this.addon.logError(e.getMessage());
        }
    }

    private void loadPhase(File phaseFile) throws IOException {
        this.addon.log("Loading " + phaseFile.getName());
        YamlConfiguration oneBlocks = new YamlConfiguration();
        try {
            oneBlocks.load(phaseFile);
        }
        catch (Exception e) {
            this.addon.logError(e.getMessage());
            return;
        }
        for (String phaseStartBlockNumKey : oneBlocks.getKeys(false)) {
            Integer phaseStartBlockNum = Integer.valueOf(phaseStartBlockNumKey);
            OneBlockPhase obPhase = this.blockProbs.computeIfAbsent(phaseStartBlockNum, k -> new OneBlockPhase(phaseStartBlockNumKey));
            ConfigurationSection phaseConfig = oneBlocks.getConfigurationSection(phaseStartBlockNumKey);
            if (phaseConfig.contains(GOTO_BLOCK)) {
                obPhase.setGotoBlock(phaseConfig.getInt(GOTO_BLOCK, 0));
                continue;
            }
            this.initBlock(phaseStartBlockNumKey, obPhase, phaseConfig);
            this.addBlocks(obPhase, phaseConfig);
            this.addMobs(obPhase, phaseConfig);
            this.addChests(obPhase, phaseConfig);
            this.addCommands(obPhase, phaseConfig);
            this.addRequirements(obPhase, phaseConfig);
            this.blockProbs.put(phaseStartBlockNum, obPhase);
        }
    }

    void initBlock(String blockNumber, OneBlockPhase obPhase, ConfigurationSection phaseConfig) throws IOException {
        if (phaseConfig.contains(NAME, true)) {
            if (obPhase.getPhaseName() != null) {
                throw new IOException(BLOCK + blockNumber + ": Phase name trying to be set to " + phaseConfig.getString(NAME) + BUT_ALREADY_SET_TO + obPhase.getPhaseName() + ". Duplicate phase file?");
            }
            obPhase.setPhaseName(phaseConfig.getString(NAME, blockNumber));
        }
        if (phaseConfig.contains(BIOME, true)) {
            if (obPhase.getPhaseBiome() != null) {
                throw new IOException(BLOCK + blockNumber + ": Biome trying to be set to " + phaseConfig.getString(BIOME) + BUT_ALREADY_SET_TO + String.valueOf(obPhase.getPhaseBiome()) + DUPLICATE);
            }
            obPhase.setPhaseBiome(this.getBiome(phaseConfig.getString(BIOME)));
        }
        if (phaseConfig.contains(FIRST_BLOCK)) {
            if (obPhase.getFirstBlock() != null) {
                throw new IOException(BLOCK + blockNumber + ": First block trying to be set to " + phaseConfig.getString(FIRST_BLOCK) + BUT_ALREADY_SET_TO + String.valueOf(obPhase.getFirstBlock()) + DUPLICATE);
            }
            this.addFirstBlock(obPhase, phaseConfig.getString(FIRST_BLOCK));
        }
        if (phaseConfig.contains(ICON)) {
            ItemStack icon = ItemParser.parse((String)phaseConfig.getString(ICON));
            if (icon == null) {
                throw new IOException("ItemParser failed to parse icon: '" + phaseConfig.getString(ICON) + "' for phase " + String.valueOf(obPhase.getFirstBlock()) + ". Can you check if it is correct?");
            }
            obPhase.setIconBlock(icon);
        }
        if (phaseConfig.contains(FIXED_BLOCKS)) {
            if (!obPhase.getFixedBlocks().isEmpty()) {
                throw new IOException(BLOCK + blockNumber + ": Fixed blocks trying to be set to " + phaseConfig.getString(FIXED_BLOCKS) + BUT_ALREADY_SET_TO + String.valueOf(obPhase.getFixedBlocks()) + DUPLICATE);
            }
            this.addFixedBlocks(obPhase, phaseConfig.getConfigurationSection(FIXED_BLOCKS));
        }
        if (phaseConfig.contains(HOLOGRAMS)) {
            if (!obPhase.getHologramLines().isEmpty()) {
                throw new IOException(BLOCK + blockNumber + ": Hologram Lines trying to be set to " + phaseConfig.getString(HOLOGRAMS) + BUT_ALREADY_SET_TO + String.valueOf(obPhase.getHologramLines()) + DUPLICATE);
            }
            this.addHologramLines(obPhase, phaseConfig.getConfigurationSection(HOLOGRAMS));
        }
    }

    private void addFixedBlocks(OneBlockPhase obPhase, ConfigurationSection firstBlocksConfig) {
        if (firstBlocksConfig == null) {
            return;
        }
        Map<Integer, OneBlockObject> result = this.parseFirstBlocksConfig(firstBlocksConfig);
        if (result.containsKey(0)) {
            this.addon.log("Found firstBlock in fixedBlocks.");
            obPhase.setFirstBlock(result.get(0));
        }
        obPhase.setFixedBlocks(result);
    }

    private Map<Integer, OneBlockObject> parseFirstBlocksConfig(ConfigurationSection firstBlocksConfig) {
        HashMap<Integer, OneBlockObject> result = new HashMap<Integer, OneBlockObject>();
        for (String key : firstBlocksConfig.getKeys(false)) {
            if (!NumberUtils.isNumber((String)key)) {
                this.addon.logError("Fixed block key must be an integer. " + key);
                continue;
            }
            int k = Integer.parseInt(key);
            this.parseBlock(result, firstBlocksConfig, key, k);
        }
        return result;
    }

    private void parseBlock(Map<Integer, OneBlockObject> result, ConfigurationSection firstBlocksConfig, String key, int k) {
        if (firstBlocksConfig.isConfigurationSection(key)) {
            this.parseObjectBlock(result, firstBlocksConfig, key, k);
        } else {
            this.parseStringBlock(result, firstBlocksConfig, key, k);
        }
    }

    private void parseObjectBlock(Map<Integer, OneBlockObject> result, ConfigurationSection firstBlocksConfig, String key, int k) {
        Map map = firstBlocksConfig.getConfigurationSection(key).getValues(false);
        Optional<OneBlockCustomBlock> customBlock = OneBlockCustomBlockCreator.create(map);
        if (customBlock.isPresent()) {
            result.put(k, new OneBlockObject(customBlock.get(), 0));
        } else {
            this.addon.logError("Fixed block key " + key + " material is not a valid custom block. Ignoring.");
        }
    }

    private void parseStringBlock(Map<Integer, OneBlockObject> result, ConfigurationSection firstBlocksConfig, String key, int k) {
        String mat = firstBlocksConfig.getString(key);
        if (mat == null) {
            return;
        }
        Optional<OneBlockCustomBlock> customBlock = OneBlockCustomBlockCreator.create(mat);
        if (customBlock.isPresent()) {
            result.put(k, new OneBlockObject(customBlock.get(), 0));
        } else {
            Material m = Material.matchMaterial((String)mat);
            if (m != null && m.isBlock()) {
                result.put(k, new OneBlockObject(m, 0));
            } else {
                this.addon.logError("Fixed block key " + key + " material is invalid or not a block. Ignoring.");
            }
        }
    }

    private void addHologramLines(OneBlockPhase obPhase, ConfigurationSection fb) {
        if (fb == null) {
            return;
        }
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (String key : fb.getKeys(false)) {
            if (!NumberUtils.isNumber((String)key)) {
                this.addon.logError("Fixed block key must be an integer. " + key);
                continue;
            }
            int k = Integer.parseInt(key);
            String line = fb.getString(key);
            if (line == null) continue;
            result.put(k, line);
        }
        obPhase.setHologramLines(result);
    }

    private Biome getBiome(String string) {
        if (string == null) {
            return Biome.PLAINS;
        }
        NamespacedKey key = NamespacedKey.fromString((String)string.toLowerCase(Locale.ENGLISH));
        Biome result = (Biome)Registry.BIOME.get(key);
        if (result == null) {
            this.addon.logError("Biome " + string + " is invalid! Use one of these...");
            Registry.BIOME.stream().sorted(Comparator.comparing(biome -> biome.getKey().getKey())).forEach(biome -> this.addon.logError(biome.getKey().getKey()));
            return Biome.PLAINS;
        }
        return result;
    }

    void addFirstBlock(OneBlockPhase obPhase, @Nullable String material) {
        if (material == null) {
            return;
        }
        Material m = Material.matchMaterial((String)material);
        if (m == null || !m.isBlock()) {
            this.addon.logError("Bad firstBlock material: " + material);
        } else {
            obPhase.setFirstBlock(new OneBlockObject(m, 0));
        }
    }

    void addCommands(OneBlockPhase obPhase, ConfigurationSection phase) {
        if (phase.contains(START_COMMANDS)) {
            obPhase.setStartCommands(phase.getStringList(START_COMMANDS));
        }
        if (phase.contains(END_COMMANDS)) {
            obPhase.setEndCommands(phase.getStringList(END_COMMANDS));
        }
        if (phase.contains(END_COMMANDS_FIRST_TIME)) {
            obPhase.setFirstTimeEndCommands(phase.getStringList(END_COMMANDS_FIRST_TIME));
        }
    }

    void addRequirements(OneBlockPhase obPhase, ConfigurationSection phase) {
        ArrayList<Requirement> reqList = new ArrayList<Requirement>();
        if (!phase.isConfigurationSection(REQUIREMENTS)) {
            return;
        }
        ConfigurationSection reqs = phase.getConfigurationSection(REQUIREMENTS);
        for (Requirement.ReqType key : Requirement.ReqType.values()) {
            if (!reqs.contains(key.getKey())) continue;
            Requirement r = key.getClazz().equals(Double.class) ? new Requirement(key, reqs.getDouble(key.getKey())) : (key.getClazz().equals(Long.class) ? new Requirement(key, reqs.getLong(key.getKey())) : new Requirement(key, reqs.getString(key.getKey())));
            reqList.add(r);
        }
        obPhase.setRequirements(reqList);
    }

    void addChests(OneBlockPhase obPhase, ConfigurationSection phase) throws IOException {
        if (!phase.isConfigurationSection(CHESTS)) {
            return;
        }
        if (!obPhase.getChests().isEmpty()) {
            throw new IOException(obPhase.getPhaseName() + ": Chests cannot be set more than once. Duplicate file?");
        }
        ConfigurationSection chests = phase.getConfigurationSection(CHESTS);
        for (String chestId : chests.getKeys(false)) {
            ConfigurationSection chest = chests.getConfigurationSection(chestId);
            OneBlockObject.Rarity rarity = OneBlockObject.Rarity.COMMON;
            try {
                rarity = OneBlockObject.Rarity.valueOf(chest.getString(RARITY, "COMMON").toUpperCase());
            }
            catch (Exception e) {
                this.addon.logError("Rarity value of " + chest.getString(RARITY, "UNKNOWN") + " is invalid! Use one of these...");
                this.addon.logError(Arrays.stream(OneBlockObject.Rarity.values()).map(Enum::name).collect(Collectors.joining(",")));
                rarity = OneBlockObject.Rarity.COMMON;
            }
            HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
            ConfigurationSection contents = chest.getConfigurationSection(CONTENTS);
            if (contents != null) {
                for (String index : contents.getKeys(false)) {
                    int slot = Integer.parseInt(index);
                    ItemStack item = contents.getItemStack(index);
                    if (item == null) continue;
                    items.put(slot, item);
                }
            }
            obPhase.addChest(items, rarity);
        }
    }

    void addMobs(OneBlockPhase obPhase, ConfigurationSection phase) throws IOException {
        if (!phase.isConfigurationSection(MOBS)) {
            return;
        }
        if (!obPhase.getMobs().isEmpty()) {
            throw new IOException(obPhase.getPhaseName() + ": Mobs cannot be set more than once. Duplicate file?");
        }
        ConfigurationSection mobs = phase.getConfigurationSection(MOBS);
        for (String entity : mobs.getKeys(false)) {
            String name = entity.toUpperCase(Locale.ENGLISH);
            EntityType et = null;
            et = name.equals("PIG_ZOMBIE") || name.equals("ZOMBIFIED_PIGLIN") ? (EntityType)Enums.getIfPresent(EntityType.class, (String)"ZOMBIFIED_PIGLIN").or((Object)((EntityType)Enums.getIfPresent(EntityType.class, (String)"PIG_ZOMBIE").or((Object)EntityType.PIG))) : (EntityType)Enums.getIfPresent(EntityType.class, (String)name).orNull();
            if (et == null) {
                this.addon.logError("Bad entity type in " + obPhase.getPhaseName() + ": " + entity);
                this.addon.logError("Try one of these...");
                this.addon.logError(Arrays.stream(EntityType.values()).filter(EntityType::isSpawnable).filter(EntityType::isAlive).map(Enum::name).collect(Collectors.joining(",")));
                return;
            }
            if (et.isSpawnable() && et.isAlive()) {
                if (mobs.getInt(entity) > 0) {
                    obPhase.addMob(et, mobs.getInt(entity));
                    continue;
                }
                this.addon.logWarning("Bad entity weight for " + obPhase.getPhaseName() + ": " + entity + ". Must be positive number above 1.");
                continue;
            }
            this.addon.logError("Entity type is not spawnable " + obPhase.getPhaseName() + ": " + entity);
        }
    }

    void addBlocks(OneBlockPhase obPhase, ConfigurationSection phase) {
        block4: {
            block3: {
                if (!phase.isConfigurationSection(BLOCKS)) break block3;
                ConfigurationSection blocks = phase.getConfigurationSection(BLOCKS);
                for (String material : blocks.getKeys(false)) {
                    this.addMaterial(obPhase, material, Objects.toString(blocks.get(material)));
                }
                break block4;
            }
            if (!phase.isList(BLOCKS)) break block4;
            List blocks = phase.getMapList(BLOCKS);
            for (Map map : blocks) {
                Map.Entry entry;
                if (map.size() == 1 && this.addMaterial(obPhase, Objects.toString((entry = map.entrySet().iterator().next()).getKey()), Objects.toString(entry.getValue()))) continue;
                int probability = Integer.parseInt(Objects.toString(map.get("probability"), "0"));
                Optional<OneBlockCustomBlock> customBlock = OneBlockCustomBlockCreator.create(map);
                if (customBlock.isPresent()) {
                    obPhase.addCustomBlock(customBlock.get(), probability);
                    continue;
                }
                this.addon.logError("Bad custom block in " + obPhase.getPhaseName() + ": " + String.valueOf(map));
            }
        }
    }

    private boolean addMaterial(OneBlockPhase obPhase, String material, String probability) {
        int prob;
        try {
            prob = Integer.parseInt(probability);
        }
        catch (Exception e) {
            return false;
        }
        if (prob < 1) {
            this.addon.logWarning("Bad item weight for " + obPhase.getPhaseName() + ": " + material + ". Must be positive number above 1.");
            return false;
        }
        Optional<OneBlockCustomBlock> optionalCustomBlock = OneBlockCustomBlockCreator.create(material);
        if (optionalCustomBlock.isPresent()) {
            obPhase.addCustomBlock(optionalCustomBlock.get(), prob);
            return true;
        }
        Material m = Material.matchMaterial((String)material);
        if (m == null || !m.isBlock()) {
            this.addon.logError("Bad block material in " + obPhase.getPhaseName() + ": " + material);
            return false;
        }
        obPhase.addBlock(m, prob);
        return true;
    }

    public @Nullable OneBlockPhase getPhase(int blockCount) {
        Map.Entry<Integer, OneBlockPhase> en = this.blockProbs.floorEntry(blockCount);
        return en != null ? en.getValue() : null;
    }

    public List<String> getPhaseList() {
        return this.blockProbs.values().stream().map(OneBlockPhase::getPhaseName).filter(Objects::nonNull).map(n -> n.replace(" ", "_")).collect(Collectors.toList());
    }

    public NavigableMap<Integer, OneBlockPhase> getBlockProbs() {
        return this.blockProbs;
    }

    public Optional<OneBlockPhase> getPhase(String name) {
        return this.blockProbs.values().stream().filter(p -> p.getPhaseName() != null && (p.getPhaseName().equalsIgnoreCase(name) || p.getPhaseName().replace(" ", "_").equalsIgnoreCase(name))).findFirst();
    }

    public boolean saveOneBlockConfig() {
        boolean success = true;
        for (OneBlockPhase p : this.blockProbs.values()) {
            success = this.savePhase(p);
        }
        return success;
    }

    public boolean savePhase(OneBlockPhase p) {
        if (!this.saveMainPhase(p)) {
            return false;
        }
        if (p.isGotoPhase()) {
            return true;
        }
        return this.saveChestPhase(p);
    }

    private boolean saveMainPhase(OneBlockPhase p) {
        YamlConfiguration oneBlocks = new YamlConfiguration();
        ConfigurationSection phSec = oneBlocks.createSection(p.getBlockNumber());
        if (p.isGotoPhase()) {
            phSec.set(GOTO_BLOCK, (Object)p.getGotoBlock());
        } else {
            phSec.set(NAME, (Object)p.getPhaseName());
            if (p.getIconBlock() != null) {
                phSec.set(ICON, (Object)p.getIconBlock().getType().name());
            }
            if (p.getFirstBlock() != null) {
                phSec.set(FIRST_BLOCK, (Object)p.getFirstBlock().getMaterial().name());
            }
            if (p.getPhaseBiome() != null) {
                phSec.set(BIOME, (Object)p.getPhaseBiome().name());
            }
            this.saveBlocks(phSec, p);
            this.saveEntities(phSec, p);
            this.saveHolos(phSec, p);
            this.saveCommands(phSec, p);
        }
        try {
            File phaseFile = new File(String.valueOf(this.addon.getDataFolder()) + File.separator + PHASES, this.getPhaseFileName(p) + ".yml");
            oneBlocks.save(phaseFile);
        }
        catch (IOException e) {
            this.addon.logError("Could not save phase " + p.getPhaseName() + " " + e.getMessage());
            return false;
        }
        return true;
    }

    private void saveCommands(ConfigurationSection phSec, OneBlockPhase p) {
        phSec.set(START_COMMANDS, p.getStartCommands());
        phSec.set(END_COMMANDS, p.getEndCommands());
    }

    private void saveHolos(ConfigurationSection phSec, OneBlockPhase p) {
        if (p.getHologramLines() == null) {
            return;
        }
        ConfigurationSection holos = phSec.createSection(HOLOGRAMS);
        p.getHologramLines().forEach((k, v) -> holos.set(String.valueOf(k), v));
    }

    private boolean saveChestPhase(OneBlockPhase p) {
        YamlConfiguration oneBlocks = new YamlConfiguration();
        ConfigurationSection phSec = oneBlocks.createSection(p.getBlockNumber());
        this.saveChests(phSec, p);
        try {
            File phaseFile = new File(String.valueOf(this.addon.getDataFolder()) + File.separator + PHASES, this.getPhaseFileName(p) + "_chests.yml");
            oneBlocks.save(phaseFile);
        }
        catch (IOException e) {
            this.addon.logError("Could not save chest phase " + p.getPhaseName() + " " + e.getMessage());
            return false;
        }
        return true;
    }

    private String getPhaseFileName(OneBlockPhase p) {
        if (p.isGotoPhase()) {
            return p.getBlockNumber() + "_goto_" + p.getGotoBlock();
        }
        return p.getBlockNumber() + "_" + (p.getPhaseName() == null ? "" : p.getPhaseName().toLowerCase().replace(' ', '_'));
    }

    private void saveChests(ConfigurationSection phSec, OneBlockPhase phase) {
        ConfigurationSection chests = phSec.createSection(CHESTS);
        int index = 1;
        for (OneBlockObject chest : phase.getChests()) {
            ConfigurationSection c = chests.createSection(String.valueOf(index++));
            c.set(CONTENTS, chest.getChest());
            c.set(RARITY, (Object)chest.getRarity().name());
        }
    }

    private void saveEntities(ConfigurationSection phSec, OneBlockPhase phase) {
        ConfigurationSection mobs = phSec.createSection(MOBS);
        phase.getMobs().forEach((k, v) -> mobs.set(k.name(), v));
    }

    private void saveBlocks(ConfigurationSection phSec, OneBlockPhase phase) {
        ConfigurationSection fixedBlocks = phSec.createSection(FIXED_BLOCKS);
        phase.getFixedBlocks().forEach((k, v) -> fixedBlocks.set(String.valueOf(k), (Object)v.getMaterial().name()));
        ConfigurationSection blocks = phSec.createSection(BLOCKS);
        phase.getBlocks().forEach((k, v) -> blocks.set(k.name(), v));
    }

    public @Nullable OneBlockPhase getNextPhase(@NonNull OneBlockPhase phase) {
        Integer blockNum = phase.getBlockNumberValue();
        Integer nextKey = this.blockProbs.ceilingKey(blockNum + 1);
        return nextKey != null ? this.getPhase(nextKey) : null;
    }

    public int getNextPhaseBlocks(@NonNull OneBlockIslands obi) {
        Integer blockNum = obi.getBlockNumber();
        Integer nextKey = this.blockProbs.ceilingKey(blockNum + 1);
        if (nextKey == null) {
            return -1;
        }
        OneBlockPhase nextPhase = this.getPhase(nextKey);
        return nextPhase == null ? -1 : nextPhase.getBlockNumberValue() - obi.getBlockNumber();
    }

    public int getPhaseBlocks(@NonNull OneBlockIslands obi) {
        Integer blockNum = obi.getBlockNumber();
        Integer nextKey = this.blockProbs.ceilingKey(blockNum + 1);
        if (nextKey == null) {
            return -1;
        }
        OneBlockPhase thisPhase = this.getPhase(blockNum);
        if (thisPhase == null) {
            return -1;
        }
        OneBlockPhase nextPhase = this.getPhase(nextKey);
        return nextPhase == null ? -1 : nextPhase.getBlockNumberValue() - thisPhase.getBlockNumberValue();
    }

    public double getPercentageDone(@NonNull OneBlockIslands obi) {
        int blockNum = obi.getBlockNumber();
        OneBlockPhase thisPhase = this.getPhase(blockNum);
        if (thisPhase == null) {
            return 0.0;
        }
        Integer nextKey = this.blockProbs.ceilingKey(blockNum + 1);
        if (nextKey == null) {
            return 0.0;
        }
        OneBlockPhase nextPhase = this.getPhase(nextKey);
        if (nextPhase == null) {
            return 0.0;
        }
        int phaseSize = nextPhase.getBlockNumberValue() - thisPhase.getBlockNumberValue();
        return 100.0 - 100.0 * (double)(nextPhase.getBlockNumberValue() - obi.getBlockNumber()) / (double)phaseSize;
    }

    public void getProbs(OneBlockPhase phase) {
        Integer blockNum = Integer.valueOf(phase.getBlockNumber());
        Integer nextKey = this.blockProbs.ceilingKey(blockNum + 1);
        if (nextKey != null) {
            int phaseSize = nextKey - blockNum;
            int blockTotal = phase.getBlockTotal();
            int likelyChestTotal = 0;
            double totalBlocks = 0.0;
            for (Map.Entry<Material, Integer> en : phase.getBlocks().entrySet()) {
                double chance = (double)en.getValue().intValue() / (double)blockTotal;
                double likelyNumberGenerated = chance * (double)phaseSize;
                totalBlocks += likelyNumberGenerated;
                String report = String.valueOf(en.getKey()) + " likely generated = " + Math.round(likelyNumberGenerated) + " = " + Math.round(likelyNumberGenerated * 100.0 / (double)phaseSize) + "%";
                if (likelyNumberGenerated < 1.0) {
                    this.addon.logWarning(report);
                } else {
                    this.addon.log(report);
                }
                if (!en.getKey().equals((Object)Material.CHEST)) continue;
                likelyChestTotal = (int)Math.round(likelyNumberGenerated);
            }
            this.addon.log("Total blocks generated = " + totalBlocks);
            if (likelyChestTotal == 0) {
                this.addon.logWarning("No chests will be generated");
                return;
            }
            this.addon.log("**** A total of " + likelyChestTotal + " chests will be generated ****");
            double lastChance = 0.0;
            for (Map.Entry<Double, OneBlockObject.Rarity> en : OneBlockPhase.CHEST_CHANCES.entrySet()) {
                int num = phase.getChestsMap().getOrDefault((Object)en.getValue(), Collections.emptyList()).size();
                double likelyNumberGenerated = (en.getKey() - lastChance) * (double)likelyChestTotal;
                lastChance = en.getKey();
                String report = num + " " + String.valueOf((Object)en.getValue()) + " chests in phase. Likely number generated = " + Math.round(likelyNumberGenerated);
                if (num > 0 && likelyNumberGenerated < 1.0) {
                    this.addon.logWarning(report);
                    continue;
                }
                this.addon.log(report);
            }
            this.addon.log("-=-=-=-= Mobs -=-=-=-=-");
            double totalMobs = 0.0;
            for (Map.Entry<EntityType, Integer> en : phase.getMobs().entrySet()) {
                double chance = (double)en.getValue().intValue() / (double)phase.getTotal();
                double likelyNumberGenerated = chance * (double)phaseSize;
                totalMobs += likelyNumberGenerated;
                String report = String.valueOf(en.getKey()) + " likely generated = " + Math.round(likelyNumberGenerated) + " = " + Math.round(likelyNumberGenerated * 100.0 / (double)phaseSize) + "%";
                if (likelyNumberGenerated < 1.0) {
                    this.addon.logWarning(report);
                    continue;
                }
                this.addon.log(report);
            }
            this.addon.log("**** A total of " + Math.round(totalMobs) + " mobs will likely be generated ****");
        }
    }

    public void getAllProbs() {
        this.blockProbs.values().forEach(this::getProbs);
    }

    public String getNextPhase(@NonNull OneBlockIslands obi) {
        return this.getPhase(obi.getPhaseName()).map(this::getNextPhase).filter(Objects::nonNull).map(OneBlockPhase::getPhaseName).orElse("");
    }
}

