/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.aoneblock.oneblocks.customblock;

import dev.lone.itemsadder.api.CustomBlock;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.block.Block;
import world.bentobox.aoneblock.AOneBlock;
import world.bentobox.aoneblock.oneblocks.OneBlockCustomBlock;
import world.bentobox.bentobox.BentoBox;

public class ItemsAdderCustomBlock
implements OneBlockCustomBlock {
    private final CustomBlock customBlock;

    public ItemsAdderCustomBlock(CustomBlock customBlock) {
        this.customBlock = customBlock;
    }

    public static Optional<ItemsAdderCustomBlock> fromId(String id) {
        return Optional.ofNullable(CustomBlock.getInstance((String)id)).map(ItemsAdderCustomBlock::new);
    }

    public static Optional<ItemsAdderCustomBlock> fromMap(Map<?, ?> map) {
        return Optional.ofNullable(Objects.toString(map.get("id"), null)).flatMap(ItemsAdderCustomBlock::fromId);
    }

    @Override
    public void execute(AOneBlock addon, Block block) {
        try {
            block.setType(Material.AIR);
            this.customBlock.place(block.getLocation());
        }
        catch (Exception e) {
            BentoBox.getInstance().logError("Could not place custom block " + this.customBlock.getId() + " for block " + String.valueOf(block.getType()));
            block.setType(Material.STONE);
        }
    }
}

