/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_fabric.parts.vanguard.util;

import com.natamus.collective_common_fabric.functions.EntityFunctions;
import com.natamus.collective_common_fabric.functions.TaskFunctions;
import com.natamus.voidvanguards_common_fabric.data.HeadData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2465;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3854;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;

public class VanguardUtil {
    public static List<class_1309> getVanguardsToSummon(class_1937 level, int amount) {
        ArrayList<class_1309> vanguardsToSummon = new ArrayList<class_1309>();
        for (int i = 0; i < amount; ++i) {
            class_1799 headStack;
            class_1646 vanguardVillager = (class_1646)class_1299.field_6077.method_5883(level);
            vanguardVillager.method_5826(UUID.randomUUID());
            if (vanguardsToSummon.isEmpty()) {
                headStack = HeadData.getGeneratedHead(HeadData.HeadType.VANGUARD_LEADER);
                vanguardVillager.method_5780("voidvanguards.vanguard_leader");
                vanguardVillager.method_5665((class_2561)class_2561.method_43471((String)"voidvanguards.vanguard.name.leader").method_27692(class_124.field_1079));
                vanguardVillager.method_7195(vanguardVillager.method_7231().method_16922(class_3854.field_17074));
            } else {
                headStack = HeadData.getGeneratedHead(HeadData.HeadType.VANGUARD);
                vanguardVillager.method_5780("voidvanguards.vanguard_recruit");
                vanguardVillager.method_5665((class_2561)class_2561.method_43471((String)"voidvanguards.vanguard.name.recruit"));
                vanguardVillager.method_7195(vanguardVillager.method_7231().method_16922(class_3854.field_17075));
            }
            vanguardVillager.method_5673(class_1304.field_6169, headStack);
            EntityFunctions.getGoalSelector((class_1308)vanguardVillager).method_35113(goal -> true);
            EntityFunctions.getTargetSelector((class_1308)vanguardVillager).method_35113(goal -> true);
            vanguardVillager.method_5996(class_5134.field_23719).method_6192(0.0);
            vanguardVillager.method_5752().add("voidvanguards.vanguard");
            vanguardVillager.method_5971();
            vanguardVillager.method_5952(false);
            vanguardsToSummon.add((class_1309)vanguardVillager);
        }
        return vanguardsToSummon;
    }

    public static List<class_2338> getVanguardPositions(class_2338 middlePos, int amount) {
        ArrayList<class_2338> positions;
        if (amount == 1) {
            positions = new ArrayList<class_2338>(Arrays.asList(middlePos.method_10076(4)));
        } else if (amount == 4) {
            positions = new ArrayList<class_2338>(Arrays.asList(middlePos.method_10076(4), middlePos.method_10089(4), middlePos.method_10077(4), middlePos.method_10088(4)));
        } else if (amount == 8) {
            positions = new ArrayList<class_2338>(Arrays.asList(middlePos.method_10076(4), middlePos.method_10076(3).method_10089(3), middlePos.method_10089(4), middlePos.method_10077(3).method_10089(3), middlePos.method_10077(4), middlePos.method_10077(3).method_10088(3), middlePos.method_10088(4), middlePos.method_10076(3).method_10088(3)));
        } else {
            return new ArrayList<class_2338>();
        }
        return positions;
    }

    public static void spawnGenerationParticles(class_3218 serverLevel, class_2338 blockPos) {
        for (class_2338 aroundPos : class_2338.method_10097((class_2338)blockPos.method_10069(-1, -1, -1), (class_2338)blockPos.method_10069(1, 1, 1))) {
            VanguardUtil.spawnParticles(serverLevel, aroundPos, class_2398.field_11207, 5);
        }
    }

    public static void spawnTeleportParticles(class_3218 serverLevel, class_2338 blockPos) {
        VanguardUtil.spawnParticles(serverLevel, blockPos, class_2398.field_11216, 15);
    }

    public static void spawnParticles(class_3218 serverLevel, class_2338 blockPos, class_2400 simpleParticleType, int amount) {
        double x = (double)blockPos.method_10263() + 0.5;
        double y = (double)blockPos.method_10264() + 0.5;
        double z = (double)blockPos.method_10260() + 0.5;
        for (int j = 0; j < amount; ++j) {
            double offsetX = (serverLevel.field_9229.method_43058() - 0.5) * 2.0;
            double offsetY = serverLevel.field_9229.method_43058() * 1.5;
            double offsetZ = (serverLevel.field_9229.method_43058() - 0.5) * 2.0;
            serverLevel.method_14199((class_2394)simpleParticleType, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static List<class_2338> getTorchLocations(class_2338 middlePos) {
        return new ArrayList<class_2338>(Arrays.asList(middlePos.method_10076(4).method_10089(2), middlePos.method_10076(4).method_10088(2), middlePos.method_10089(4).method_10076(2), middlePos.method_10089(4).method_10077(2), middlePos.method_10077(4).method_10089(2), middlePos.method_10077(4).method_10088(2), middlePos.method_10088(4).method_10076(2), middlePos.method_10088(4).method_10077(2)));
    }

    public static void removeGrassBetweenVanguards(class_1937 level, List<class_2338> vanguardPositions) {
        if (vanguardPositions.isEmpty()) {
            return;
        }
        int minX = vanguardPositions.stream().mapToInt(class_2382::method_10263).min().orElse(0);
        int maxX = vanguardPositions.stream().mapToInt(class_2382::method_10263).max().orElse(0);
        int minZ = vanguardPositions.stream().mapToInt(class_2382::method_10260).min().orElse(0);
        int maxZ = vanguardPositions.stream().mapToInt(class_2382::method_10260).max().orElse(0);
        int y = vanguardPositions.get(0).method_10264();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                class_2338 pos = new class_2338(x, y, z);
                class_2680 state = level.method_8320(pos);
                if (!state.method_27852(class_2246.field_10479) && !state.method_27852(class_2246.field_10214)) continue;
                level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            }
        }
    }

    public static void keepPlayersWithinVanguardCircle(class_3222 serverPlayer, String forcedTag) {
        int radius;
        int z;
        int y;
        int x;
        String rawPositionPart = forcedTag.substring(forcedTag.indexOf("forcedPlayerPosition..") + "forcedPlayerPosition..".length(), forcedTag.indexOf("--radius.."));
        String rawRadiusPart = forcedTag.substring(forcedTag.indexOf("--radius..") + "--radius..".length());
        String[] rawCoordinates = rawPositionPart.split("_");
        try {
            x = Integer.parseInt(rawCoordinates[0]);
            y = Integer.parseInt(rawCoordinates[1]);
            z = Integer.parseInt(rawCoordinates[2]);
            radius = Integer.parseInt(rawRadiusPart);
        }
        catch (NumberFormatException ex) {
            return;
        }
        class_2338 centerPos = new class_2338(x, y, z);
        double dx = serverPlayer.method_23317() - (double)centerPos.method_10263();
        double dz = serverPlayer.method_23321() - (double)centerPos.method_10260();
        double distanceSquared = dx * dx + dz * dz;
        if (distanceSquared > (double)(radius * radius)) {
            serverPlayer.method_5859((double)centerPos.method_10263() + 0.5, serverPlayer.method_23318(), (double)centerPos.method_10260() + 0.5);
            VanguardUtil.spawnTeleportParticles(serverPlayer.method_51469(), centerPos);
        }
    }

    public static void oblibirateTreeAbovePosition(class_3218 serverLevel, class_2338 blockPos, int height, int radius) {
        MinecraftServer minecraftServer = serverLevel.method_8503();
        int i = 0;
        while (i < height) {
            int finalI = i++;
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                for (class_2338 aroundPos : class_2338.method_10097((class_2338)blockPos.method_10069(-radius, finalI, -radius), (class_2338)blockPos.method_10069(radius, finalI, radius))) {
                    class_2680 aroundBlockState = serverLevel.method_8320(aroundPos);
                    class_2248 aroundBlock = aroundBlockState.method_26204();
                    if (!(aroundBlock instanceof class_2465) && !(aroundBlock instanceof class_2397)) continue;
                    serverLevel.method_8652(aroundPos, class_2246.field_10124.method_9564(), 3);
                    VanguardUtil.spawnTeleportParticles(serverLevel, aroundPos);
                }
            }, (int)(finalI * 10));
        }
    }
}

