/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_fabric.parts.voidborn.functions;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.collective_common_fabric.functions.TaskFunctions;
import com.natamus.collective_common_fabric.functions.TileEntityFunctions;
import com.natamus.collective_common_fabric.schematic.ParseSchematicFile;
import com.natamus.collective_common_fabric.schematic.ParsedSchematicObject;
import com.natamus.collective_common_fabric.services.Services;
import com.natamus.voidvanguards_common_fabric.data.ServerSaveData;
import com.natamus.voidvanguards_common_fabric.parts.story.functions.StoryFunctions;
import com.natamus.voidvanguards_common_fabric.parts.vanguard.functions.VanguardFunctions;
import com.natamus.voidvanguards_common_fabric.parts.voidborn.data.VoidbornConstants;
import com.natamus.voidvanguards_common_fabric.parts.voidborn.util.VoidbornUtil;
import com.natamus.voidvanguards_common_fabric.util.SaveLoadUtils;
import com.natamus.voidvanguards_common_fabric.util.Util;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2401;
import net.minecraft.class_2551;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8242;
import net.minecraft.server.MinecraftServer;

public class VoidbornFunctions {
    public static final HashMap<UUID, Integer> skipCheck = new HashMap();

    public static void generateVoidbornCosmosGate(class_3218 serverLevel, class_3222 serverPlayer, class_2338 middlePos) {
        MinecraftServer minecraftServer = serverLevel.method_8503();
        class_3218 overworldLevel = minecraftServer.method_30002();
        InputStream schematicInputstream = Util.getSchematicsInputStream(minecraftServer, "cosmos_gate");
        if (schematicInputstream == null) {
            return;
        }
        ParsedSchematicObject parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)schematicInputstream, (class_1937)overworldLevel, (class_2338)middlePos, (int)-1, (boolean)false);
        if (!parsedSchematicObject.parsedCorrectly) {
            return;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            for (Pair blockPair : parsedSchematicObject.blocks) {
                overworldLevel.method_8652((class_2338)blockPair.getFirst(), (class_2680)blockPair.getSecond(), 3);
            }
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                class_2378 enchantmentRegistry = overworldLevel.method_30349().method_30530(class_7924.field_41265);
                for (class_2338 blockEntityPos : parsedSchematicObject.blockEntityPositions) {
                    class_2586 blockEntity = overworldLevel.method_8321(blockEntityPos);
                    if (blockEntity == null) continue;
                    class_2680 blockState = overworldLevel.method_8320(blockEntityPos);
                    class_2248 block = blockState.method_26204();
                    if (block.equals(class_2246.field_22104)) {
                        VoidbornUtil.replaceSignWithVoidbornMob(overworldLevel, blockEntityPos, (class_2378<class_1887>)enchantmentRegistry);
                        continue;
                    }
                    if (!block.equals(class_2246.field_10034)) continue;
                    VoidbornUtil.fillChestWithItems(overworldLevel, blockEntity, blockEntityPos, blockState, (class_2378<class_1887>)enchantmentRegistry);
                }
                UUID playerUUID = serverPlayer.method_5667();
                ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.add(playerUUID);
                ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.put(playerUUID, (Pair<class_5321<class_1937>, class_2338>)Pair.of((Object)overworldLevel.method_27983(), (Object)middlePos));
                SaveLoadUtils.savePlayerData((class_1657)serverPlayer);
            }, (int)0);
        }, (int)0);
    }

    public static void prepareCosmosVoidbornBase(class_3218 cosmosLevel, class_3222 serverPlayer, class_2338 voidbornCosmosBasePos, class_2338 spawnPos) {
        MinecraftServer minecraftServer = cosmosLevel.method_8503();
        InputStream schematicInputstream = Util.getSchematicsInputStream(minecraftServer, "enemy_base_orbit");
        if (schematicInputstream == null) {
            return;
        }
        ParsedSchematicObject parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)schematicInputstream, (class_1937)cosmosLevel, (class_2338)voidbornCosmosBasePos, (int)-54, (boolean)false);
        if (!parsedSchematicObject.parsedCorrectly) {
            return;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            for (Pair blockPair : parsedSchematicObject.blocks) {
                cosmosLevel.method_8652((class_2338)blockPair.getFirst(), (class_2680)blockPair.getSecond(), 3);
            }
            VoidbornFunctions.generateRadarStructure(cosmosLevel, serverPlayer, voidbornCosmosBasePos);
            class_2338 teleportBackButtonPos = VoidbornUtil.getTeleportBackButtonPosition(serverPlayer);
            cosmosLevel.method_8652(teleportBackButtonPos, (class_2680)class_2246.field_22101.method_9564().method_11657((class_2769)class_2269.field_11177, (Comparable)class_2350.field_11039), 3);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                class_2378 enchantmentRegistry = cosmosLevel.method_30349().method_30530(class_7924.field_41265);
                for (class_2338 entityBlockPos : parsedSchematicObject.blockEntityPositions) {
                    if (!cosmosLevel.method_8320(entityBlockPos).method_26204().equals(class_2246.field_22104)) continue;
                    VoidbornUtil.replaceSignWithVoidbornMob(cosmosLevel, entityBlockPos, (class_2378<class_1887>)enchantmentRegistry);
                }
                ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.add(serverPlayer.method_5667());
                SaveLoadUtils.savePlayerData((class_1657)serverPlayer);
                Services.TELEPORT.teleportEntity((class_1297)serverPlayer, cosmosLevel, spawnPos);
                Util.removeTag(serverPlayer, "voidvanguards.triggeredEntityInside");
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                    for (class_1542 itemEntity : cosmosLevel.method_8390(class_1542.class, new class_238(spawnPos).method_1014(120.0), e -> true)) {
                        itemEntity.method_31472();
                    }
                }, (int)10);
            }, (int)0);
        }, (int)0);
    }

    public static void generateRadarStructure(class_3218 serverLevel, class_3222 serverPlayer, class_2338 voidbornCosmosBasePos) {
        MinecraftServer minecraftServer = serverLevel.method_8503();
        class_2338 voidbornBaseBlockPos = Util.getRANDOMVoidbornCosmosGateCoordinates(serverLevel, serverPlayer);
        class_2338 radarPos = voidbornCosmosBasePos.method_10069(-26, 7, -37);
        InputStream schematicInputstream = Util.getSchematicsInputStream(minecraftServer, "radar");
        if (schematicInputstream == null) {
            return;
        }
        ParsedSchematicObject parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)schematicInputstream, (class_1937)serverLevel, (class_2338)radarPos, (int)0, (boolean)true);
        if (!parsedSchematicObject.parsedCorrectly) {
            return;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            for (Pair blockPair : parsedSchematicObject.blocks) {
                serverLevel.method_8652((class_2338)blockPair.getFirst(), (class_2680)blockPair.getSecond(), 3);
            }
            class_2338 signPos = radarPos.method_10069(-2, 2, 0);
            serverLevel.method_8501(signPos, (class_2680)class_2246.field_22107.method_9564().method_11657((class_2769)class_2551.field_11726, (Comparable)class_2350.field_11039));
            class_2586 patt0$temp = serverLevel.method_8321(signPos);
            if (patt0$temp instanceof class_2625) {
                class_2625 signBlockEntity = (class_2625)patt0$temp;
                class_8242 signText = signBlockEntity.method_49853();
                signText = signText.method_49857(0, (class_2561)class_2561.method_43471((String)"voidvanguards.message.voidborn.base.radarSign.text.0").method_27692(class_124.field_1068));
                signText = signText.method_49857(1, (class_2561)class_2561.method_43471((String)"voidvanguards.message.voidborn.base.radarSign.text.1").method_27692(class_124.field_1068));
                signText = signText.method_49857(2, (class_2561)class_2561.method_43471((String)"voidvanguards.message.voidborn.base.radarSign.text.2").method_27692(class_124.field_1068));
                signText = signText.method_49857(3, (class_2561)class_2561.method_43471((String)"voidvanguards.message.voidborn.base.radarSign.text.3").method_27692(class_124.field_1068));
                signBlockEntity.method_49840(signText, true);
                TileEntityFunctions.updateTileEntity((class_1937)serverLevel, (class_2338)signPos, (class_2586)signBlockEntity);
            }
            class_2338 leverPos = signPos.method_10069(0, -1, 0);
            serverLevel.method_8652(leverPos, (class_2680)class_2246.field_10363.method_9564().method_11657((class_2769)class_2401.field_11177, (Comparable)class_2350.field_11039), 3);
        }, (int)0);
    }

    public static void checkVoidbornLeftForStoryTrigger(class_3218 cosmosLevel, class_3222 serverPlayer) {
        if (cosmosLevel.method_8407().equals((Object)class_1267.field_5801)) {
            return;
        }
        if (!Util.isInCosmosDimension(serverPlayer)) {
            return;
        }
        UUID playerUUID = serverPlayer.method_5667();
        if (ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.contains(playerUUID)) {
            return;
        }
        if (ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.contains(playerUUID)) {
            return;
        }
        if (skipCheck.containsKey(playerUUID)) {
            int playerSkipCheckCount = skipCheck.get(playerUUID);
            if (playerSkipCheckCount > 0) {
                skipCheck.put(playerUUID, playerSkipCheckCount - 1);
                return;
            }
        } else {
            skipCheck.put(playerUUID, 5);
            return;
        }
        List nearbyEntities = cosmosLevel.method_8390(class_1308.class, serverPlayer.method_5829().method_1014(120.0), e -> e.method_5752().contains("voidvanguards.voidborn"));
        int voidbornCount = nearbyEntities.size();
        if (voidbornCount > VoidbornConstants.voidbornBaseMobCountStoryTrigger || voidbornCount < 5) {
            return;
        }
        class_2338 basePos = serverPlayer.method_24515();
        class_2350 facing = serverPlayer.method_5735();
        class_2338 voidbornLeaderPos = null;
        for (int i = 1; i <= 3; ++i) {
            boolean isClear;
            class_2338 checkPos = basePos.method_10079(facing, i);
            boolean bl = isClear = cosmosLevel.method_8320(checkPos).method_26215() && cosmosLevel.method_8320(checkPos.method_10084()).method_26215();
            if (!isClear) continue;
            voidbornLeaderPos = checkPos;
            break;
        }
        if (voidbornLeaderPos == null) {
            voidbornLeaderPos = basePos.method_10079(facing, 2);
        }
        class_1308 voidbornLeader = VoidbornUtil.spawnVoidbornLeader(cosmosLevel, voidbornLeaderPos);
        SaveLoadUtils.setForcedPositionTag(serverPlayer, 5, basePos);
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)cosmosLevel.method_8503(), () -> StoryFunctions.processInitialVoidbornLeaderEncounter(cosmosLevel, serverPlayer, voidbornLeader), (int)10);
    }

    public static void voidbornRadarLeverWasTriggered(class_3218 serverLevel, class_3222 serverPlayer) {
        UUID playerUUID = serverPlayer.method_5667();
        VoidbornUtil.spawnLightningAtRadarEndRods(serverPlayer);
        MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)class_2561.method_43471((String)"voidvanguards.message.voidborn.base.radarLever.flip").method_27692(class_124.field_1061));
        ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.add(playerUUID);
        SaveLoadUtils.savePlayerData((class_1657)serverPlayer);
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.method_8503(), () -> VanguardFunctions.processVanguardTreeTeleportVoidbase(serverLevel, serverPlayer), (int)100);
    }
}

