/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_fabric.parts.voidborn.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.TaskFunctions;
import com.natamus.voidvanguards_common_fabric.data.HeadData;
import com.natamus.voidvanguards_common_fabric.parts.cosmos.util.CosmosDimensionUtil;
import com.natamus.voidvanguards_common_fabric.parts.vanguard.util.VanguardUtil;
import com.natamus.voidvanguards_common_fabric.parts.voidborn.data.VoidbornConstants;
import com.natamus.voidvanguards_common_fabric.registry.identifier.CosmosLocation;
import com.natamus.voidvanguards_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class VoidbornUtil {
    public static void replaceSignWithVoidbornMob(class_3218 serverLevel, class_2338 blockPos, class_2378<class_1887> enchantmentRegistry) {
        class_1308 voidbornMob = VoidbornUtil.getVoidbornMob(serverLevel, blockPos, enchantmentRegistry, false);
        serverLevel.method_8649((class_1297)voidbornMob);
        serverLevel.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
    }

    public static class_1308 getVoidbornMob(class_3218 serverLevel, class_2338 blockPos, class_2378<class_1887> enchantmentRegistry, boolean isLeader) {
        Pair<class_1299<?>, class_1308> voidbornMobPair = VoidbornUtil.getRandomVoidbornMob(serverLevel);
        return VoidbornUtil.getVoidbornMob(serverLevel, blockPos, enchantmentRegistry, isLeader, (class_1299)voidbornMobPair.getFirst(), (class_1308)voidbornMobPair.getSecond());
    }

    public static class_1308 getVoidbornMob(class_3218 serverLevel, class_2338 blockPos, class_2378<class_1887> enchantmentRegistry, boolean isLeader, class_1299<?> voidbornMobEntityType, class_1308 voidbornMob) {
        voidbornMob.method_5814((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5);
        if (isLeader) {
            voidbornMob.method_5665((class_2561)class_2561.method_43471((String)"voidvanguards.voidborn.name.leader").method_27692(class_124.field_1064));
            voidbornMob.method_5673(class_1304.field_6169, HeadData.getGeneratedHead(HeadData.HeadType.VOIDBORN_LEADER));
        } else {
            voidbornMob.method_5665((class_2561)class_2561.method_43471((String)"voidvanguards.voidborn.name.recruit"));
            voidbornMob.method_5673(class_1304.field_6169, HeadData.getGeneratedHead(HeadData.HeadType.VOIDBORN));
        }
        class_1792 weaponItem = VoidbornUtil.getRandomVoidbornMobWeapon(voidbornMobEntityType);
        class_1799 weaponStack = new class_1799((class_1935)weaponItem);
        weaponStack.method_7978(enchantmentRegistry.method_47983((Object)((class_1887)enchantmentRegistry.method_29107(class_1893.field_9125))), 1);
        voidbornMob.method_5673(class_1304.field_6173, weaponStack);
        voidbornMob.method_5752().add("voidvanguards.voidborn");
        voidbornMob.method_5971();
        voidbornMob.method_5952(false);
        return voidbornMob;
    }

    public static class_1308 getVoidbornLeader(class_3218 serverLevel, class_2338 blockPos) {
        class_1299 leaderVoidbornType = class_1299.field_6090;
        class_1308 voidbornLeader = VoidbornUtil.getVoidbornMob(serverLevel, blockPos, (class_2378<class_1887>)serverLevel.method_30349().method_30530(class_7924.field_41265), true, leaderVoidbornType, (class_1308)leaderVoidbornType.method_5883((class_1937)serverLevel));
        voidbornLeader.method_5996(class_5134.field_23719).method_6192(0.0);
        voidbornLeader.method_5780("voidvanguards.voidborn_leader");
        return voidbornLeader;
    }

    public static class_1308 spawnVoidbornLeader(class_3218 serverLevel, class_2338 blockPos) {
        class_1308 voidbornLeader = VoidbornUtil.getVoidbornLeader(serverLevel, blockPos);
        serverLevel.method_8649((class_1297)voidbornLeader);
        VanguardUtil.spawnTeleportParticles(serverLevel, blockPos);
        return voidbornLeader;
    }

    public static Pair<class_1299<?>, class_1308> getRandomVoidbornMob(class_3218 serverLevel) {
        class_1299<?> randomType = VoidbornConstants.possibleEnemyMobVariants.get(serverLevel.method_8409().method_43048(VoidbornConstants.possibleEnemyMobVariants.size()));
        return Pair.of(randomType, (Object)((class_1308)randomType.method_5883((class_1937)serverLevel)));
    }

    public static class_1792 getRandomVoidbornMobWeapon(class_1299<?> entityType) {
        List<class_1792> weapons = VoidbornConstants.possibleWeapons.get(entityType);
        if (weapons == null || weapons.isEmpty()) {
            return class_1802.field_8162;
        }
        return weapons.get((int)(Math.random() * (double)weapons.size()));
    }

    public static void fillChestWithItems(class_3218 serverLevel, class_2586 blockEntity, class_2338 blockPos, class_2680 blockState, class_2378<class_1887> enchantmentRegistry) {
        if (blockEntity instanceof class_2595) {
            class_1792[] weaponItems;
            class_1792[] armorItems;
            class_2595 chestBlockEntity = (class_2595)blockEntity;
            class_9323.class_9324 dataComponentMapBuilder = class_9323.method_57827();
            dataComponentMapBuilder.method_57840(class_9334.field_49631, (Object)class_2561.method_43471((String)"voidvanguards.voidborn.chest.title"));
            chestBlockEntity.method_58684(dataComponentMapBuilder.method_57838());
            int chestSize = chestBlockEntity.method_5439();
            ArrayList<Integer> chestSlotRange = new ArrayList<Integer>(IntStream.range(0, chestSize).boxed().toList());
            Collections.shuffle(chestSlotRange);
            int slotIndex = 0;
            class_6880 protectionEnchantmentHolder = enchantmentRegistry.method_47983((Object)((class_1887)enchantmentRegistry.method_29107(class_1893.field_9111)));
            class_6880 sharpnessEnchantmentHolder = enchantmentRegistry.method_47983((Object)((class_1887)enchantmentRegistry.method_29107(class_1893.field_9118)));
            for (class_1792 armor : armorItems = new class_1792[]{class_1802.field_8743, class_1802.field_8523, class_1802.field_8396, class_1802.field_8660}) {
                if (slotIndex >= chestSlotRange.size()) break;
                class_1799 armourStack = new class_1799((class_1935)armor);
                armourStack.method_7978(protectionEnchantmentHolder, 1);
                chestBlockEntity.method_5447(((Integer)chestSlotRange.get(slotIndex++)).intValue(), armourStack);
            }
            for (class_1792 weapon : weaponItems = new class_1792[]{class_1802.field_8371, class_1802.field_8475}) {
                if (slotIndex >= chestSlotRange.size()) break;
                class_1799 weaponStack = new class_1799((class_1935)weapon);
                weaponStack.method_7978(sharpnessEnchantmentHolder, 1);
                chestBlockEntity.method_5447(((Integer)chestSlotRange.get(slotIndex++)).intValue(), weaponStack);
            }
            if (slotIndex < chestSlotRange.size()) {
                chestBlockEntity.method_5447(((Integer)chestSlotRange.get(slotIndex++)).intValue(), new class_1799((class_1935)class_1802.field_8255));
            }
            class_1792[] foodItems = new class_1792[]{class_1802.field_8229, class_1802.field_8544, class_1802.field_8176};
            class_5819 random = serverLevel.field_9229;
            while (slotIndex < chestSlotRange.size()) {
                class_1792 randomFood = foodItems[random.method_43048(foodItems.length)];
                int count = 1 + random.method_43048(4);
                chestBlockEntity.method_5447(((Integer)chestSlotRange.get(slotIndex++)).intValue(), new class_1799((class_1935)randomFood, count));
            }
            chestBlockEntity.method_5431();
            serverLevel.method_8413(blockPos, blockState, blockState, 3);
        }
    }

    public static class_2338 getVoidbornBaseSpawnPos(class_3222 serverPlayer) {
        return VoidbornUtil.getVoidbornBaseSpawnPos(serverPlayer, CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.method_5667(), CosmosLocation.VOIDBORN_BASE));
    }

    public static class_2338 getVoidbornBaseSpawnPos(class_3222 serverPlayer, class_2338 voidbornCosmosBasePos) {
        return voidbornCosmosBasePos.method_10069(15, 0, 0);
    }

    public static class_2338 getTeleportBackButtonPosition(class_3222 serverPlayer) {
        return VoidbornUtil.getTeleportBackButtonPosition(serverPlayer, CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.method_5667(), CosmosLocation.VOIDBORN_BASE));
    }

    public static class_2338 getTeleportBackButtonPosition(class_3222 serverPlayer, class_2338 voidbornCosmosBasePos) {
        return VoidbornUtil.getVoidbornBaseSpawnPos(serverPlayer, voidbornCosmosBasePos).method_10069(3, 1, 0);
    }

    public static boolean isBlockPosTeleportBackButtonPosition(class_3222 serverPlayer, class_2338 blockPos) {
        return blockPos.equals((Object)VoidbornUtil.getTeleportBackButtonPosition(serverPlayer));
    }

    public static class_2338 getRadarLeverPosition(class_3222 serverPlayer) {
        return CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.method_5667(), CosmosLocation.VOIDBORN_BASE).method_10069(-28, 8, -37);
    }

    public static boolean isBlockPosRadarLeverPosition(class_3222 serverPlayer, class_2338 blockPos) {
        return blockPos.equals((Object)VoidbornUtil.getRadarLeverPosition(serverPlayer));
    }

    public static List<class_2338> getRadarEndRodPositions(class_3222 serverPlayer) {
        class_2338 middlePos = CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.method_5667(), CosmosLocation.VOIDBORN_BASE).method_10069(-26, 12, -37);
        return Arrays.asList(middlePos.method_10069(0, 1, 0), middlePos.method_10069(-1, 0, -1), middlePos.method_10069(-1, 0, 1), middlePos.method_10069(1, 0, -1), middlePos.method_10069(1, 0, 1));
    }

    public static void spawnLightningAtRadarEndRods(class_3222 serverPlayer) {
        MinecraftServer minecraftServer = serverPlayer.method_5682();
        for (int delay = 0; delay <= 50; delay += 10) {
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                for (class_2338 endRodPos : VoidbornUtil.getRadarEndRodPositions(serverPlayer)) {
                    Util.spawnLightning(serverPlayer.method_51469(), endRodPos, serverPlayer);
                }
            }, (int)delay);
        }
    }

    public static boolean shouldMakeAmbientSound(class_1937 level) {
        return level.field_9229.method_43048(5) == 0;
    }
}

