/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_fabric.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.implementations.networking.api.Dispatcher;
import com.natamus.voidvanguards_common_fabric.data.ClientSaveData;
import com.natamus.voidvanguards_common_fabric.data.Constants;
import com.natamus.voidvanguards_common_fabric.data.ServerSaveData;
import com.natamus.voidvanguards_common_fabric.networking.packets.ToClientSyncSaveDataPacket;
import com.natamus.voidvanguards_common_fabric.parts.skyship.data.SkyShipVariables;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class SaveLoadUtils {
    public static String savePlayerData(class_1657 player) {
        String newTag = SaveLoadUtils.getPlayerDataTag(player);
        SaveLoadUtils.removeOldSaveTag(player);
        player.method_5780(newTag);
        return newTag;
    }

    public static void loadPlayerData(class_1657 player) {
        if (player.method_37908().method_8608()) {
            return;
        }
        String saveDataTag = "";
        Set tags = player.method_5752();
        for (String tag : tags) {
            if (!tag.startsWith(Constants.saveDataTagPrefix)) continue;
            saveDataTag = tag;
            break;
        }
        if (saveDataTag.isEmpty()) {
            saveDataTag = SaveLoadUtils.savePlayerData(player);
        } else if (!SaveLoadUtils.saveDataTagUUIDMatches(player, saveDataTag)) {
            ServerSaveData.removeUUID(player.method_5667());
            saveDataTag = SaveLoadUtils.savePlayerData(player);
        }
        class_3222 serverPlayer = (class_3222)player;
        SaveLoadUtils.serverSyncPlayerData(serverPlayer, saveDataTag);
        Dispatcher.sendToClient((Object)new ToClientSyncSaveDataPacket(saveDataTag), (class_3222)serverPlayer);
    }

    public static void serverSyncPlayerData(class_3222 serverPlayer, String saveDataTag) {
        UUID playerUUID = serverPlayer.method_5667();
        class_3218 serverLevel = serverPlayer.method_51469();
        class_2378 levelRegistry = serverLevel.method_30349().method_30530(class_7924.field_41223);
        block32: for (String saveData : saveDataTag.split("--")) {
            if (!saveData.contains("..")) continue;
            String[] keyValue = saveData.split(Pattern.quote(".."));
            switch (keyValue[0]) {
                case "skyShipTriggered": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().skyShipTriggeredPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().skyShipTriggeredPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().skyShipTriggeredPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().skyShipTriggeredPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "vanguardStationGenerated": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "answeredRadio": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().answeredRadioPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().answeredRadioPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().answeredRadioPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().answeredRadioPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "voidbornGateGenerated": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "cosmosVoidbornBaseGenerated": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "triggeredVoidbornBaseStory": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().triggeredVoidbornBaseStoryPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().triggeredVoidbornBaseStoryPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().triggeredVoidbornBaseStoryPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().triggeredVoidbornBaseStoryPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "triggeredVoidbornLeader": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "gaveVoidbornLeaderRadio": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "sabotagedVoidbornRadar": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "voidVanguardsCompleted": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "originalPlayerPosition": {
                    int z;
                    int y;
                    int x;
                    String[] rawOriginalPosition = keyValue[1].split("__");
                    String rawOriginalLevelResourceKey = rawOriginalPosition[0];
                    String[] rawOriginalCoordinates = rawOriginalPosition[1].split("_");
                    class_2960 originalLevelResourceLocation = class_2960.method_60654((String)rawOriginalLevelResourceKey.replace("+", ":"));
                    class_5321 originalLevelResourceKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)originalLevelResourceLocation);
                    class_3218 originalLevel = serverLevel.method_8503().method_3847(originalLevelResourceKey);
                    if (originalLevel == null) continue block32;
                    try {
                        x = Integer.parseInt(rawOriginalCoordinates[0]);
                        y = Integer.parseInt(rawOriginalCoordinates[1]);
                        z = Integer.parseInt(rawOriginalCoordinates[2]);
                    }
                    catch (NumberFormatException ex) {
                        System.out.println(" !! NumberFormatException for: " + rawOriginalPosition[1]);
                        continue block32;
                    }
                    class_2338 originalPos = new class_2338(x, y, z);
                    ServerSaveData.get().originalPlayerPositions.put(playerUUID, (Pair<class_5321<class_1937>, class_2338>)Pair.of((Object)originalLevel.method_27983(), (Object)originalPos));
                    continue block32;
                }
                case "enemyCosmosGatePosition": {
                    int z;
                    int y;
                    int x;
                    String[] rawVoidbornBasePosition = keyValue[1].split("__");
                    String rawVoidbornBaseLevelResourceKey = rawVoidbornBasePosition[0];
                    String[] rawVoidbornBaseCoordinates = rawVoidbornBasePosition[1].split("_");
                    class_2960 voidbornBaseLevelResourceLocation = class_2960.method_60654((String)rawVoidbornBaseLevelResourceKey.replace("+", ":"));
                    class_5321 voidbornBaseLevelResourceKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)voidbornBaseLevelResourceLocation);
                    class_3218 voidbornBaseLevel = serverLevel.method_8503().method_3847(voidbornBaseLevelResourceKey);
                    if (voidbornBaseLevel == null) continue block32;
                    try {
                        x = Integer.parseInt(rawVoidbornBaseCoordinates[0]);
                        y = Integer.parseInt(rawVoidbornBaseCoordinates[1]);
                        z = Integer.parseInt(rawVoidbornBaseCoordinates[2]);
                    }
                    catch (NumberFormatException ex) {
                        continue block32;
                    }
                    class_2338 voidbornBasePos = new class_2338(x, y, z);
                    ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.put(playerUUID, (Pair<class_5321<class_1937>, class_2338>)Pair.of((Object)voidbornBaseLevel.method_27983(), (Object)voidbornBasePos));
                    continue block32;
                }
            }
        }
    }

    public static void clientSyncPlayerData(String saveDataTag) {
        block8: for (String saveData : saveDataTag.split("--")) {
            if (!saveData.contains("..")) continue;
            String[] keyValue = saveData.split(Pattern.quote(".."));
            switch (keyValue[0]) {
                case "skyShipTriggered": {
                    if (!keyValue[1].equals("true")) continue block8;
                    SkyShipVariables.triggeredSkyShipEvent = true;
                    continue block8;
                }
                case "voidVanguardsCompleted": {
                    if (!keyValue[1].equals("true")) continue block8;
                    ClientSaveData.voidVanguardsCompleted = true;
                    continue block8;
                }
            }
        }
    }

    public static String getPlayerDataTag(class_1657 player) {
        Pair<class_5321<class_1937>, class_2338> voidbornCosmosGateCoordinatePair;
        UUID playerUUID = player.method_5667();
        Object dataTag = Constants.saveDataTagPrefix;
        dataTag = (String)dataTag + "--playerUUID.." + String.valueOf(playerUUID);
        dataTag = (String)dataTag + "--skyShipTriggered.." + ServerSaveData.get().skyShipTriggeredPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--vanguardStationGenerated.." + ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--answeredRadio.." + ServerSaveData.get().answeredRadioPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--voidbornGateGenerated.." + ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--cosmosVoidbornBaseGenerated.." + ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--triggeredVoidbornBaseStory.." + ServerSaveData.get().triggeredVoidbornBaseStoryPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--triggeredVoidbornLeader.." + ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--gaveVoidbornLeaderRadio.." + ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--sabotagedVoidbornRadar.." + ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--voidVanguardsCompleted.." + ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.contains(playerUUID);
        Pair<class_5321<class_1937>, class_2338> originalPositionPair = ServerSaveData.get().originalPlayerPositions.get(playerUUID);
        if (originalPositionPair != null) {
            class_2338 originalPositionPos = (class_2338)originalPositionPair.getSecond();
            dataTag = (String)dataTag + "--originalPlayerPosition.." + ((class_5321)originalPositionPair.getFirst()).method_29177().toString().replace(":", "+") + "__" + originalPositionPos.method_10263() + "_" + originalPositionPos.method_10264() + "_" + originalPositionPos.method_10260();
        }
        if ((voidbornCosmosGateCoordinatePair = ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.get(playerUUID)) != null) {
            class_2338 voidbornCosmosGateCoordinatePos = (class_2338)voidbornCosmosGateCoordinatePair.getSecond();
            dataTag = (String)dataTag + "--enemyCosmosGatePosition.." + ((class_5321)voidbornCosmosGateCoordinatePair.getFirst()).method_29177().toString().replace(":", "+") + "__" + voidbornCosmosGateCoordinatePos.method_10263() + "_" + voidbornCosmosGateCoordinatePos.method_10264() + "_" + voidbornCosmosGateCoordinatePos.method_10260();
        }
        return dataTag;
    }

    public static void removeOldSaveTag(class_1657 player) {
        ArrayList<String> tagsToRemove = new ArrayList<String>();
        Set tags = player.method_5752();
        for (String tag : tags) {
            if (!tag.startsWith(Constants.saveDataTagPrefix)) continue;
            tagsToRemove.add(tag);
        }
        for (String tag : tagsToRemove) {
            player.method_5752().remove(tag);
        }
    }

    private static boolean saveDataTagUUIDMatches(class_1657 player, String saveDataTag) {
        for (String saveData : saveDataTag.split("--")) {
            String[] keyValue;
            if (!saveData.contains("..") || !(keyValue = saveData.split(Pattern.quote("..")))[0].equals("playerUUID")) continue;
            return keyValue[1].equals(player.method_5667().toString());
        }
        return false;
    }

    public static void setForcedPositionTag(class_3222 serverPlayer, int maxRadius) {
        SaveLoadUtils.setForcedPositionTag(serverPlayer, maxRadius, serverPlayer.method_24515());
    }

    public static void setForcedPositionTag(class_3222 serverPlayer, int maxRadius, class_2338 middlePos) {
        String forcedPositionTag = "voidvanguards.forceposition--forcedPlayerPosition.." + middlePos.method_10263() + "_" + middlePos.method_10264() + "_" + middlePos.method_10260() + "--radius.." + maxRadius;
        SaveLoadUtils.removeForcedPositionTag(serverPlayer);
        serverPlayer.method_5752().add(forcedPositionTag);
    }

    public static void removeForcedPositionTag(class_3222 serverPlayer) {
        ArrayList<String> tagsToRemove = new ArrayList<String>();
        Set tags = serverPlayer.method_5752();
        for (String tag : tags) {
            if (!tag.startsWith("voidvanguards.forceposition")) continue;
            tagsToRemove.add(tag);
        }
        for (String tag : tagsToRemove) {
            serverPlayer.method_5752().remove(tag);
        }
    }
}

