/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_fabric.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.TaskFunctions;
import com.natamus.collective_common_fabric.services.Services;
import com.natamus.voidvanguards_common_fabric.data.ServerSaveData;
import com.natamus.voidvanguards_common_fabric.registry.objects.CosmosDimensions;
import com.natamus.voidvanguards_common_fabric.util.SaveLoadUtils;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class Util {
    public static class_3218 getCosmosLevel(MinecraftServer minecraftServer) {
        return minecraftServer.method_3847(CosmosDimensions.COSMOS_LEVEL);
    }

    public static boolean isCosmosDimension(class_3218 serverLevel) {
        return serverLevel.equals(Util.getCosmosLevel(serverLevel.method_8503()));
    }

    public static boolean isInCosmosDimension(class_3222 serverPlayer) {
        return Util.isCosmosDimension(serverPlayer.method_51469());
    }

    public static boolean teleportPlayerToOriginalPosition(class_3222 serverPlayer) {
        if (!Util.isInCosmosDimension(serverPlayer)) {
            return false;
        }
        UUID playerUUID = serverPlayer.method_5667();
        if (!ServerSaveData.get().originalPlayerPositions.containsKey(playerUUID)) {
            SaveLoadUtils.loadPlayerData((class_1657)serverPlayer);
            if (!ServerSaveData.get().originalPlayerPositions.containsKey(playerUUID)) {
                return false;
            }
        }
        Pair<class_5321<class_1937>, class_2338> originalPositionPair = ServerSaveData.get().originalPlayerPositions.get(playerUUID);
        Services.TELEPORT.teleportEntity((class_1297)serverPlayer, (class_5321)originalPositionPair.getFirst(), (class_2338)originalPositionPair.getSecond());
        return true;
    }

    public static class_2338 getRANDOMVoidbornCosmosGateCoordinates(class_3218 serverLevel, class_3222 serverPlayer) {
        return BlockPosFunctions.getRandomCoordinatesInNearestUngeneratedChunk((class_3218)serverLevel, (class_2338)serverPlayer.method_24515());
    }

    public static void addSendMessageTag(class_3222 serverPlayer, String message) {
        serverPlayer.method_5752().add("voidvanguards.sendmessage--" + message);
    }

    public static void removeTag(class_3222 serverPlayer, String tag) {
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverPlayer.method_5682(), () -> serverPlayer.method_5752().remove(tag), (int)0);
    }

    public static void removeTag(MinecraftServer minecraftServer, class_1297 entity, String tag) {
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> entity.method_5752().remove(tag), (int)0);
    }

    public static void spawnLightning(class_3218 serverLevel, class_2338 lightningPos, @Nullable class_3222 serverPlayer) {
        class_1538 lightningbolt = (class_1538)class_1299.field_6112.method_5883((class_1937)serverLevel);
        lightningbolt.method_29495(class_243.method_24955((class_2382)lightningPos));
        serverLevel.method_8649((class_1297)lightningbolt);
        if (serverPlayer != null) {
            serverPlayer.method_5783(class_3417.field_14865, 5.0f, 1.0f);
        }
    }

    public static InputStream getSchematicsInputStream(MinecraftServer minecraftServer, String schematicName) {
        return Util.getSchematicsInputStream(minecraftServer, schematicName, ".schem");
    }

    public static InputStream getSchematicsInputStream(MinecraftServer minecraftServer, String schematicName, String fileExtension) {
        try {
            Optional resourceOptional = minecraftServer.method_34864().method_14486(class_2960.method_60654((String)("voidvanguards:schematics/" + schematicName + fileExtension)));
            if (resourceOptional.isPresent()) {
                class_3298 resource = (class_3298)resourceOptional.get();
                return resource.method_14482();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String getCurrentDateString() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy - MM - dd"));
    }

    public static String getCurrentYearString() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy"));
    }
}

