/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_forge.data;

import com.mojang.authlib.GameProfile;
import com.natamus.collective_common_forge.functions.HeadFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class HeadData {
    private static final Map<String, ItemStack> tempMap = new HashMap<String, ItemStack>();
    public static Map<String, ItemStack> headMap = Collections.emptyMap();

    public static void generateHeadData() {
        for (HeadType type : HeadType.values()) {
            type.generate();
            tempMap.put(type.name, type.headStack);
        }
        headMap = Collections.unmodifiableMap(tempMap);
    }

    public static ItemStack getGeneratedHead(String name) {
        return headMap.get(name).copy();
    }

    public static ItemStack getGeneratedHead(HeadType headType) {
        return headType.headStack.copy();
    }

    @Nullable
    public static GameProfile getHeadGameProfile(String name) {
        for (HeadType type : HeadType.values()) {
            if (!type.name.equals(name)) continue;
            return HeadFunctions.getTexturedHeadGameProfile((String)name, (String)type.texture, (String)type.uuid);
        }
        return null;
    }

    @Nullable
    public static GameProfile getHeadGameProfile(HeadType headType) {
        return HeadFunctions.getTexturedHeadGameProfile((String)headType.name, (String)headType.texture, (String)headType.uuid);
    }

    public static enum HeadType {
        VANGUARD("vanguard_helmet", "1dcdacdf-8419-4b2c-84ed-9faf9742f650", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGJmMWJlZmRmMTUyZGJiNzY4YTE1OTMxNWE5Y2YzYTM4YzFjYTk0ZWJhZTVkY2U4YmNiMDVhNDFkNWRjM2U4ZiJ9fX0="),
        VANGUARD_LEADER("vanguard_leader_helmet", "ba002e9d-0f53-4cb4-8583-be839c0c8353", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzAyYTI4YmYwMzU4MGQ3MzcxZjFiOWM4YzYzMTQwMmE5NGI1OGZkMWJiZDIyNmQxMjk5NWNiYTc5MTIwM2FjIn19fQ=="),
        VOIDBORN("voidborn_helmet", "dc0d2b70-8165-4fc6-975d-99456d2162dd", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2U3ZWI0OWI1OGQyNzUyYzBiZWI4NzBkOGE3OTdlMTVhNzU1MzMwMWZkOGY4NWZmMjNlYTU0N2QyYTNmYjk2NSJ9fX0="),
        VOIDBORN_LEADER("voidborn_leader_helmet", "dc0d2b70-8165-4fc6-975d-99456d2162dd", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjg2NmFjOTM5MmMxODc2MWYzZDhkZDhkZTBkMGZmYmVkZTk3ZDdlYTcwMjg2NjRlMDdkNmI3M2RlNGU0NDdjZSJ9fX0=");

        public final String name;
        public final String uuid;
        public final String texture;
        public ItemStack headStack;

        private HeadType(String name, String uuid, String texture) {
            this.name = name;
            this.uuid = uuid;
            this.texture = texture;
        }

        public void generate() {
            this.headStack = HeadFunctions.getNewTexturedHead((String)this.name, (String)this.texture, (String)this.uuid, (String)"", (Integer)1);
            this.headStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)StringFunctions.capitalizeEveryWord((String)this.name.replace("_", " "))));
        }
    }
}

