/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_forge.mixin;

import com.natamus.collective_common_forge.functions.TaskFunctions;
import com.natamus.voidvanguards_common_forge.data.HeadData;
import com.natamus.voidvanguards_common_forge.parts.voidborn.data.VoidbornConstants;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class}, priority=1001)
public class MobMixin {
    @Inject(method={"dropCustomDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;Z)V"}, at={@At(value="HEAD")})
    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean b, CallbackInfo ci) {
        Mob mob = (Mob)this;
        if (!mob.getTags().contains("voidvanguards.voidborn")) {
            return;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.getServer(), () -> {
            serverLevel.getEntitiesOfClass(ItemEntity.class, mob.getBoundingBox().inflate(3.0), itemEntity -> true).forEach(itemEntity -> {
                if (VoidbornConstants.possibleIllagerDrops.contains(itemEntity.getItem().getItem())) {
                    itemEntity.discard();
                }
            });
            ItemStack voidbornHeadStack = HeadData.getGeneratedHead(HeadData.HeadType.VOIDBORN);
            serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, mob.getX(), mob.getY(), mob.getZ(), voidbornHeadStack));
        }, (int)0);
    }

    @Inject(method={"getTarget()Lnet/minecraft/world/entity/LivingEntity;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getTarget(CallbackInfoReturnable<LivingEntity> cir) {
        if (((Mob)this).getTags().contains("voidvanguards.notarget")) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getTargetFromBrain()Lnet/minecraft/world/entity/LivingEntity;"}, at={@At(value="HEAD")}, cancellable=true)
    protected final void getTargetFromBrain(CallbackInfoReturnable<LivingEntity> cir) {
        if (((Mob)this).getTags().contains("voidvanguards.notarget")) {
            cir.setReturnValue(null);
        }
    }
}

