/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_forge.parts.skyship.functions;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.natamus.voidvanguards_common_forge.data.ClientConstants;
import com.natamus.voidvanguards_common_forge.parts.skyship.data.SkyShipColours;
import com.natamus.voidvanguards_common_forge.parts.skyship.data.SkyShipPatterns;
import com.natamus.voidvanguards_common_forge.parts.skyship.data.SkyShipVariables;
import com.natamus.voidvanguards_common_forge.parts.skyship.util.SkyShipUtil;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;

public class SkyShipRenderFunctions {
    public static void renderOrbitingShip(Matrix4f matrix) {
        if (ClientConstants.mc.level == null) {
            return;
        }
        if (!SkyShipVariables.skyShipVisible) {
            return;
        }
        long time = ClientConstants.mc.level.getGameTime();
        float partialTicks = ClientConstants.mc.getFrameTimeNs();
        float sunAngle = SkyShipUtil.getShipSunAngle(ClientConstants.mc, partialTicks);
        Vector3f sunPos = new Vector3f((float)Math.sin(sunAngle), (float)Math.cos(sunAngle), 0.0f).normalize();
        float orbitAngle = (float)time * 0.001f;
        Vector3f offset = new Vector3f((float)Math.cos(orbitAngle) * 15.0f, (float)Math.sin(orbitAngle) * 15.0f, 90.0f);
        Quaternionf rotToSun = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)sunPos);
        offset.rotate((Quaternionfc)rotToSun);
        Vector3f skyShipPos = new Vector3f((Vector3fc)sunPos).mul(100.0f).add((Vector3fc)offset);
        if (SkyShipVariables.triggeredSkyShipEvent) {
            long explosionAge;
            if (SkyShipVariables.explosionStartTime == 0L) {
                SkyShipVariables.explosionStartTime = time;
            }
            if ((explosionAge = time - SkyShipVariables.explosionStartTime) < (long)SkyShipVariables.ticksNeededSkyShipExplosion) {
                int frameDuration = SkyShipVariables.ticksNeededSkyShipExplosion / 4;
                int explosionFrame = explosionAge < (long)frameDuration ? 6 : (explosionAge < (long)(frameDuration * 2) ? 7 : (explosionAge < (long)(frameDuration * 3) ? 8 : 9));
                SkyShipRenderFunctions.renderExplosionFrame(matrix, time, skyShipPos, offset, explosionFrame);
                return;
            }
            SkyShipVariables.skyShipVisible = false;
            SkyShipVariables.explosionStartTime = 0L;
            return;
        }
        SkyShipRenderFunctions.renderNormalShip(matrix, time, skyShipPos, offset);
    }

    private static void renderNormalShip(Matrix4f matrix, long time, Vector3f skyShipPos, Vector3f offset) {
        float flicker = 0.9f + 0.1f * (float)Math.sin((float)time * 0.001f);
        int detailLevel = Math.min(Math.max(SkyShipVariables.skyShipDetailLevel, 0), SkyShipPatterns.SHIP_PATTERNS.length - 1);
        int[][] shipPattern = SkyShipPatterns.SHIP_PATTERNS[detailLevel];
        int[][] shipColors = SkyShipColours.SHIP_COLORS[detailLevel];
        int rows = shipPattern.length;
        int cols = shipPattern[0].length;
        float basePixelSize = 0.006f * flicker;
        float pixelWidth = basePixelSize / ((float)cols / 3.0f);
        float pixelHeight = basePixelSize / ((float)rows / 8.0f);
        skyShipPos.y += 0.1f * (float)Math.sin((double)time * 0.08);
        Vector3f elong = new Vector3f((Vector3fc)offset).normalize().mul(0.02f * flicker);
        skyShipPos.add((Vector3fc)elong);
        Quaternionf faceCamera = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)skyShipPos.normalize());
        boolean depthTestEnabled = GL11.glIsEnabled((int)2929);
        boolean depthMaskEnabled = GL11.glGetBoolean((int)2930);
        if (!depthTestEnabled) {
            // empty if block
        }
        if (!depthMaskEnabled) {
            RenderSystem.depthMask((boolean)true);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buffer = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                int colorIndex = shipPattern[y][x];
                if (colorIndex == 0) continue;
                int[] col = shipColors[Math.min(colorIndex - 1, shipColors.length - 1)];
                int pxR = col[0];
                int pxG = col[1];
                int pxB = col[2];
                int pxA = 255;
                float pxX = ((float)x - (float)cols / 2.0f) * pixelWidth;
                float pxY = ((float)rows / 2.0f - (float)y) * pixelHeight;
                Vector3f v1 = new Vector3f(pxX + pixelWidth, pxY - pixelHeight, 0.0f).rotate((Quaternionfc)faceCamera);
                Vector3f v2 = new Vector3f(pxX + pixelWidth, pxY + pixelHeight, 0.0f).rotate((Quaternionfc)faceCamera);
                Vector3f v3 = new Vector3f(pxX - pixelWidth, pxY + pixelHeight, 0.0f).rotate((Quaternionfc)faceCamera);
                Vector3f v4 = new Vector3f(pxX - pixelWidth, pxY - pixelHeight, 0.0f).rotate((Quaternionfc)faceCamera);
                buffer.addVertex(matrix, skyShipPos.x + v1.x, skyShipPos.y + v1.y, skyShipPos.z + v1.z).setColor(pxR, pxG, pxB, pxA);
                buffer.addVertex(matrix, skyShipPos.x + v2.x, skyShipPos.y + v2.y, skyShipPos.z + v2.z).setColor(pxR, pxG, pxB, pxA);
                buffer.addVertex(matrix, skyShipPos.x + v3.x, skyShipPos.y + v3.y, skyShipPos.z + v3.z).setColor(pxR, pxG, pxB, pxA);
                buffer.addVertex(matrix, skyShipPos.x + v4.x, skyShipPos.y + v4.y, skyShipPos.z + v4.z).setColor(pxR, pxG, pxB, pxA);
            }
        }
        float haloSize = (pixelWidth + pixelHeight) * 0.5f * 0.3f;
        int[] haloColor = shipColors[1];
        for (int i = 0; i < 4; ++i) {
            double angle = (double)i * Math.PI / 2.0 + (double)time * 0.05;
            Vector3f haloOffset = new Vector3f((float)Math.cos(angle) * haloSize, (float)Math.sin(angle) * haloSize, 0.0f);
            haloOffset.rotate((Quaternionfc)faceCamera);
            buffer.addVertex(matrix, skyShipPos.x + haloOffset.x, skyShipPos.y + haloOffset.y, skyShipPos.z + haloOffset.z).setColor(haloColor[0], haloColor[1], haloColor[2], 60);
        }
        BufferUploader.drawWithShader((MeshData)buffer.build());
        RenderSystem.disableBlend();
        if (!depthTestEnabled) {
            // empty if block
        }
        if (!depthMaskEnabled) {
            RenderSystem.depthMask((boolean)false);
        }
    }

    private static void renderExplosionFrame(Matrix4f matrix, long time, Vector3f skyShipPos, Vector3f offset, int explosionFrame) {
        float basePixelSize = 0.009f;
        int[][] explosionPattern = SkyShipPatterns.EXPLOSION_PATTERNS[explosionFrame - 6];
        int[][] explosionColors = SkyShipColours.EXPLOSION_COLORS[explosionFrame - 6];
        int rows = explosionPattern.length;
        int cols = explosionPattern[0].length;
        float pixelWidth = basePixelSize / ((float)cols / 3.0f);
        float pixelHeight = basePixelSize / ((float)rows / 8.0f);
        skyShipPos.y += (float)Math.sin((double)time * 0.3) * 2.0f;
        skyShipPos.x += (float)Math.cos((double)time * 0.2) * 1.5f;
        Quaternionf faceCamera = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)skyShipPos.normalize());
        boolean depthTestEnabled = GL11.glIsEnabled((int)2929);
        boolean depthMaskEnabled = GL11.glGetBoolean((int)2930);
        if (!depthTestEnabled) {
            // empty if block
        }
        if (!depthMaskEnabled) {
            RenderSystem.depthMask((boolean)true);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buffer = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                int colorIndex = explosionPattern[y][x];
                if (colorIndex == 0) continue;
                int[] col = explosionColors[Math.min(colorIndex - 1, explosionColors.length - 1)];
                int pxR = col[0];
                int pxG = col[1];
                int pxB = col[2];
                int pxA = 255;
                float pxX = ((float)x - (float)cols / 2.0f) * pixelWidth;
                float pxY = ((float)rows / 2.0f - (float)y) * pixelHeight;
                Vector3f v1 = new Vector3f(pxX + pixelWidth, pxY - pixelHeight, 0.0f).rotate((Quaternionfc)faceCamera);
                Vector3f v2 = new Vector3f(pxX + pixelWidth, pxY + pixelHeight, 0.0f).rotate((Quaternionfc)faceCamera);
                Vector3f v3 = new Vector3f(pxX - pixelWidth, pxY + pixelHeight, 0.0f).rotate((Quaternionfc)faceCamera);
                Vector3f v4 = new Vector3f(pxX - pixelWidth, pxY - pixelHeight, 0.0f).rotate((Quaternionfc)faceCamera);
                buffer.addVertex(matrix, skyShipPos.x + v1.x, skyShipPos.y + v1.y, skyShipPos.z + v1.z).setColor(pxR, pxG, pxB, pxA);
                buffer.addVertex(matrix, skyShipPos.x + v2.x, skyShipPos.y + v2.y, skyShipPos.z + v2.z).setColor(pxR, pxG, pxB, pxA);
                buffer.addVertex(matrix, skyShipPos.x + v3.x, skyShipPos.y + v3.y, skyShipPos.z + v3.z).setColor(pxR, pxG, pxB, pxA);
                buffer.addVertex(matrix, skyShipPos.x + v4.x, skyShipPos.y + v4.y, skyShipPos.z + v4.z).setColor(pxR, pxG, pxB, pxA);
            }
        }
        BufferUploader.drawWithShader((MeshData)buffer.build());
        RenderSystem.disableBlend();
        if (!depthTestEnabled) {
            // empty if block
        }
        if (!depthMaskEnabled) {
            RenderSystem.depthMask((boolean)false);
        }
    }
}

