/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_forge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.TaskFunctions;
import com.natamus.collective_common_forge.services.Services;
import com.natamus.voidvanguards_common_forge.data.ServerSaveData;
import com.natamus.voidvanguards_common_forge.registry.objects.CosmosDimensions;
import com.natamus.voidvanguards_common_forge.util.SaveLoadUtils;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static ServerLevel getCosmosLevel(MinecraftServer minecraftServer) {
        return minecraftServer.getLevel(CosmosDimensions.COSMOS_LEVEL);
    }

    public static boolean isCosmosDimension(ServerLevel serverLevel) {
        return serverLevel.equals(Util.getCosmosLevel(serverLevel.getServer()));
    }

    public static boolean isInCosmosDimension(ServerPlayer serverPlayer) {
        return Util.isCosmosDimension(serverPlayer.serverLevel());
    }

    public static boolean teleportPlayerToOriginalPosition(ServerPlayer serverPlayer) {
        if (!Util.isInCosmosDimension(serverPlayer)) {
            return false;
        }
        UUID playerUUID = serverPlayer.getUUID();
        if (!ServerSaveData.get().originalPlayerPositions.containsKey(playerUUID)) {
            SaveLoadUtils.loadPlayerData((Player)serverPlayer);
            if (!ServerSaveData.get().originalPlayerPositions.containsKey(playerUUID)) {
                return false;
            }
        }
        Pair<ResourceKey<Level>, BlockPos> originalPositionPair = ServerSaveData.get().originalPlayerPositions.get(playerUUID);
        Services.TELEPORT.teleportEntity((Entity)serverPlayer, (ResourceKey)originalPositionPair.getFirst(), (BlockPos)originalPositionPair.getSecond());
        return true;
    }

    public static BlockPos getRANDOMVoidbornCosmosGateCoordinates(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        return BlockPosFunctions.getRandomCoordinatesInNearestUngeneratedChunk((ServerLevel)serverLevel, (BlockPos)serverPlayer.blockPosition());
    }

    public static void addSendMessageTag(ServerPlayer serverPlayer, String message) {
        serverPlayer.getTags().add("voidvanguards.sendmessage--" + message);
    }

    public static void removeTag(ServerPlayer serverPlayer, String tag) {
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverPlayer.getServer(), () -> serverPlayer.getTags().remove(tag), (int)0);
    }

    public static void removeTag(MinecraftServer minecraftServer, Entity entity, String tag) {
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> entity.getTags().remove(tag), (int)0);
    }

    public static void spawnLightning(ServerLevel serverLevel, BlockPos lightningPos, @Nullable ServerPlayer serverPlayer) {
        LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverLevel);
        lightningbolt.moveTo(Vec3.atBottomCenterOf((Vec3i)lightningPos));
        serverLevel.addFreshEntity((Entity)lightningbolt);
        if (serverPlayer != null) {
            serverPlayer.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 5.0f, 1.0f);
        }
    }

    public static InputStream getSchematicsInputStream(MinecraftServer minecraftServer, String schematicName) {
        return Util.getSchematicsInputStream(minecraftServer, schematicName, ".schem");
    }

    public static InputStream getSchematicsInputStream(MinecraftServer minecraftServer, String schematicName, String fileExtension) {
        try {
            Optional resourceOptional = minecraftServer.getResourceManager().getResource(ResourceLocation.parse((String)("voidvanguards:schematics/" + schematicName + fileExtension)));
            if (resourceOptional.isPresent()) {
                Resource resource = (Resource)resourceOptional.get();
                return resource.open();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String getCurrentDateString() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy - MM - dd"));
    }

    public static String getCurrentYearString() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy"));
    }
}

