/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge;

import com.natamus.collective_common_neoforge.functions.CreativeModeTabFunctions;
import com.natamus.collective_common_neoforge.globalcallbacks.CollectiveGuiCallback;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.voidvanguards_common_neoforge.config.ConfigHandler;
import com.natamus.voidvanguards_common_neoforge.data.HeadData;
import com.natamus.voidvanguards_common_neoforge.events.VoidClientEvents;
import com.natamus.voidvanguards_common_neoforge.networking.PacketRegistration;
import com.natamus.voidvanguards_common_neoforge.registry.block.CosmosPortalBlock;
import com.natamus.voidvanguards_common_neoforge.registry.item.OrbitalRadioItem;
import com.natamus.voidvanguards_common_neoforge.registry.item.OrbitalTransponderItem;
import com.natamus.voidvanguards_common_neoforge.registry.objects.VanguardBlocks;
import com.natamus.voidvanguards_common_neoforge.registry.objects.VanguardItems;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class ModCommon {
    public static void init() {
        ConfigHandler.initConfig();
        ModCommon.registerPackets();
        ModCommon.load();
    }

    private static void load() {
        HeadData.generateHeadData();
        if (Services.MODLOADER.isClientSide()) {
            CollectiveGuiCallback.ON_GUI_RENDER.register((guiGraphics, deltaTracker) -> VoidClientEvents.renderOverlay(guiGraphics, deltaTracker));
        }
    }

    public static void registerPackets() {
        new PacketRegistration().init();
    }

    public static void registerAssets(Object modEventBusObject) {
        Services.REGISTERBLOCK.registerBlockWithoutItem(modEventBusObject, ResourceLocation.fromNamespaceAndPath((String)"voidvanguards", (String)"cosmos_portal"), () -> new CosmosPortalBlock(BlockBehaviour.Properties.of().noCollission().randomTicks().strength(-1.0f).sound(SoundType.GLASS).lightLevel($$0x -> 11).pushReaction(PushReaction.BLOCK).mapColor(MapColor.COLOR_CYAN)), true);
        Services.REGISTERITEM.registerItem(modEventBusObject, ResourceLocation.fromNamespaceAndPath((String)"voidvanguards", (String)"orbital_radio"), () -> new OrbitalRadioItem(new Item.Properties().component(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.voidvanguards.orbital_radio").withStyle(style -> style.withItalic(Boolean.valueOf(false)).withColor(0x55FFFF))).component(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"item.voidvanguards.orbital_radio.lore").withStyle(style -> style.withColor(0xAAAAAA).withItalic(Boolean.valueOf(true))), Component.translatable((String)"item.voidvanguards.orbital_radio.description").withStyle(style -> style.withColor(65535).withItalic(Boolean.valueOf(false))))))), CreativeModeTabFunctions.getCreativeModeTabResourceKey((String)"tools_and_utilities"), false);
        Services.REGISTERITEM.registerItem(modEventBusObject, ResourceLocation.fromNamespaceAndPath((String)"voidvanguards", (String)"orbital_transponder"), () -> new OrbitalTransponderItem(new Item.Properties().component(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.voidvanguards.orbital_transponder").withStyle(style -> style.withItalic(Boolean.valueOf(false)).withColor(0x55FFFF))).component(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"item.voidvanguards.orbital_transponder.lore").withStyle(style -> style.withColor(0xAAAAAA).withItalic(Boolean.valueOf(true))), Component.translatable((String)"item.voidvanguards.orbital_transponder.description").withStyle(style -> style.withColor(65535).withItalic(Boolean.valueOf(false))))))), CreativeModeTabFunctions.getCreativeModeTabResourceKey((String)"tools_and_utilities"), true);
    }

    public static void setAssets() {
        VanguardItems.ORBITAL_RADIO = (OrbitalRadioItem)Services.REGISTERITEM.getRegisteredItem(ResourceLocation.fromNamespaceAndPath((String)"voidvanguards", (String)"orbital_radio"));
        VanguardItems.ORBITAL_TRANSPONDER = (OrbitalTransponderItem)Services.REGISTERITEM.getRegisteredItem(ResourceLocation.fromNamespaceAndPath((String)"voidvanguards", (String)"orbital_transponder"));
        VanguardBlocks.COSMOS_PORTAL = (CosmosPortalBlock)Services.REGISTERBLOCK.getRegisteredBlockWithoutItem(ResourceLocation.fromNamespaceAndPath((String)"voidvanguards", (String)"cosmos_portal"));
    }
}

