/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.StringFunctions;
import com.natamus.voidvanguards_common_neoforge.data.HeadData;
import com.natamus.voidvanguards_common_neoforge.data.ServerSaveData;
import com.natamus.voidvanguards_common_neoforge.parts.cosmos.functions.CosmosDimensionFunctions;
import com.natamus.voidvanguards_common_neoforge.parts.skyship.functions.SkyShipFunctions;
import com.natamus.voidvanguards_common_neoforge.parts.vanguard.functions.VanguardFunctions;
import com.natamus.voidvanguards_common_neoforge.parts.voidborn.functions.VoidbornFunctions;
import com.natamus.voidvanguards_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CommandVoidVanguards {
    public static final SuggestionProvider<CommandSourceStack> headStackSuggestions = (context, builder) -> SharedSuggestionProvider.suggest(HeadData.headMap.keySet(), (SuggestionsBuilder)builder, value -> value, value -> Component.literal((String)value));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"voidvanguards").requires(iCommandSender -> iCommandSender.hasPermission(2))).then(Commands.literal((String)"reset").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            SkyShipFunctions.resetSkyShipVariables(true);
            MessageFunctions.sendMessage((CommandSourceStack)source, (MutableComponent)Component.translatable((String)"voidvanguards.message.skyship.reset").withStyle(ChatFormatting.DARK_GREEN));
            return 1;
        }))).then(Commands.literal((String)"return").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            ServerPlayer serverPlayer = source.getPlayer();
            if (!Util.isInCosmosDimension(serverPlayer)) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (MutableComponent)Component.literal((String)"You are not in the cosmos dimension.").withStyle(ChatFormatting.RED));
                return 1;
            }
            UUID playerUUID = serverPlayer.getUUID();
            if (!ServerSaveData.get().originalPlayerPositions.containsKey(playerUUID)) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (MutableComponent)Component.literal((String)"Original location is not in save data.").withStyle(ChatFormatting.RED));
                return 1;
            }
            if (Util.teleportPlayerToOriginalPosition(serverPlayer)) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (MutableComponent)Component.literal((String)"Returned to the original location.").withStyle(ChatFormatting.DARK_GREEN));
            } else {
                MessageFunctions.sendMessage((CommandSourceStack)source, (MutableComponent)Component.literal((String)"Unable to return player to original position.").withStyle(ChatFormatting.RED));
            }
            return 1;
        }))).then(Commands.literal((String)"radio").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            VanguardFunctions.generateRadioAtPlayerPosition(source.getPlayer());
            return 1;
        }))).then(Commands.literal((String)"generate").then(Commands.literal((String)"cosmos_gate").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            ServerPlayer serverPlayer = source.getPlayer();
            VoidbornFunctions.generateVoidbornCosmosGate(serverPlayer.serverLevel(), serverPlayer, serverPlayer.blockPosition().offset(5, 0, 5));
            MessageFunctions.sendMessage((Player)serverPlayer, (String)"Generated cosmos gate.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        })))).then(Commands.literal((String)"teleport").then(Commands.literal((String)"voidborn_base").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            ServerPlayer serverPlayer = source.getPlayer();
            CosmosDimensionFunctions.teleportPlayerToVoidbornBase(serverPlayer.serverLevel(), serverPlayer);
            MessageFunctions.sendMessage((Player)serverPlayer, (String)"Teleported to voidborn base.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        })))).then(Commands.literal((String)"tag").then(Commands.literal((String)"remove").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            ServerPlayer serverPlayer = source.getPlayer();
            for (String tag : serverPlayer.getTags()) {
                if (!tag.toLowerCase().startsWith("voidvanguards")) continue;
                Util.removeTag(serverPlayer, tag);
            }
            MessageFunctions.sendMessage((Player)serverPlayer, (String)"Removed all Void Vanguards tags.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        })))).then(Commands.literal((String)"head").then(Commands.literal((String)"list").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"You can generate the following heads:", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" Usage: /voidvanguards head <name> <amount>:", (ChatFormatting)ChatFormatting.DARK_GREEN);
            ArrayList<String> headNames = new ArrayList<String>(HeadData.headMap.keySet());
            Collections.sort(headNames);
            String mnstr = String.join((CharSequence)", ", headNames);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)mnstr, (ChatFormatting)ChatFormatting.YELLOW);
            return 1;
        })))).then(Commands.literal((String)"head").then(Commands.argument((String)"head-name", (ArgumentType)StringArgumentType.string()).suggests(headStackSuggestions).executes(command -> CommandVoidVanguards.headCommand((CommandContext<CommandSourceStack>)command, 1))))).then(Commands.literal((String)"head").then(Commands.argument((String)"head-name", (ArgumentType)StringArgumentType.string()).suggests(headStackSuggestions).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(command -> CommandVoidVanguards.headCommand((CommandContext<CommandSourceStack>)command, IntegerArgumentType.getInteger((CommandContext)command, (String)"amount")))))));
    }

    private static int headCommand(CommandContext<CommandSourceStack> command, int amount) {
        ServerPlayer player;
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        String headName = StringArgumentType.getString(command, (String)"head-name").toLowerCase();
        if (!HeadData.headMap.containsKey(headName)) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("The headName '" + headName + "' does not exist. You can get a list of all possible heads with:"), (ChatFormatting)ChatFormatting.RED);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" Usage: /voidvanguards head list", (ChatFormatting)ChatFormatting.RED);
            return 1;
        }
        try {
            player = source.getPlayerOrException();
        }
        catch (CommandSyntaxException ex) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
            return 1;
        }
        ItemStack headstack = HeadData.headMap.get(headName).copy();
        headstack.setCount(amount);
        if (!player.getInventory().add(headstack)) {
            player.drop(headstack, false);
        }
        String s = "";
        if (amount > 1) {
            s = "s";
        }
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Successfully generated " + amount + " " + StringFunctions.capitalizeFirst((String)headName.replace("_", " ")) + " head" + s + "."), (ChatFormatting)ChatFormatting.DARK_GREEN);
        return 1;
    }
}

