/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.voidvanguards_common_neoforge.data.ServerSaveData;
import com.natamus.voidvanguards_common_neoforge.parts.voidborn.functions.VoidbornFunctions;
import com.natamus.voidvanguards_common_neoforge.parts.voidborn.util.VoidbornUtil;
import com.natamus.voidvanguards_common_neoforge.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class VoidBlockEvents {
    public static boolean onBlockBreak(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (level.isClientSide()) {
            return true;
        }
        if (player.isCreative()) {
            return true;
        }
        if (!Util.isInCosmosDimension((ServerPlayer)player)) {
            return true;
        }
        return ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.contains(player.getUUID());
    }

    public static boolean onBlockPlace(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (level.isClientSide()) {
            return true;
        }
        if (!(livingEntity instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        if (serverPlayer.isCreative()) {
            return true;
        }
        if (!Util.isInCosmosDimension(serverPlayer)) {
            return true;
        }
        return ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.contains(serverPlayer.getUUID());
    }

    public static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!Util.isInCosmosDimension(serverPlayer)) {
            return InteractionResult.PASS;
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (block instanceof ButtonBlock) {
            if (!VoidbornUtil.isBlockPosTeleportBackButtonPosition(serverPlayer, blockPos)) {
                return InteractionResult.PASS;
            }
            ServerLevel overworldLevel = level.getServer().overworld();
            Pair<ResourceKey<Level>, BlockPos> cosmosGatePair = ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.get(serverPlayer.getUUID());
            BlockPos gatePos = cosmosGatePair == null ? Util.getRANDOMVoidbornCosmosGateCoordinates(overworldLevel, serverPlayer).east(3) : ((BlockPos)cosmosGatePair.getSecond()).east(3);
            Services.TELEPORT.teleportEntity((Entity)serverPlayer, overworldLevel, BlockPosFunctions.getSurfaceBlockPos((ServerLevel)overworldLevel, (int)gatePos.getX(), (int)gatePos.getZ()));
            MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"voidvanguards.message.voidborn.cosmos_gate.enterSuccess.again").withStyle(ChatFormatting.DARK_PURPLE), (boolean)true);
        } else if (block instanceof LeverBlock) {
            if (!VoidbornUtil.isBlockPosRadarLeverPosition(serverPlayer, blockPos)) {
                return InteractionResult.PASS;
            }
            if (ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.contains(serverPlayer.getUUID())) {
                MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"voidvanguards.message.voidborn.base.radarLever.flip.unable").withStyle(ChatFormatting.DARK_GRAY));
                return InteractionResult.FAIL;
            }
            VoidbornFunctions.voidbornRadarLeverWasTriggered(serverPlayer.serverLevel(), serverPlayer);
        }
        return InteractionResult.PASS;
    }
}

