/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import com.natamus.collective_common_neoforge.implementations.networking.api.Dispatcher;
import com.natamus.voidvanguards_common_neoforge.data.ServerSaveData;
import com.natamus.voidvanguards_common_neoforge.networking.packets.ToClientSkyShipEntersOrbitPacket;
import com.natamus.voidvanguards_common_neoforge.parts.story.functions.StoryFunctions;
import com.natamus.voidvanguards_common_neoforge.registry.item.OrbitalRadioItem;
import com.natamus.voidvanguards_common_neoforge.util.SaveLoadUtils;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class VoidEntityEvents {
    public static void onEntityJoin(Level level, Entity entity) {
    }

    public static void onEntityLeave(Level level, Entity entity) {
    }

    public static void onPlayerLogin(Level level, Player player) {
        if (level.isClientSide) {
            return;
        }
        SaveLoadUtils.loadPlayerData(player);
        UUID playerUUID = player.getUUID();
        if (ServerSaveData.get().skyShipTriggeredPlayerUUIDS.contains(playerUUID) || ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.contains(playerUUID)) {
            return;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)level.getServer(), () -> {
            if (!ServerSaveData.get().skyShipTriggeredPlayerUUIDS.contains(player.getUUID())) {
                Dispatcher.sendToClient((Object)new ToClientSkyShipEntersOrbitPacket(), (ServerPlayer)((ServerPlayer)player));
            }
        }, (int)0);
    }

    public static void onPlayerLogout(Level world, Player player) {
        SaveLoadUtils.savePlayerData(player);
    }

    public static void onItemPickup(Level level, Player player, ItemStack itemStack) {
        if (level.isClientSide) {
            return;
        }
        if (itemStack.getItem() instanceof OrbitalRadioItem) {
            UUID playerUUID = player.getUUID();
            if (!ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.contains(playerUUID)) {
                return;
            }
            if (ServerSaveData.get().answeredRadioPlayerUUIDS.contains(playerUUID)) {
                return;
            }
            MessageFunctions.sendMessage((Player)player, (MutableComponent)Component.translatable((String)"item.voidvanguards.orbital_radio.pickedup").withStyle(ChatFormatting.RED), (boolean)true);
        }
    }

    public static InteractionResult onEntityInteract(Player player, Level level, InteractionHand interactionHand, Entity target, EntityHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        ItemStack handStack = player.getItemInHand(interactionHand);
        Item handItem = handStack.getItem();
        if (!(handItem instanceof OrbitalRadioItem)) {
            return InteractionResult.PASS;
        }
        if (!(target instanceof Mob)) {
            return InteractionResult.PASS;
        }
        Set targetTags = target.getTags();
        if (!targetTags.contains("voidvanguards.voidborn_leader")) {
            return InteractionResult.PASS;
        }
        if (!targetTags.contains("voidvanguards.vulnerable")) {
            return InteractionResult.PASS;
        }
        StoryFunctions.processVoidbornLeaderGiveRadio((ServerLevel)level, (ServerPlayer)player, (Mob)target, handStack);
        return InteractionResult.SUCCESS;
    }
}

