/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.parts.cosmos.util;

import com.natamus.voidvanguards_common_neoforge.registry.identifier.CosmosLocation;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;

public class CosmosDimensionUtil {
    public static BlockPos getUniqueBlockPositionFromUUID(UUID uuid, CosmosLocation cosmosLocation) {
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        long mixed = most ^ least;
        int x = (int)((mixed & 0xFFFFFFFL) % 100000L);
        int z = (int)((mixed >> 28 & 0xFFFFFFFL) % 100000L);
        if (cosmosLocation.equals(CosmosLocation.VOIDBORN_BASE)) {
            x = -x;
            z = -z;
        }
        return new BlockPos(x, 100, z);
    }

    public static boolean playerIsInVanguardStation(ServerPlayer serverPlayer) {
        return CosmosDimensionUtil.getPlayerCosmosLocation(serverPlayer).equals(CosmosLocation.VANGUARD_STATION);
    }

    public static boolean playerIsInVoidbornBase(ServerPlayer serverPlayer) {
        return CosmosDimensionUtil.getPlayerCosmosLocation(serverPlayer).equals(CosmosLocation.VOIDBORN_BASE);
    }

    public static CosmosLocation getPlayerCosmosLocation(ServerPlayer serverPlayer) {
        return serverPlayer.getX() >= 0.0 && serverPlayer.getZ() >= 0.0 ? CosmosLocation.VANGUARD_STATION : CosmosLocation.VOIDBORN_BASE;
    }
}

