/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.parts.story.util;

import com.natamus.voidvanguards_common_neoforge.config.ConfigHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class StoryUtil {
    public static int getSentenceTickDelay(Component sentenceComponent) {
        if (ConfigHandler.devSettingInstantConversations) {
            return 1;
        }
        String text = sentenceComponent.getString().trim();
        if (text.isEmpty()) {
            return 40;
        }
        int wordCount = text.split("\\s+").length;
        int variableTicks = wordCount * 7;
        return Math.min(30 + variableTicks, 120);
    }

    public static MutableComponent getSpeakerComponent(String nameTranslateKey, ChatFormatting nameColour, boolean translateable) {
        MutableComponent nameComponent = Component.translatable((String)nameTranslateKey);
        if (!translateable) {
            nameComponent = Component.literal((String)nameTranslateKey);
        }
        return Component.literal((String)"<").withStyle(ChatFormatting.WHITE).append((Component)nameComponent.withStyle(nameColour).append((Component)Component.literal((String)"> ").withStyle(ChatFormatting.WHITE)));
    }

    public static ChatFormatting getMessageColour(String rawMessage, String pattern, ChatFormatting defaultColour, ChatFormatting specialColour) {
        if (rawMessage.startsWith(pattern) && rawMessage.endsWith(pattern)) {
            return specialColour;
        }
        return defaultColour;
    }
}

