/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.parts.vanguard.util;

import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import com.natamus.voidvanguards_common_neoforge.data.HeadData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;

public class VanguardUtil {
    public static List<LivingEntity> getVanguardsToSummon(Level level, int amount) {
        ArrayList<LivingEntity> vanguardsToSummon = new ArrayList<LivingEntity>();
        for (int i = 0; i < amount; ++i) {
            ItemStack headStack;
            Villager vanguardVillager = (Villager)EntityType.VILLAGER.create(level);
            vanguardVillager.setUUID(UUID.randomUUID());
            if (vanguardsToSummon.isEmpty()) {
                headStack = HeadData.getGeneratedHead(HeadData.HeadType.VANGUARD_LEADER);
                vanguardVillager.addTag("voidvanguards.vanguard_leader");
                vanguardVillager.setCustomName((Component)Component.translatable((String)"voidvanguards.vanguard.name.leader").withStyle(ChatFormatting.DARK_RED));
                vanguardVillager.setVillagerData(vanguardVillager.getVillagerData().setType(VillagerType.SAVANNA));
            } else {
                headStack = HeadData.getGeneratedHead(HeadData.HeadType.VANGUARD);
                vanguardVillager.addTag("voidvanguards.vanguard_recruit");
                vanguardVillager.setCustomName((Component)Component.translatable((String)"voidvanguards.vanguard.name.recruit"));
                vanguardVillager.setVillagerData(vanguardVillager.getVillagerData().setType(VillagerType.SNOW));
            }
            vanguardVillager.setItemSlot(EquipmentSlot.HEAD, headStack);
            EntityFunctions.getGoalSelector((Mob)vanguardVillager).removeAllGoals(goal -> true);
            EntityFunctions.getTargetSelector((Mob)vanguardVillager).removeAllGoals(goal -> true);
            vanguardVillager.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
            vanguardVillager.getTags().add("voidvanguards.vanguard");
            vanguardVillager.setPersistenceRequired();
            vanguardVillager.setCanPickUpLoot(false);
            vanguardsToSummon.add((LivingEntity)vanguardVillager);
        }
        return vanguardsToSummon;
    }

    public static List<BlockPos> getVanguardPositions(BlockPos middlePos, int amount) {
        ArrayList<BlockPos> positions;
        if (amount == 1) {
            positions = new ArrayList<BlockPos>(Arrays.asList(middlePos.north(4)));
        } else if (amount == 4) {
            positions = new ArrayList<BlockPos>(Arrays.asList(middlePos.north(4), middlePos.east(4), middlePos.south(4), middlePos.west(4)));
        } else if (amount == 8) {
            positions = new ArrayList<BlockPos>(Arrays.asList(middlePos.north(4), middlePos.north(3).east(3), middlePos.east(4), middlePos.south(3).east(3), middlePos.south(4), middlePos.south(3).west(3), middlePos.west(4), middlePos.north(3).west(3)));
        } else {
            return new ArrayList<BlockPos>();
        }
        return positions;
    }

    public static void spawnGenerationParticles(ServerLevel serverLevel, BlockPos blockPos) {
        for (BlockPos aroundPos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-1, -1, -1), (BlockPos)blockPos.offset(1, 1, 1))) {
            VanguardUtil.spawnParticles(serverLevel, aroundPos, ParticleTypes.END_ROD, 5);
        }
    }

    public static void spawnTeleportParticles(ServerLevel serverLevel, BlockPos blockPos) {
        VanguardUtil.spawnParticles(serverLevel, blockPos, ParticleTypes.DRAGON_BREATH, 15);
    }

    public static void spawnParticles(ServerLevel serverLevel, BlockPos blockPos, SimpleParticleType simpleParticleType, int amount) {
        double x = (double)blockPos.getX() + 0.5;
        double y = (double)blockPos.getY() + 0.5;
        double z = (double)blockPos.getZ() + 0.5;
        for (int j = 0; j < amount; ++j) {
            double offsetX = (serverLevel.random.nextDouble() - 0.5) * 2.0;
            double offsetY = serverLevel.random.nextDouble() * 1.5;
            double offsetZ = (serverLevel.random.nextDouble() - 0.5) * 2.0;
            serverLevel.sendParticles((ParticleOptions)simpleParticleType, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static List<BlockPos> getTorchLocations(BlockPos middlePos) {
        return new ArrayList<BlockPos>(Arrays.asList(middlePos.north(4).east(2), middlePos.north(4).west(2), middlePos.east(4).north(2), middlePos.east(4).south(2), middlePos.south(4).east(2), middlePos.south(4).west(2), middlePos.west(4).north(2), middlePos.west(4).south(2)));
    }

    public static void removeGrassBetweenVanguards(Level level, List<BlockPos> vanguardPositions) {
        if (vanguardPositions.isEmpty()) {
            return;
        }
        int minX = vanguardPositions.stream().mapToInt(Vec3i::getX).min().orElse(0);
        int maxX = vanguardPositions.stream().mapToInt(Vec3i::getX).max().orElse(0);
        int minZ = vanguardPositions.stream().mapToInt(Vec3i::getZ).min().orElse(0);
        int maxZ = vanguardPositions.stream().mapToInt(Vec3i::getZ).max().orElse(0);
        int y = vanguardPositions.get(0).getY();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                BlockPos pos = new BlockPos(x, y, z);
                BlockState state = level.getBlockState(pos);
                if (!state.is(Blocks.SHORT_GRASS) && !state.is(Blocks.TALL_GRASS)) continue;
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
    }

    public static void keepPlayersWithinVanguardCircle(ServerPlayer serverPlayer, String forcedTag) {
        int radius;
        int z;
        int y;
        int x;
        String rawPositionPart = forcedTag.substring(forcedTag.indexOf("forcedPlayerPosition..") + "forcedPlayerPosition..".length(), forcedTag.indexOf("--radius.."));
        String rawRadiusPart = forcedTag.substring(forcedTag.indexOf("--radius..") + "--radius..".length());
        String[] rawCoordinates = rawPositionPart.split("_");
        try {
            x = Integer.parseInt(rawCoordinates[0]);
            y = Integer.parseInt(rawCoordinates[1]);
            z = Integer.parseInt(rawCoordinates[2]);
            radius = Integer.parseInt(rawRadiusPart);
        }
        catch (NumberFormatException ex) {
            return;
        }
        BlockPos centerPos = new BlockPos(x, y, z);
        double dx = serverPlayer.getX() - (double)centerPos.getX();
        double dz = serverPlayer.getZ() - (double)centerPos.getZ();
        double distanceSquared = dx * dx + dz * dz;
        if (distanceSquared > (double)(radius * radius)) {
            serverPlayer.teleportTo((double)centerPos.getX() + 0.5, serverPlayer.getY(), (double)centerPos.getZ() + 0.5);
            VanguardUtil.spawnTeleportParticles(serverPlayer.serverLevel(), centerPos);
        }
    }

    public static void oblibirateTreeAbovePosition(ServerLevel serverLevel, BlockPos blockPos, int height, int radius) {
        MinecraftServer minecraftServer = serverLevel.getServer();
        int i = 0;
        while (i < height) {
            int finalI = i++;
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                for (BlockPos aroundPos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-radius, finalI, -radius), (BlockPos)blockPos.offset(radius, finalI, radius))) {
                    BlockState aroundBlockState = serverLevel.getBlockState(aroundPos);
                    Block aroundBlock = aroundBlockState.getBlock();
                    if (!(aroundBlock instanceof RotatedPillarBlock) && !(aroundBlock instanceof LeavesBlock)) continue;
                    serverLevel.setBlock(aroundPos, Blocks.AIR.defaultBlockState(), 3);
                    VanguardUtil.spawnTeleportParticles(serverLevel, aroundPos);
                }
            }, (int)(finalI * 10));
        }
    }
}

