/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.parts.voidborn.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import com.natamus.voidvanguards_common_neoforge.data.HeadData;
import com.natamus.voidvanguards_common_neoforge.parts.cosmos.util.CosmosDimensionUtil;
import com.natamus.voidvanguards_common_neoforge.parts.vanguard.util.VanguardUtil;
import com.natamus.voidvanguards_common_neoforge.parts.voidborn.data.VoidbornConstants;
import com.natamus.voidvanguards_common_neoforge.registry.identifier.CosmosLocation;
import com.natamus.voidvanguards_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class VoidbornUtil {
    public static void replaceSignWithVoidbornMob(ServerLevel serverLevel, BlockPos blockPos, Registry<Enchantment> enchantmentRegistry) {
        Mob voidbornMob = VoidbornUtil.getVoidbornMob(serverLevel, blockPos, enchantmentRegistry, false);
        serverLevel.addFreshEntity((Entity)voidbornMob);
        serverLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
    }

    public static Mob getVoidbornMob(ServerLevel serverLevel, BlockPos blockPos, Registry<Enchantment> enchantmentRegistry, boolean isLeader) {
        Pair<EntityType<?>, Mob> voidbornMobPair = VoidbornUtil.getRandomVoidbornMob(serverLevel);
        return VoidbornUtil.getVoidbornMob(serverLevel, blockPos, enchantmentRegistry, isLeader, (EntityType)voidbornMobPair.getFirst(), (Mob)voidbornMobPair.getSecond());
    }

    public static Mob getVoidbornMob(ServerLevel serverLevel, BlockPos blockPos, Registry<Enchantment> enchantmentRegistry, boolean isLeader, EntityType<?> voidbornMobEntityType, Mob voidbornMob) {
        voidbornMob.setPos((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        if (isLeader) {
            voidbornMob.setCustomName((Component)Component.translatable((String)"voidvanguards.voidborn.name.leader").withStyle(ChatFormatting.DARK_PURPLE));
            voidbornMob.setItemSlot(EquipmentSlot.HEAD, HeadData.getGeneratedHead(HeadData.HeadType.VOIDBORN_LEADER));
        } else {
            voidbornMob.setCustomName((Component)Component.translatable((String)"voidvanguards.voidborn.name.recruit"));
            voidbornMob.setItemSlot(EquipmentSlot.HEAD, HeadData.getGeneratedHead(HeadData.HeadType.VOIDBORN));
        }
        Item weaponItem = VoidbornUtil.getRandomVoidbornMobWeapon(voidbornMobEntityType);
        ItemStack weaponStack = new ItemStack((ItemLike)weaponItem);
        weaponStack.enchant(enchantmentRegistry.wrapAsHolder((Object)((Enchantment)enchantmentRegistry.get(Enchantments.INFINITY))), 1);
        voidbornMob.setItemSlot(EquipmentSlot.MAINHAND, weaponStack);
        voidbornMob.getTags().add("voidvanguards.voidborn");
        voidbornMob.setPersistenceRequired();
        voidbornMob.setCanPickUpLoot(false);
        return voidbornMob;
    }

    public static Mob getVoidbornLeader(ServerLevel serverLevel, BlockPos blockPos) {
        EntityType leaderVoidbornType = EntityType.EVOKER;
        Mob voidbornLeader = VoidbornUtil.getVoidbornMob(serverLevel, blockPos, (Registry<Enchantment>)serverLevel.registryAccess().registryOrThrow(Registries.ENCHANTMENT), true, leaderVoidbornType, (Mob)leaderVoidbornType.create((Level)serverLevel));
        voidbornLeader.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
        voidbornLeader.addTag("voidvanguards.voidborn_leader");
        return voidbornLeader;
    }

    public static Mob spawnVoidbornLeader(ServerLevel serverLevel, BlockPos blockPos) {
        Mob voidbornLeader = VoidbornUtil.getVoidbornLeader(serverLevel, blockPos);
        serverLevel.addFreshEntity((Entity)voidbornLeader);
        VanguardUtil.spawnTeleportParticles(serverLevel, blockPos);
        return voidbornLeader;
    }

    public static Pair<EntityType<?>, Mob> getRandomVoidbornMob(ServerLevel serverLevel) {
        EntityType<?> randomType = VoidbornConstants.possibleEnemyMobVariants.get(serverLevel.getRandom().nextInt(VoidbornConstants.possibleEnemyMobVariants.size()));
        return Pair.of(randomType, (Object)((Mob)randomType.create((Level)serverLevel)));
    }

    public static Item getRandomVoidbornMobWeapon(EntityType<?> entityType) {
        List<Item> weapons = VoidbornConstants.possibleWeapons.get(entityType);
        if (weapons == null || weapons.isEmpty()) {
            return Items.AIR;
        }
        return weapons.get((int)(Math.random() * (double)weapons.size()));
    }

    public static void fillChestWithItems(ServerLevel serverLevel, BlockEntity blockEntity, BlockPos blockPos, BlockState blockState, Registry<Enchantment> enchantmentRegistry) {
        if (blockEntity instanceof ChestBlockEntity) {
            Item[] weaponItems;
            Item[] armorItems;
            ChestBlockEntity chestBlockEntity = (ChestBlockEntity)blockEntity;
            DataComponentMap.Builder dataComponentMapBuilder = DataComponentMap.builder();
            dataComponentMapBuilder.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"voidvanguards.voidborn.chest.title"));
            chestBlockEntity.setComponents(dataComponentMapBuilder.build());
            int chestSize = chestBlockEntity.getContainerSize();
            ArrayList<Integer> chestSlotRange = new ArrayList<Integer>(IntStream.range(0, chestSize).boxed().toList());
            Collections.shuffle(chestSlotRange);
            int slotIndex = 0;
            Holder protectionEnchantmentHolder = enchantmentRegistry.wrapAsHolder((Object)((Enchantment)enchantmentRegistry.get(Enchantments.PROTECTION)));
            Holder sharpnessEnchantmentHolder = enchantmentRegistry.wrapAsHolder((Object)((Enchantment)enchantmentRegistry.get(Enchantments.SHARPNESS)));
            for (Item armor : armorItems = new Item[]{Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS}) {
                if (slotIndex >= chestSlotRange.size()) break;
                ItemStack armourStack = new ItemStack((ItemLike)armor);
                armourStack.enchant(protectionEnchantmentHolder, 1);
                chestBlockEntity.setItem(((Integer)chestSlotRange.get(slotIndex++)).intValue(), armourStack);
            }
            for (Item weapon : weaponItems = new Item[]{Items.IRON_SWORD, Items.IRON_AXE}) {
                if (slotIndex >= chestSlotRange.size()) break;
                ItemStack weaponStack = new ItemStack((ItemLike)weapon);
                weaponStack.enchant(sharpnessEnchantmentHolder, 1);
                chestBlockEntity.setItem(((Integer)chestSlotRange.get(slotIndex++)).intValue(), weaponStack);
            }
            if (slotIndex < chestSlotRange.size()) {
                chestBlockEntity.setItem(((Integer)chestSlotRange.get(slotIndex++)).intValue(), new ItemStack((ItemLike)Items.SHIELD));
            }
            Item[] foodItems = new Item[]{Items.BREAD, Items.COOKED_CHICKEN, Items.COOKED_BEEF};
            RandomSource random = serverLevel.random;
            while (slotIndex < chestSlotRange.size()) {
                Item randomFood = foodItems[random.nextInt(foodItems.length)];
                int count = 1 + random.nextInt(4);
                chestBlockEntity.setItem(((Integer)chestSlotRange.get(slotIndex++)).intValue(), new ItemStack((ItemLike)randomFood, count));
            }
            chestBlockEntity.setChanged();
            serverLevel.sendBlockUpdated(blockPos, blockState, blockState, 3);
        }
    }

    public static BlockPos getVoidbornBaseSpawnPos(ServerPlayer serverPlayer) {
        return VoidbornUtil.getVoidbornBaseSpawnPos(serverPlayer, CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.getUUID(), CosmosLocation.VOIDBORN_BASE));
    }

    public static BlockPos getVoidbornBaseSpawnPos(ServerPlayer serverPlayer, BlockPos voidbornCosmosBasePos) {
        return voidbornCosmosBasePos.offset(15, 0, 0);
    }

    public static BlockPos getTeleportBackButtonPosition(ServerPlayer serverPlayer) {
        return VoidbornUtil.getTeleportBackButtonPosition(serverPlayer, CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.getUUID(), CosmosLocation.VOIDBORN_BASE));
    }

    public static BlockPos getTeleportBackButtonPosition(ServerPlayer serverPlayer, BlockPos voidbornCosmosBasePos) {
        return VoidbornUtil.getVoidbornBaseSpawnPos(serverPlayer, voidbornCosmosBasePos).offset(3, 1, 0);
    }

    public static boolean isBlockPosTeleportBackButtonPosition(ServerPlayer serverPlayer, BlockPos blockPos) {
        return blockPos.equals((Object)VoidbornUtil.getTeleportBackButtonPosition(serverPlayer));
    }

    public static BlockPos getRadarLeverPosition(ServerPlayer serverPlayer) {
        return CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.getUUID(), CosmosLocation.VOIDBORN_BASE).offset(-28, 8, -37);
    }

    public static boolean isBlockPosRadarLeverPosition(ServerPlayer serverPlayer, BlockPos blockPos) {
        return blockPos.equals((Object)VoidbornUtil.getRadarLeverPosition(serverPlayer));
    }

    public static List<BlockPos> getRadarEndRodPositions(ServerPlayer serverPlayer) {
        BlockPos middlePos = CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.getUUID(), CosmosLocation.VOIDBORN_BASE).offset(-26, 12, -37);
        return Arrays.asList(middlePos.offset(0, 1, 0), middlePos.offset(-1, 0, -1), middlePos.offset(-1, 0, 1), middlePos.offset(1, 0, -1), middlePos.offset(1, 0, 1));
    }

    public static void spawnLightningAtRadarEndRods(ServerPlayer serverPlayer) {
        MinecraftServer minecraftServer = serverPlayer.getServer();
        for (int delay = 0; delay <= 50; delay += 10) {
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                for (BlockPos endRodPos : VoidbornUtil.getRadarEndRodPositions(serverPlayer)) {
                    Util.spawnLightning(serverPlayer.serverLevel(), endRodPos, serverPlayer);
                }
            }, (int)delay);
        }
    }

    public static boolean shouldMakeAmbientSound(Level level) {
        return level.random.nextInt(5) == 0;
    }
}

