/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.registry.block;

import com.natamus.voidvanguards_common_neoforge.data.ServerSaveData;
import com.natamus.voidvanguards_common_neoforge.parts.cosmos.functions.CosmosDimensionFunctions;
import com.natamus.voidvanguards_common_neoforge.util.Util;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class CosmosPortalBlock
extends NetherPortalBlock {
    public CosmosPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AXIS, (Comparable)Direction.Axis.X));
    }

    protected void randomTick(@NotNull BlockState blockState, @NotNull ServerLevel serverLevel, @NotNull BlockPos blockPos, @NotNull RandomSource randomSource) {
    }

    protected void entityInside(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Entity entity) {
        if (level.isClientSide) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        if (serverPlayer.getTags().contains("voidvanguards.triggeredEntityInside")) {
            return;
        }
        List nearbyMobs = level.getEntitiesOfClass(Mob.class, new AABB(blockPos).inflate(16.0), mob -> mob.getTags().contains("voidvanguards.voidborn"));
        if (!nearbyMobs.isEmpty()) {
            Util.addSendMessageTag(serverPlayer, Component.translatable((String)"voidvanguards.message.voidborn.cosmos_gate.mobsAround").getString());
            return;
        }
        serverPlayer.getTags().add("voidvanguards.triggeredEntityInside");
        UUID playerUUID = serverPlayer.getUUID();
        if (ServerSaveData.get().answeredRadioPlayerUUIDS.contains(playerUUID) && !ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.contains(playerUUID)) {
            CosmosDimensionFunctions.teleportPlayerToVoidbornBase(serverPlayer.serverLevel(), serverPlayer);
        } else {
            Direction facing = serverPlayer.getDirection().getOpposite();
            BlockPos targetPos = serverPlayer.blockPosition().relative(facing, 2);
            while (!level.getBlockState(targetPos).isAir() && targetPos.getY() < level.getMaxBuildHeight()) {
                targetPos = targetPos.above();
            }
            serverPlayer.teleportTo((ServerLevel)level, (double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5, serverPlayer.getYRot(), serverPlayer.getXRot());
            Util.addSendMessageTag(serverPlayer, Component.translatable((String)"voidvanguards.message.voidborn.cosmos_gate.enterUnable").getString());
            Util.removeTag(serverPlayer, "voidvanguards.triggeredEntityInside");
        }
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState blockStateA, @NotNull Direction $$1, @NotNull BlockState blockStateB, @NotNull LevelAccessor levelAccessor, @NotNull BlockPos blockPosA, @NotNull BlockPos blockPosB) {
        return blockStateA;
    }

    public void animateTick(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull RandomSource randomSource) {
        for (int $$4 = 0; $$4 < 4; ++$$4) {
            double $$5 = (double)blockPos.getX() + randomSource.nextDouble();
            double $$6 = (double)blockPos.getY() + randomSource.nextDouble();
            double $$7 = (double)blockPos.getZ() + randomSource.nextDouble();
            double $$8 = ((double)randomSource.nextFloat() - 0.5) * 0.5;
            double $$9 = ((double)randomSource.nextFloat() - 0.5) * 0.5;
            double $$10 = ((double)randomSource.nextFloat() - 0.5) * 0.5;
            int $$11 = randomSource.nextInt(2) * 2 - 1;
            if (!level.getBlockState(blockPos.west()).is((Block)this) && !level.getBlockState(blockPos.east()).is((Block)this)) {
                $$5 = (double)blockPos.getX() + 0.5 + 0.25 * (double)$$11;
                $$8 = randomSource.nextFloat() * 2.0f * (float)$$11;
            } else {
                $$7 = (double)blockPos.getZ() + 0.5 + 0.25 * (double)$$11;
                $$10 = randomSource.nextFloat() * 2.0f * (float)$$11;
            }
            level.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, $$5, $$6, $$7, $$8, $$9, $$10);
        }
    }
}

