/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.implementations.networking.api.Dispatcher;
import com.natamus.voidvanguards_common_neoforge.data.ClientSaveData;
import com.natamus.voidvanguards_common_neoforge.data.Constants;
import com.natamus.voidvanguards_common_neoforge.data.ServerSaveData;
import com.natamus.voidvanguards_common_neoforge.networking.packets.ToClientSyncSaveDataPacket;
import com.natamus.voidvanguards_common_neoforge.parts.skyship.data.SkyShipVariables;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SaveLoadUtils {
    public static String savePlayerData(Player player) {
        String newTag = SaveLoadUtils.getPlayerDataTag(player);
        SaveLoadUtils.removeOldSaveTag(player);
        player.addTag(newTag);
        return newTag;
    }

    public static void loadPlayerData(Player player) {
        if (player.level().isClientSide()) {
            return;
        }
        String saveDataTag = "";
        Set tags = player.getTags();
        for (String tag : tags) {
            if (!tag.startsWith(Constants.saveDataTagPrefix)) continue;
            saveDataTag = tag;
            break;
        }
        if (saveDataTag.isEmpty()) {
            saveDataTag = SaveLoadUtils.savePlayerData(player);
        } else if (!SaveLoadUtils.saveDataTagUUIDMatches(player, saveDataTag)) {
            ServerSaveData.removeUUID(player.getUUID());
            saveDataTag = SaveLoadUtils.savePlayerData(player);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        SaveLoadUtils.serverSyncPlayerData(serverPlayer, saveDataTag);
        Dispatcher.sendToClient((Object)new ToClientSyncSaveDataPacket(saveDataTag), (ServerPlayer)serverPlayer);
    }

    public static void serverSyncPlayerData(ServerPlayer serverPlayer, String saveDataTag) {
        UUID playerUUID = serverPlayer.getUUID();
        ServerLevel serverLevel = serverPlayer.serverLevel();
        Registry levelRegistry = serverLevel.registryAccess().registryOrThrow(Registries.DIMENSION);
        block32: for (String saveData : saveDataTag.split("--")) {
            if (!saveData.contains("..")) continue;
            String[] keyValue = saveData.split(Pattern.quote(".."));
            switch (keyValue[0]) {
                case "skyShipTriggered": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().skyShipTriggeredPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().skyShipTriggeredPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().skyShipTriggeredPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().skyShipTriggeredPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "vanguardStationGenerated": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "answeredRadio": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().answeredRadioPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().answeredRadioPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().answeredRadioPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().answeredRadioPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "voidbornGateGenerated": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "cosmosVoidbornBaseGenerated": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "triggeredVoidbornBaseStory": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().triggeredVoidbornBaseStoryPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().triggeredVoidbornBaseStoryPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().triggeredVoidbornBaseStoryPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().triggeredVoidbornBaseStoryPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "triggeredVoidbornLeader": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "gaveVoidbornLeaderRadio": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "sabotagedVoidbornRadar": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "voidVanguardsCompleted": {
                    if (keyValue[1].equals("true")) {
                        if (ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.contains(playerUUID)) continue block32;
                        ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.add(playerUUID);
                        continue block32;
                    }
                    if (!ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.contains(playerUUID)) continue block32;
                    ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.remove(playerUUID);
                    continue block32;
                }
                case "originalPlayerPosition": {
                    int z;
                    int y;
                    int x;
                    String[] rawOriginalPosition = keyValue[1].split("__");
                    String rawOriginalLevelResourceKey = rawOriginalPosition[0];
                    String[] rawOriginalCoordinates = rawOriginalPosition[1].split("_");
                    ResourceLocation originalLevelResourceLocation = ResourceLocation.parse((String)rawOriginalLevelResourceKey.replace("+", ":"));
                    ResourceKey originalLevelResourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)originalLevelResourceLocation);
                    ServerLevel originalLevel = serverLevel.getServer().getLevel(originalLevelResourceKey);
                    if (originalLevel == null) continue block32;
                    try {
                        x = Integer.parseInt(rawOriginalCoordinates[0]);
                        y = Integer.parseInt(rawOriginalCoordinates[1]);
                        z = Integer.parseInt(rawOriginalCoordinates[2]);
                    }
                    catch (NumberFormatException ex) {
                        System.out.println(" !! NumberFormatException for: " + rawOriginalPosition[1]);
                        continue block32;
                    }
                    BlockPos originalPos = new BlockPos(x, y, z);
                    ServerSaveData.get().originalPlayerPositions.put(playerUUID, (Pair<ResourceKey<Level>, BlockPos>)Pair.of((Object)originalLevel.dimension(), (Object)originalPos));
                    continue block32;
                }
                case "enemyCosmosGatePosition": {
                    int z;
                    int y;
                    int x;
                    String[] rawVoidbornBasePosition = keyValue[1].split("__");
                    String rawVoidbornBaseLevelResourceKey = rawVoidbornBasePosition[0];
                    String[] rawVoidbornBaseCoordinates = rawVoidbornBasePosition[1].split("_");
                    ResourceLocation voidbornBaseLevelResourceLocation = ResourceLocation.parse((String)rawVoidbornBaseLevelResourceKey.replace("+", ":"));
                    ResourceKey voidbornBaseLevelResourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)voidbornBaseLevelResourceLocation);
                    ServerLevel voidbornBaseLevel = serverLevel.getServer().getLevel(voidbornBaseLevelResourceKey);
                    if (voidbornBaseLevel == null) continue block32;
                    try {
                        x = Integer.parseInt(rawVoidbornBaseCoordinates[0]);
                        y = Integer.parseInt(rawVoidbornBaseCoordinates[1]);
                        z = Integer.parseInt(rawVoidbornBaseCoordinates[2]);
                    }
                    catch (NumberFormatException ex) {
                        continue block32;
                    }
                    BlockPos voidbornBasePos = new BlockPos(x, y, z);
                    ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.put(playerUUID, (Pair<ResourceKey<Level>, BlockPos>)Pair.of((Object)voidbornBaseLevel.dimension(), (Object)voidbornBasePos));
                    continue block32;
                }
            }
        }
    }

    public static void clientSyncPlayerData(String saveDataTag) {
        block8: for (String saveData : saveDataTag.split("--")) {
            if (!saveData.contains("..")) continue;
            String[] keyValue = saveData.split(Pattern.quote(".."));
            switch (keyValue[0]) {
                case "skyShipTriggered": {
                    if (!keyValue[1].equals("true")) continue block8;
                    SkyShipVariables.triggeredSkyShipEvent = true;
                    continue block8;
                }
                case "voidVanguardsCompleted": {
                    if (!keyValue[1].equals("true")) continue block8;
                    ClientSaveData.voidVanguardsCompleted = true;
                    continue block8;
                }
            }
        }
    }

    public static String getPlayerDataTag(Player player) {
        Pair<ResourceKey<Level>, BlockPos> voidbornCosmosGateCoordinatePair;
        UUID playerUUID = player.getUUID();
        Object dataTag = Constants.saveDataTagPrefix;
        dataTag = (String)dataTag + "--playerUUID.." + String.valueOf(playerUUID);
        dataTag = (String)dataTag + "--skyShipTriggered.." + ServerSaveData.get().skyShipTriggeredPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--vanguardStationGenerated.." + ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--answeredRadio.." + ServerSaveData.get().answeredRadioPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--voidbornGateGenerated.." + ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--cosmosVoidbornBaseGenerated.." + ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--triggeredVoidbornBaseStory.." + ServerSaveData.get().triggeredVoidbornBaseStoryPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--triggeredVoidbornLeader.." + ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--gaveVoidbornLeaderRadio.." + ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--sabotagedVoidbornRadar.." + ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.contains(playerUUID);
        dataTag = (String)dataTag + "--voidVanguardsCompleted.." + ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.contains(playerUUID);
        Pair<ResourceKey<Level>, BlockPos> originalPositionPair = ServerSaveData.get().originalPlayerPositions.get(playerUUID);
        if (originalPositionPair != null) {
            BlockPos originalPositionPos = (BlockPos)originalPositionPair.getSecond();
            dataTag = (String)dataTag + "--originalPlayerPosition.." + ((ResourceKey)originalPositionPair.getFirst()).location().toString().replace(":", "+") + "__" + originalPositionPos.getX() + "_" + originalPositionPos.getY() + "_" + originalPositionPos.getZ();
        }
        if ((voidbornCosmosGateCoordinatePair = ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.get(playerUUID)) != null) {
            BlockPos voidbornCosmosGateCoordinatePos = (BlockPos)voidbornCosmosGateCoordinatePair.getSecond();
            dataTag = (String)dataTag + "--enemyCosmosGatePosition.." + ((ResourceKey)voidbornCosmosGateCoordinatePair.getFirst()).location().toString().replace(":", "+") + "__" + voidbornCosmosGateCoordinatePos.getX() + "_" + voidbornCosmosGateCoordinatePos.getY() + "_" + voidbornCosmosGateCoordinatePos.getZ();
        }
        return dataTag;
    }

    public static void removeOldSaveTag(Player player) {
        ArrayList<String> tagsToRemove = new ArrayList<String>();
        Set tags = player.getTags();
        for (String tag : tags) {
            if (!tag.startsWith(Constants.saveDataTagPrefix)) continue;
            tagsToRemove.add(tag);
        }
        for (String tag : tagsToRemove) {
            player.getTags().remove(tag);
        }
    }

    private static boolean saveDataTagUUIDMatches(Player player, String saveDataTag) {
        for (String saveData : saveDataTag.split("--")) {
            String[] keyValue;
            if (!saveData.contains("..") || !(keyValue = saveData.split(Pattern.quote("..")))[0].equals("playerUUID")) continue;
            return keyValue[1].equals(player.getUUID().toString());
        }
        return false;
    }

    public static void setForcedPositionTag(ServerPlayer serverPlayer, int maxRadius) {
        SaveLoadUtils.setForcedPositionTag(serverPlayer, maxRadius, serverPlayer.blockPosition());
    }

    public static void setForcedPositionTag(ServerPlayer serverPlayer, int maxRadius, BlockPos middlePos) {
        String forcedPositionTag = "voidvanguards.forceposition--forcedPlayerPosition.." + middlePos.getX() + "_" + middlePos.getY() + "_" + middlePos.getZ() + "--radius.." + maxRadius;
        SaveLoadUtils.removeForcedPositionTag(serverPlayer);
        serverPlayer.getTags().add(forcedPositionTag);
    }

    public static void removeForcedPositionTag(ServerPlayer serverPlayer) {
        ArrayList<String> tagsToRemove = new ArrayList<String>();
        Set tags = serverPlayer.getTags();
        for (String tag : tags) {
            if (!tag.startsWith("voidvanguards.forceposition")) continue;
            tagsToRemove.add(tag);
        }
        for (String tag : tagsToRemove) {
            serverPlayer.getTags().remove(tag);
        }
    }
}

