/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_fabric.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.collective_common_fabric.functions.StringFunctions;
import com.natamus.voidvanguards_common_fabric.data.HeadData;
import com.natamus.voidvanguards_common_fabric.data.ServerSaveData;
import com.natamus.voidvanguards_common_fabric.parts.cosmos.functions.CosmosDimensionFunctions;
import com.natamus.voidvanguards_common_fabric.parts.skyship.functions.SkyShipFunctions;
import com.natamus.voidvanguards_common_fabric.parts.vanguard.functions.VanguardFunctions;
import com.natamus.voidvanguards_common_fabric.parts.voidborn.functions.VoidbornFunctions;
import com.natamus.voidvanguards_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class CommandVoidVanguards {
    public static final SuggestionProvider<class_2168> headStackSuggestions = (context, builder) -> class_2172.method_35510(HeadData.headMap.keySet(), (SuggestionsBuilder)builder, value -> value, value -> class_2561.method_43470((String)value));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"voidvanguards").requires(iCommandSender -> iCommandSender.method_9259(2))).then(class_2170.method_9247((String)"reset").executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            SkyShipFunctions.resetSkyShipVariables();
            MessageFunctions.sendMessage((class_2168)source, (class_5250)class_2561.method_43471((String)"voidvanguards.message.skyship.reset").method_27692(class_124.field_1077));
            return 1;
        }))).then(class_2170.method_9247((String)"return").executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            class_3222 serverPlayer = source.method_44023();
            if (!Util.isInCosmosDimension(serverPlayer)) {
                MessageFunctions.sendMessage((class_2168)source, (class_5250)class_2561.method_43470((String)"You are not in the cosmos dimension.").method_27692(class_124.field_1061));
                return 1;
            }
            UUID playerUUID = serverPlayer.method_5667();
            if (!ServerSaveData.get().originalPlayerPositions.containsKey(playerUUID)) {
                MessageFunctions.sendMessage((class_2168)source, (class_5250)class_2561.method_43470((String)"Original location is not in save data.").method_27692(class_124.field_1061));
                return 1;
            }
            if (Util.teleportPlayerToOriginalPosition(serverPlayer)) {
                MessageFunctions.sendMessage((class_2168)source, (class_5250)class_2561.method_43470((String)"Returned to the original location.").method_27692(class_124.field_1077));
            } else {
                MessageFunctions.sendMessage((class_2168)source, (class_5250)class_2561.method_43470((String)"Unable to return player to original position.").method_27692(class_124.field_1061));
            }
            return 1;
        }))).then(class_2170.method_9247((String)"radio").executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            VanguardFunctions.generateRadioAtPlayerPosition(source.method_44023());
            return 1;
        }))).then(class_2170.method_9247((String)"generate").then(class_2170.method_9247((String)"cosmos_gate").executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            class_3222 serverPlayer = source.method_44023();
            VoidbornFunctions.generateVoidbornCosmosGate(serverPlayer.method_51469(), serverPlayer, serverPlayer.method_24515().method_10069(5, 0, 5));
            MessageFunctions.sendMessage((class_1657)serverPlayer, (String)"Generated cosmos gate.", (class_124)class_124.field_1077);
            return 1;
        })))).then(class_2170.method_9247((String)"teleport").then(class_2170.method_9247((String)"voidborn_base").executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            class_3222 serverPlayer = source.method_44023();
            CosmosDimensionFunctions.teleportPlayerToVoidbornBase(serverPlayer.method_51469(), serverPlayer);
            MessageFunctions.sendMessage((class_1657)serverPlayer, (String)"Teleported to voidborn base.", (class_124)class_124.field_1077);
            return 1;
        })))).then(class_2170.method_9247((String)"tag").then(class_2170.method_9247((String)"remove").executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            class_3222 serverPlayer = source.method_44023();
            for (String tag : serverPlayer.method_5752()) {
                if (!tag.toLowerCase().startsWith("voidvanguards")) continue;
                Util.removeTag(serverPlayer, tag);
            }
            MessageFunctions.sendMessage((class_1657)serverPlayer, (String)"Removed all Void Vanguards tags.", (class_124)class_124.field_1077);
            return 1;
        })))).then(class_2170.method_9247((String)"head").then(class_2170.method_9247((String)"list").executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            MessageFunctions.sendMessage((class_2168)source, (String)"You can generate the following heads:", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_2168)source, (String)" Usage: /voidvanguards head <name> <amount>:", (class_124)class_124.field_1077);
            ArrayList<String> headNames = new ArrayList<String>(HeadData.headMap.keySet());
            Collections.sort(headNames);
            String mnstr = String.join((CharSequence)", ", headNames);
            MessageFunctions.sendMessage((class_2168)source, (String)mnstr, (class_124)class_124.field_1054);
            return 1;
        })))).then(class_2170.method_9247((String)"head").then(class_2170.method_9244((String)"head-name", (ArgumentType)StringArgumentType.string()).suggests(headStackSuggestions).executes(command -> CommandVoidVanguards.headCommand((CommandContext<class_2168>)command, 1))))).then(class_2170.method_9247((String)"head").then(class_2170.method_9244((String)"head-name", (ArgumentType)StringArgumentType.string()).suggests(headStackSuggestions).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(command -> CommandVoidVanguards.headCommand((CommandContext<class_2168>)command, IntegerArgumentType.getInteger((CommandContext)command, (String)"amount")))))));
    }

    private static int headCommand(CommandContext<class_2168> command, int amount) {
        class_3222 player;
        class_2168 source = (class_2168)command.getSource();
        String headName = StringArgumentType.getString(command, (String)"head-name").toLowerCase();
        if (!HeadData.headMap.containsKey(headName)) {
            MessageFunctions.sendMessage((class_2168)source, (String)("The headName '" + headName + "' does not exist. You can get a list of all possible heads with:"), (class_124)class_124.field_1061);
            MessageFunctions.sendMessage((class_2168)source, (String)" Usage: /voidvanguards head list", (class_124)class_124.field_1061);
            return 1;
        }
        try {
            player = source.method_9207();
        }
        catch (CommandSyntaxException ex) {
            MessageFunctions.sendMessage((class_2168)source, (String)"This command can only be executed as a player in-game.", (class_124)class_124.field_1061);
            return 1;
        }
        class_1799 headstack = HeadData.headMap.get(headName).method_7972();
        headstack.method_7939(amount);
        if (!player.method_31548().method_7394(headstack)) {
            player.method_7328(headstack, false);
        }
        String s = "";
        if (amount > 1) {
            s = "s";
        }
        MessageFunctions.sendMessage((class_2168)source, (String)("Successfully generated " + amount + " " + StringFunctions.capitalizeFirst((String)headName.replace("_", " ")) + " head" + s + "."), (class_124)class_124.field_1077);
        return 1;
    }
}

