/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_fabric.data;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

public class ServerSaveData {
    private static Data data = new Data();

    public static Data get() {
        return data;
    }

    public static void reset() {
        data = new Data();
    }

    public static void removeUUID(UUID uuid) {
        data.removeUUID(uuid);
    }

    public static class Data {
        private final List<Consumer<UUID>> uuidRemoveConsumers = new ArrayList<Consumer<UUID>>();
        public final List<UUID> skyShipTriggeredPlayerUUIDS = this.register(new ArrayList());
        public final List<UUID> vanguardStationGeneratedPlayerUUIDS = this.register(new ArrayList());
        public final List<UUID> answeredRadioPlayerUUIDS = this.register(new ArrayList());
        public final List<UUID> voidbornGateGeneratedPlayerUUIDS = this.register(new ArrayList());
        public final List<UUID> cosmosVoidbornBaseGeneratedPlayerUUIDS = this.register(new ArrayList());
        public final List<UUID> triggeredVoidbornBaseStoryPlayerUUIDS = this.register(new ArrayList());
        public final List<UUID> triggeredVoidbornLeaderPlayerUUIDS = this.register(new ArrayList());
        public final List<UUID> gaveVoidbornLeaderRadioPlayerUUIDS = this.register(new ArrayList());
        public final List<UUID> sabotagedVoidbornRadarPlayerUUIDS = this.register(new ArrayList());
        public final List<UUID> voidVanguardsCompletedPlayerUUIDS = this.register(new ArrayList());
        public final HashMap<UUID, Pair<class_5321<class_1937>, class_2338>> originalPlayerPositions = this.register(new HashMap());
        public final HashMap<UUID, Pair<class_5321<class_1937>, class_2338>> voidbornCosmosGatePositionPlayerUUIDS = this.register(new HashMap());

        private <T> T register(T field) {
            if (field instanceof Collection) {
                Collection collection = (Collection)field;
                this.uuidRemoveConsumers.add(uuid -> collection.remove(uuid));
            } else if (field instanceof Map) {
                Map map = (Map)field;
                this.uuidRemoveConsumers.add(map::remove);
            }
            return field;
        }

        void removeUUID(UUID uuid) {
            for (Consumer<UUID> remover : this.uuidRemoveConsumers) {
                remover.accept(uuid);
            }
        }
    }
}

