/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_fabric.parts.cosmos.functions;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.collective_common_fabric.functions.TaskFunctions;
import com.natamus.collective_common_fabric.schematic.ParseSchematicFile;
import com.natamus.collective_common_fabric.schematic.ParsedSchematicObject;
import com.natamus.collective_common_fabric.services.Services;
import com.natamus.voidvanguards_common_fabric.data.ServerSaveData;
import com.natamus.voidvanguards_common_fabric.parts.cosmos.util.CosmosDimensionUtil;
import com.natamus.voidvanguards_common_fabric.parts.vanguard.functions.VanguardFunctions;
import com.natamus.voidvanguards_common_fabric.parts.voidborn.functions.VoidbornFunctions;
import com.natamus.voidvanguards_common_fabric.parts.voidborn.util.VoidbornUtil;
import com.natamus.voidvanguards_common_fabric.registry.identifier.CosmosLocation;
import com.natamus.voidvanguards_common_fabric.util.SaveLoadUtils;
import com.natamus.voidvanguards_common_fabric.util.Util;
import java.io.InputStream;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class CosmosDimensionFunctions {
    public static void teleportPlayerToVanguardStation(class_3218 serverLevel, class_3222 serverPlayer, boolean fromSkyShipTrigger) {
        class_2338 spawnPos;
        MinecraftServer minecraftServer = serverLevel.method_8503();
        UUID playerUUID = serverPlayer.method_5667();
        ServerSaveData.get().originalPlayerPositions.put(playerUUID, (Pair<class_5321<class_1937>, class_2338>)Pair.of((Object)serverLevel.method_27983(), (Object)serverPlayer.method_24515()));
        SaveLoadUtils.savePlayerData((class_1657)serverPlayer);
        class_3218 cosmosLevel = Util.getCosmosLevel(serverLevel.method_8503());
        class_2338 vanguardStationPos = CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.method_5667(), CosmosLocation.VANGUARD_STATION);
        if (!ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.contains(playerUUID)) {
            CosmosDimensionFunctions.prepareCosmosSpawnArea(cosmosLevel, serverPlayer, vanguardStationPos);
            spawnPos = vanguardStationPos.method_10069(0, 51, -10);
        } else {
            spawnPos = vanguardStationPos;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            Services.TELEPORT.teleportEntity((class_1297)serverPlayer, cosmosLevel, spawnPos);
            if (fromSkyShipTrigger) {
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.method_8503(), () -> VanguardFunctions.spawnInitialVanguardsAroundPlayer(cosmosLevel, serverPlayer, spawnPos), (int)50);
            } else {
                MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)class_2561.method_43471((String)"item.voidvanguards.orbital_transponder.useSuccess").method_27692(class_124.field_1077));
            }
        }, (int)10);
    }

    private static void prepareCosmosSpawnArea(class_3218 cosmosLevel, class_3222 serverPlayer, class_2338 middlePos) {
        MinecraftServer minecraftServer = cosmosLevel.method_8503();
        InputStream schematicInputstream = Util.getSchematicsInputStream(minecraftServer, "vanguard_station");
        if (schematicInputstream == null) {
            System.out.println("Error generating vanguard station: inputstream is null.");
            return;
        }
        ParsedSchematicObject parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)schematicInputstream, (class_1937)cosmosLevel, (class_2338)middlePos, (int)-73, (boolean)false);
        if (!parsedSchematicObject.parsedCorrectly) {
            System.out.println("Error generating vanguard station: schematic object didn't parse.");
            return;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            for (Pair blockPair : parsedSchematicObject.blocks) {
                cosmosLevel.method_8652((class_2338)blockPair.getFirst(), (class_2680)blockPair.getSecond(), 3);
            }
            ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.add(serverPlayer.method_5667());
            SaveLoadUtils.savePlayerData((class_1657)serverPlayer);
        }, (int)0);
    }

    public static void teleportPlayerToVoidbornBase(class_3218 serverLevel, class_3222 serverPlayer) {
        boolean firstWarp;
        UUID playerUUID = serverPlayer.method_5667();
        class_3218 cosmosLevel = Util.getCosmosLevel(serverLevel.method_8503());
        class_2338 voidbornCosmosBasePos = CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.method_5667(), CosmosLocation.VOIDBORN_BASE);
        class_2338 spawnPos = VoidbornUtil.getVoidbornBaseSpawnPos(serverPlayer, voidbornCosmosBasePos);
        boolean bl = firstWarp = !ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.contains(playerUUID);
        if (firstWarp) {
            VoidbornFunctions.prepareCosmosVoidbornBase(cosmosLevel, serverPlayer, voidbornCosmosBasePos, spawnPos);
        }
        if (firstWarp) {
            MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)class_2561.method_43471((String)"voidvanguards.message.voidborn.cosmos_gate.enterSuccess.first").method_27692(class_124.field_1064), (boolean)true);
        } else {
            MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)class_2561.method_43471((String)"voidvanguards.message.voidborn.cosmos_gate.enterSuccess.again").method_27692(class_124.field_1064), (boolean)true);
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.method_8503(), () -> {
            if (!firstWarp) {
                Services.TELEPORT.teleportEntity((class_1297)serverPlayer, cosmosLevel, spawnPos);
                Util.removeTag(serverPlayer, "voidvanguards.triggeredEntityInside");
            }
        }, (int)10);
    }
}

