/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_fabric.parts.skyship.functions;

import com.natamus.collective_common_fabric.implementations.networking.api.Dispatcher;
import com.natamus.voidvanguards_common_fabric.config.ConfigHandler;
import com.natamus.voidvanguards_common_fabric.data.ClientConstants;
import com.natamus.voidvanguards_common_fabric.networking.packets.ToServerTriggerSkyShipEventPacket;
import com.natamus.voidvanguards_common_fabric.parts.skyship.data.SkyShipPatterns;
import com.natamus.voidvanguards_common_fabric.parts.skyship.data.SkyShipVariables;
import com.natamus.voidvanguards_common_fabric.parts.skyship.util.SkyShipUtil;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SkyShipFunctions {
    public static boolean isLookingAtSkyShip() {
        class_746 player = ClientConstants.mc.field_1724;
        if (!player.method_6115() || player.method_6030().method_7909() != class_1802.field_27070) {
            return false;
        }
        long time = ClientConstants.mc.field_1687.method_8510();
        float partialTicks = ClientConstants.mc.method_47600();
        float orbitAngle = (float)time * 0.001f;
        float sunAngle = SkyShipUtil.getShipSunAngle(ClientConstants.mc, partialTicks);
        Vector3f sunPos = new Vector3f((float)Math.sin(sunAngle), (float)Math.cos(sunAngle), 0.0f).normalize();
        Vector3f offset = new Vector3f((float)Math.cos(orbitAngle) * 15.0f, (float)Math.sin(orbitAngle) * 15.0f, 90.0f);
        Quaternionf rotToSun = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)sunPos);
        offset.rotate((Quaternionfc)rotToSun);
        Vector3f shipPos = new Vector3f((Vector3fc)sunPos).mul(100.0f).add((Vector3fc)offset);
        shipPos.y += 0.1f * (float)Math.sin((double)time * 0.08);
        Vector3f shipDirection = new Vector3f((Vector3fc)shipPos).normalize();
        return SkyShipFunctions.isShipVisible(shipDirection, (class_1657)player, partialTicks);
    }

    private static boolean isShipVisible(Vector3f shipDirection, class_1657 player, float partialTicks) {
        float maxAngleDegrees;
        class_243 lookDir = player.method_5828(partialTicks);
        Vector3f playerLookDir = new Vector3f((float)lookDir.field_1352, (float)lookDir.field_1351, (float)lookDir.field_1350);
        float dot = shipDirection.dot((Vector3fc)playerLookDir);
        float angle = (float)Math.acos(dot);
        float angleDegrees = (float)Math.toDegrees(angle);
        return angleDegrees <= (maxAngleDegrees = 2.0f);
    }

    public static void onLookingAtSkyShip() {
        class_746 player = ClientConstants.mc.field_1724;
        if (player == null) {
            return;
        }
        if (SkyShipVariables.triggeredSkyShipEvent) {
            return;
        }
        SkyShipVariables.focusedOnSkyShip = true;
        if (--SkyShipVariables.ticksLeftForMoreDetail == 0) {
            if (SkyShipVariables.skyShipDetailLevel == SkyShipPatterns.SHIP_PATTERNS.length - 1) {
                SkyShipFunctions.triggerSkyShipEvent((class_1657)player);
                return;
            }
            ++SkyShipVariables.skyShipDetailLevel;
            SkyShipVariables.ticksLeftForMoreDetail = ConfigHandler.ticksNeededForMoreSkyShipDetail;
            player.method_7353((class_2561)class_2561.method_43471((String)"voidvanguards.message.skyship.more_detailed").method_27692(class_124.field_1060), true);
            SkyShipVariables.sentFocusMessage = true;
        }
    }

    public static void triggerSkyShipEvent(class_1657 player) {
        if (SkyShipVariables.triggeredSkyShipEvent) {
            return;
        }
        SkyShipVariables.triggeredSkyShipEvent = true;
        player.method_7353((class_2561)class_2561.method_43471((String)"voidvanguards.message.skyship.explosion").method_27692(class_124.field_1078), true);
        Dispatcher.sendToServer((Object)new ToServerTriggerSkyShipEventPacket());
    }

    public static void resetSkyShipVariables() {
        SkyShipVariables.skyShipVisible = false;
        SkyShipVariables.triggeredSkyShipEvent = false;
        SkyShipVariables.focusedOnSkyShip = false;
        SkyShipVariables.sentFocusMessage = false;
        SkyShipVariables.ticksLeftForMoreDetail = ConfigHandler.ticksNeededForMoreSkyShipDetail;
        SkyShipVariables.skyShipDetailLevel = 0;
    }
}

