/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_fabric.parts.story.functions;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.ItemFunctions;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.collective_common_fabric.functions.TaskFunctions;
import com.natamus.collective_common_fabric.implementations.networking.api.Dispatcher;
import com.natamus.collective_common_fabric.services.Services;
import com.natamus.voidvanguards_common_fabric.data.ServerSaveData;
import com.natamus.voidvanguards_common_fabric.networking.packets.ToClientQueueScreenFlickerEffectPacket;
import com.natamus.voidvanguards_common_fabric.parts.cosmos.functions.CosmosDimensionFunctions;
import com.natamus.voidvanguards_common_fabric.parts.story.util.StoryUtil;
import com.natamus.voidvanguards_common_fabric.parts.vanguard.data.VanguardVariables;
import com.natamus.voidvanguards_common_fabric.parts.vanguard.functions.VanguardFunctions;
import com.natamus.voidvanguards_common_fabric.parts.vanguard.util.VanguardUtil;
import com.natamus.voidvanguards_common_fabric.parts.voidborn.data.VoidbornConstants;
import com.natamus.voidvanguards_common_fabric.parts.voidborn.functions.VoidbornFunctions;
import com.natamus.voidvanguards_common_fabric.parts.voidborn.util.VoidbornUtil;
import com.natamus.voidvanguards_common_fabric.registry.block.CosmosPortalBlock;
import com.natamus.voidvanguards_common_fabric.registry.objects.VanguardItems;
import com.natamus.voidvanguards_common_fabric.util.SaveLoadUtils;
import com.natamus.voidvanguards_common_fabric.util.Util;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1634;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class StoryFunctions {
    public static void processVanguardInitialCosmos(class_3218 serverLevel, class_3222 serverPlayer, class_2338 spawnPos, List<class_1309> vanguards) {
        String baseKey = "voidvanguards.message.vanguards.cosmos.initial.";
        class_5250 speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.vanguard.name.leader", class_124.field_1079, true);
        int flickerDelay = -1;
        int totalDelay = 20;
        int lastDelay = 0;
        for (int i = 1; i <= 12; ++i) {
            class_5250 messageTextComponent = class_2561.method_43471((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                messageTextComponent = i == 8 ? class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{class_2561.method_43471((String)"voidvanguards.voidborn.name").method_27692(class_124.field_1064)}) : class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{serverPlayer.method_5477()});
                rawMessage = messageTextComponent.getString();
            }
            class_124 messageColour = StoryUtil.getMessageColour(rawMessage, "...", class_124.field_1068, class_124.field_1061);
            if (flickerDelay <= 0 && messageColour.equals((Object)class_124.field_1061)) {
                flickerDelay = totalDelay;
            }
            class_5250 messageComponent = speakerComponent.method_27661().method_10852((class_2561)messageTextComponent.method_27692(messageColour));
            int delay = StoryUtil.getSentenceTickDelay((class_2561)messageComponent);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.method_8503(), () -> MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)messageComponent), (int)totalDelay);
            totalDelay += delay;
            lastDelay = delay;
        }
        Dispatcher.sendToClient((Object)new ToClientQueueScreenFlickerEffectPacket(flickerDelay, totalDelay - lastDelay - flickerDelay), (class_3222)serverPlayer);
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.method_8503(), () -> {
            SaveLoadUtils.removeForcedPositionTag(serverPlayer);
            if (Util.teleportPlayerToOriginalPosition(serverPlayer)) {
                MinecraftServer minecraftServer = serverLevel.method_8503();
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> VanguardFunctions.createGravesAfterInitialEncounter(serverLevel, serverPlayer, spawnPos, vanguards), (int)1);
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> VanguardFunctions.generateRadioAtPlayerPosition(serverPlayer), (int)100);
                MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)class_2561.method_43471((String)"voidvanguards.message.vanguards.home.initial.1").method_27692(class_124.field_1065), (boolean)true);
            }
        }, (int)(totalDelay - lastDelay));
    }

    public static void processUsingOrbitalRadio(class_3218 serverLevel, class_3222 serverPlayer) {
        MinecraftServer minecraftServer = serverLevel.method_8503();
        UUID playerUUID = serverPlayer.method_5667();
        String baseKey = "voidvanguards.message.vanguards.radio.initial.";
        class_5250 speakerComponent = StoryUtil.getSpeakerComponent("item.voidvanguards.orbital_radio", class_124.field_1075, true);
        if (!ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.containsKey(playerUUID)) {
            class_2338 voidbornBaseBlockPos = Util.getRANDOMVoidbornCosmosGateCoordinates(serverLevel, serverPlayer);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> VoidbornFunctions.generateVoidbornCosmosGate(serverLevel, serverPlayer, voidbornBaseBlockPos), (int)0);
            int totalDelay = 20;
            for (int i = 1; i <= 14; ++i) {
                class_5250 messageTextComponent = class_2561.method_43471((String)(baseKey + i));
                String rawMessage = messageTextComponent.getString();
                if (rawMessage.contains("%s")) {
                    messageTextComponent = i == 8 ? class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{class_2561.method_43471((String)"voidvanguards.voidborn.name").method_27692(class_124.field_1064)}) : (i == 11 ? class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{class_2561.method_43470((String)(voidbornBaseBlockPos.method_10263() + ", " + voidbornBaseBlockPos.method_10264() + ", " + voidbornBaseBlockPos.method_10260())).method_27692(class_124.field_1065)}) : class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{serverPlayer.method_5477()}));
                    rawMessage = messageTextComponent.getString();
                }
                class_124 messageColour = class_124.field_1068;
                class_5250 messageComponent = speakerComponent.method_27661().method_10852((class_2561)messageTextComponent.method_27692(messageColour));
                int delay = StoryUtil.getSentenceTickDelay((class_2561)messageComponent);
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)messageComponent), (int)totalDelay);
                totalDelay += delay;
            }
            ServerSaveData.get().answeredRadioPlayerUUIDS.add(playerUUID);
            SaveLoadUtils.savePlayerData((class_1657)serverPlayer);
        } else {
            Pair<class_5321<class_1937>, class_2338> voidbornBasePosPair = ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.get(playerUUID);
            class_5321 levelResourceKey = (class_5321)voidbornBasePosPair.getFirst();
            class_2338 voidbornBasePos = (class_2338)voidbornBasePosPair.getSecond();
            MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)class_2561.method_43471((String)"voidvanguards.message.vanguards.radio.coordinates.1"));
            MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)class_2561.method_43469((String)"voidvanguards.message.vanguards.radio.coordinates.2", (Object[])new Object[]{class_2561.method_43470((String)(voidbornBasePos.method_10263() + ", " + voidbornBasePos.method_10264() + ", " + voidbornBasePos.method_10260())).method_27692(class_124.field_1065)}));
        }
    }

    public static void processInitialVoidbornLeaderEncounter(class_3218 serverLevel, class_3222 serverPlayer, class_1308 voidbornLeader) {
        MinecraftServer minecraftServer = serverLevel.method_8503();
        ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.add(serverPlayer.method_5667());
        SaveLoadUtils.savePlayerData((class_1657)serverPlayer);
        for (class_1308 mob : serverLevel.method_18467(class_1308.class, voidbornLeader.method_5829().method_1014(120.0))) {
            if (mob instanceof class_1634) {
                mob.method_5650(class_1297.class_5529.field_26999);
                continue;
            }
            if (!mob.method_5752().contains("voidvanguards.voidborn")) continue;
            mob.method_5780("voidvanguards.notarget");
            mob.method_5996(class_5134.field_23719).method_6192(0.0);
            mob.method_5980(null);
        }
        String baseKey = "voidvanguards.message.voidborn.initial.";
        class_5250 speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.voidborn.name.leader", class_124.field_1064, true);
        int totalDelay = 20;
        int lastDelay = 0;
        for (int i = 1; i <= 11; ++i) {
            class_5250 messageTextComponent = class_2561.method_43471((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                messageTextComponent = class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{serverPlayer.method_5477()});
                rawMessage = messageTextComponent.getString();
            }
            class_124 messageColour = i == 8 ? class_124.field_1061 : (i == 11 ? class_124.field_1080 : class_124.field_1068);
            class_5250 messageComponent = !rawMessage.startsWith(" ~") ? speakerComponent.method_27661().method_10852((class_2561)messageTextComponent.method_27692(messageColour)) : messageTextComponent.method_27692(messageColour);
            int delay = StoryUtil.getSentenceTickDelay((class_2561)messageComponent);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)messageComponent, (boolean)messageColour.equals((Object)class_124.field_1080)), (int)totalDelay);
            totalDelay += delay;
            lastDelay = delay;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> voidbornLeader.method_5780("voidvanguards.vulnerable"), (int)(totalDelay - lastDelay));
    }

    public static void processVoidbornLeaderGiveRadio(class_3218 serverLevel, class_3222 serverPlayer, class_1308 voidbornLeader, class_1799 orbitalRadioStack) {
        MinecraftServer minecraftServer = serverLevel.method_8503();
        UUID playerUUID = serverPlayer.method_5667();
        if (ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.contains(playerUUID)) {
            return;
        }
        ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.add(playerUUID);
        SaveLoadUtils.savePlayerData((class_1657)serverPlayer);
        SaveLoadUtils.removeForcedPositionTag(serverPlayer);
        orbitalRadioStack.method_7934(1);
        String baseKey = "voidvanguards.message.voidborn.givenradio.";
        class_5250 speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.voidborn.name.leader", class_124.field_1064, true);
        int totalDelay = 0;
        int i = 1;
        while (i <= 3) {
            class_5250 messageTextComponent = class_2561.method_43471((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                messageTextComponent = class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{serverPlayer.method_5477()});
                rawMessage = messageTextComponent.getString();
            }
            class_124 messageColour = class_124.field_1068;
            class_5250 messageComponent = speakerComponent.method_27661().method_10852((class_2561)messageTextComponent.method_27692(messageColour));
            int delay = StoryUtil.getSentenceTickDelay((class_2561)messageComponent);
            int finalI = i++;
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)messageComponent, (finalI == 1 ? 1 : 0) != 0), (int)totalDelay);
            totalDelay += delay;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)speakerComponent.method_27661().method_10852((class_2561)class_2561.method_43471((String)(baseKey + "4")).method_27692(class_124.field_1064)), (boolean)true);
            for (class_1308 mob : serverLevel.method_18467(class_1308.class, serverPlayer.method_5829().method_1014(120.0))) {
                Set tags = mob.method_5752();
                if (!tags.contains("voidvanguards.voidborn") || tags.contains("voidvanguards.voidborn_leader")) continue;
                VanguardUtil.spawnTeleportParticles(serverLevel, mob.method_24515());
                mob.method_5650(class_1297.class_5529.field_26999);
            }
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                VanguardUtil.spawnTeleportParticles(serverLevel, voidbornLeader.method_24515());
                voidbornLeader.method_5650(class_1297.class_5529.field_26999);
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                    CosmosDimensionFunctions.teleportPlayerToVanguardStation(serverLevel, serverPlayer, false);
                    StoryFunctions.processPostGivingRadioVanguardStation(Util.getCosmosLevel(serverLevel.method_8503()), serverPlayer);
                }, (int)20);
            }, (int)20);
        }, (int)(totalDelay + 100));
    }

    public static void processVoidbornLeaderAttacked(class_3218 serverLevel, class_3222 serverPlayer, class_1308 voidbornLeader) {
        MinecraftServer minecraftServer = serverLevel.method_8503();
        voidbornLeader.method_5780("voidvanguards.attacked");
        for (class_1308 mob : serverLevel.method_18467(class_1308.class, voidbornLeader.method_5829().method_1014(120.0))) {
            if (!mob.method_5752().contains("voidvanguards.voidborn")) {
                return;
            }
            mob.method_5738("voidvanguards.notarget");
            float movementValue = VoidbornConstants.voidbornMovementSpeeds.get(mob.method_5864()).floatValue();
            mob.method_5996(class_5134.field_23719).method_6192((double)movementValue);
        }
        SaveLoadUtils.removeForcedPositionTag(serverPlayer);
        String baseKey = "voidvanguards.message.voidborn.attacked.";
        class_5250 speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.voidborn.name.leader", class_124.field_1064, true);
        int totalDelay = 0;
        int i = 1;
        while (i <= 4) {
            class_5250 messageTextComponent = class_2561.method_43471((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                messageTextComponent = class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{serverPlayer.method_5477()});
                rawMessage = messageTextComponent.getString();
            }
            class_124 messageColour = i == 1 ? class_124.field_1061 : (i == 4 ? class_124.field_1080 : class_124.field_1068);
            class_5250 messageComponent = !rawMessage.startsWith(" ~") ? speakerComponent.method_27661().method_10852((class_2561)messageTextComponent.method_27692(messageColour)) : messageTextComponent.method_27692(messageColour);
            int delay = StoryUtil.getSentenceTickDelay((class_2561)messageComponent);
            int finalI = i++;
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)messageComponent, (finalI == 1 || messageColour.equals((Object)class_124.field_1080) ? 1 : 0) != 0), (int)totalDelay);
            totalDelay += delay;
        }
    }

    public static void processVanguardsInVoidbornBase(class_3218 serverLevel, class_3222 serverPlayer, List<class_1309> vanguards) {
        MinecraftServer minecraftServer = serverLevel.method_8503();
        String baseKey = "voidvanguards.message.vanguards.voidbornBase.";
        class_5250 speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.vanguard.name.leader", class_124.field_1079, true);
        int totalDelay = 20;
        int i = 1;
        while (i <= 6) {
            class_5250 messageTextComponent = class_2561.method_43471((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                messageTextComponent = i == 2 ? class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{class_2561.method_43471((String)"voidvanguards.voidborn.name").method_27692(class_124.field_1064)}) : class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{serverPlayer.method_5477()});
                rawMessage = messageTextComponent.getString();
            }
            class_124 messageColour = class_124.field_1068;
            class_5250 messageComponent = speakerComponent.method_27661().method_10852((class_2561)messageTextComponent.method_27692(messageColour));
            int delay = StoryUtil.getSentenceTickDelay((class_2561)messageComponent);
            int finalI = i++;
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)messageComponent, (finalI == 1 ? 1 : 0) != 0), (int)totalDelay);
            totalDelay += delay;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            SaveLoadUtils.removeForcedPositionTag(serverPlayer);
            class_3218 overworldLevel = minecraftServer.method_30002();
            Pair<class_5321<class_1937>, class_2338> cosmosGatePair = ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.get(serverPlayer.method_5667());
            class_2338 gatePos = cosmosGatePair == null ? Util.getRANDOMVoidbornCosmosGateCoordinates(overworldLevel, serverPlayer) : (class_2338)cosmosGatePair.getSecond();
            Services.TELEPORT.teleportEntity((class_1297)serverPlayer, overworldLevel, gatePos);
            for (class_1309 vanguard : vanguards) {
                vanguard.method_5650(class_1297.class_5529.field_26999);
            }
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                for (class_2338 aroundPos : class_2338.method_10097((class_2338)gatePos.method_10069(-10, -10, -10), (class_2338)gatePos.method_10069(10, 10, 10))) {
                    if (!(overworldLevel.method_8320(aroundPos).method_26204() instanceof CosmosPortalBlock)) continue;
                    overworldLevel.method_8652(aroundPos, class_2246.field_10124.method_9564(), 3);
                }
            }, (int)50);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> StoryFunctions.processPostVoidbornBaseVanguardLeader(overworldLevel, serverPlayer), (int)200);
        }, (int)totalDelay);
    }

    public static void processPostGivingRadioVanguardStation(class_3218 serverLevel, class_3222 serverPlayer) {
        MinecraftServer minecraftServer = serverLevel.method_8503();
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            int vanguardCount = 4;
            List<class_2338> vanguardPositions = VanguardUtil.getVanguardPositions(serverPlayer.method_24515(), vanguardCount);
            List<class_1309> vanguards = VanguardUtil.getVanguardsToSummon((class_1937)serverLevel, vanguardCount);
            VanguardFunctions.spawnVanguardsAroundPlayer(serverLevel, serverPlayer, serverPlayer.method_24515(), vanguardCount, true, vanguardPositions, vanguards);
            for (class_1309 vanguard : vanguards) {
                vanguard.method_5780("voidvanguards.vulnerable");
            }
            String baseKey = "voidvanguards.message.voidborn.vanguardStation.";
            class_5250 vanguardSpeakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.vanguard.name.leader", class_124.field_1079, true);
            class_5250 voidbornSpeakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.voidborn.name.leader", class_124.field_1064, true);
            int totalDelay = 20;
            for (int i = 1; i <= 4; ++i) {
                class_5250 messageTextComponent = class_2561.method_43471((String)(baseKey + i));
                String rawMessage = messageTextComponent.getString();
                if (rawMessage.contains("%s")) {
                    messageTextComponent = class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{serverPlayer.method_5477()});
                    rawMessage = messageTextComponent.getString();
                }
                class_124 messageColour = StoryUtil.getMessageColour(rawMessage, "...", class_124.field_1068, class_124.field_1061);
                class_5250 messageComponent = vanguardSpeakerComponent.method_27661().method_10852((class_2561)messageTextComponent.method_27692(messageColour));
                int delay = StoryUtil.getSentenceTickDelay((class_2561)messageComponent);
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)messageComponent), (int)totalDelay);
                totalDelay += delay;
            }
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                class_2338 voidbornLeaderPos = serverPlayer.method_24515().method_10095();
                class_1308 voidbornLeader = VoidbornUtil.getVoidbornLeader(serverLevel, voidbornLeaderPos);
                voidbornLeader.method_5780("voidvanguards.notarget");
                serverLevel.method_8649((class_1297)voidbornLeader);
                VanguardUtil.spawnTeleportParticles(serverLevel, voidbornLeaderPos);
                int newTotalDelay = 20;
                int i = 5;
                while (i <= 8) {
                    class_5250 messageTextComponent = class_2561.method_43471((String)(baseKey + i));
                    String rawMessage = messageTextComponent.getString();
                    if (rawMessage.contains("%s")) {
                        messageTextComponent = class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{serverPlayer.method_5477()});
                        rawMessage = messageTextComponent.getString();
                    }
                    class_124 messageColour = StoryUtil.getMessageColour(rawMessage, "...", class_124.field_1068, class_124.field_1061);
                    class_5250 messageComponent = voidbornSpeakerComponent.method_27661().method_10852((class_2561)messageTextComponent.method_27692(messageColour));
                    int delay = StoryUtil.getSentenceTickDelay((class_2561)messageComponent);
                    int finalI = i++;
                    TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)messageComponent, (finalI == 5 ? 1 : 0) != 0), (int)newTotalDelay);
                    newTotalDelay += delay;
                }
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                    class_2378 enchantmentRegistry = minecraftServer.method_30611().method_30530(class_7924.field_41265);
                    for (class_1309 vanguard : vanguards) {
                        vanguard.method_5996(class_5134.field_23719).method_6192(0.5);
                        for (int n = 1; n <= 4; ++n) {
                            class_1308 voidborn = VoidbornUtil.getVoidbornMob(serverLevel, vanguard.method_24515(), (class_2378<class_1887>)enchantmentRegistry, false);
                            voidborn.method_5814(voidborn.method_23317() - (double)n, voidborn.method_23318(), voidborn.method_23321() + (double)n);
                            serverLevel.method_8649((class_1297)voidborn);
                        }
                    }
                    TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                        int newNewTotalDelay = 0;
                        for (int i = 9; i <= 11; ++i) {
                            class_5250 messageTextComponent = class_2561.method_43471((String)(baseKey + i));
                            String rawMessage = messageTextComponent.getString();
                            if (rawMessage.contains("%s")) {
                                messageTextComponent = class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{serverPlayer.method_5477()});
                                rawMessage = messageTextComponent.getString();
                            }
                            class_124 messageColour = StoryUtil.getMessageColour(rawMessage, "...", class_124.field_1068, class_124.field_1061);
                            class_5250 messageComponent = voidbornSpeakerComponent.method_27661().method_10852((class_2561)messageTextComponent.method_27692(messageColour));
                            int delay = StoryUtil.getSentenceTickDelay((class_2561)messageComponent);
                            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)messageComponent), (int)newNewTotalDelay);
                            newNewTotalDelay += delay;
                        }
                        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                            ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.add(serverPlayer.method_5667());
                            SaveLoadUtils.savePlayerData((class_1657)serverPlayer);
                            CosmosDimensionFunctions.teleportPlayerToVoidbornBase(serverPlayer.method_51469(), serverPlayer);
                            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                                MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)class_2561.method_43471((String)"voidvanguards.message.voidborn.endAsteroid.1").method_27692(class_124.field_1077), (boolean)true);
                                MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)class_2561.method_43471((String)"voidvanguards.message.voidborn.endAsteroid.2").method_27692(class_124.field_1063));
                            }, (int)10);
                        }, (int)newNewTotalDelay);
                    }, (int)200);
                }, (int)newTotalDelay);
            }, (int)totalDelay);
        }, (int)10);
    }

    public static void processPostVoidbornBaseVanguardLeader(class_3218 serverLevel, class_3222 serverPlayer) {
        MinecraftServer minecraftServer = serverLevel.method_8503();
        int vanguardCount = 1;
        class_2338 playerPos = serverPlayer.method_24515();
        List<class_2338> vanguardPositions = VanguardUtil.getVanguardPositions(playerPos, vanguardCount);
        List<class_1309> vanguards = VanguardUtil.getVanguardsToSummon((class_1937)serverLevel, vanguardCount);
        VanguardFunctions.spawnVanguardsAroundPlayer(serverLevel, serverPlayer, playerPos, vanguardCount, true, vanguardPositions, vanguards);
        SaveLoadUtils.setForcedPositionTag(serverPlayer, 4);
        String baseKey = "voidvanguards.message.vanguards.voidbornBaseDestroyed.";
        class_5250 speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.vanguard.name.leader", class_124.field_1079, true);
        int totalDelay = 40;
        int i = 1;
        while (i <= 8) {
            class_5250 messageTextComponent = class_2561.method_43471((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                if (i == 2) {
                    messageTextComponent = class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{class_2561.method_43471((String)"voidvanguards.voidborn.name").method_27692(class_124.field_1064)});
                } else if (i == 8) {
                    class_5250 lyraName = class_2561.method_43470((String)VanguardVariables.vanguardNames.get(0)).method_27692(class_124.field_1079);
                    messageTextComponent = class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{lyraName});
                    vanguards.get(0).method_5665((class_2561)lyraName);
                } else {
                    messageTextComponent = class_2561.method_43469((String)(baseKey + i), (Object[])new Object[]{serverPlayer.method_5477()});
                }
                rawMessage = messageTextComponent.getString();
            }
            class_124 messageColour = class_124.field_1068;
            if (i == 4) {
                messageColour = class_124.field_1063;
            }
            class_5250 messageComponent = i == 8 ? StoryUtil.getSpeakerComponent(VanguardVariables.vanguardNames.get(0), class_124.field_1079, false).method_27661().method_10852((class_2561)messageTextComponent.method_27692(messageColour)) : speakerComponent.method_27661().method_10852((class_2561)messageTextComponent.method_27692(messageColour));
            int delay = StoryUtil.getSentenceTickDelay((class_2561)messageComponent);
            int finalI = i++;
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)messageComponent, (finalI == 1 ? 1 : 0) != 0);
                if (finalI == 4) {
                    ItemFunctions.giveOrDropItemStack((class_1657)serverPlayer, (class_1799)new class_1799((class_1935)VanguardItems.ORBITAL_TRANSPONDER));
                }
            }, (int)totalDelay);
            totalDelay += delay;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            for (class_1309 vanguard : vanguards) {
                VanguardUtil.spawnTeleportParticles(serverLevel, vanguard.method_24515());
                vanguard.method_5650(class_1297.class_5529.field_26999);
            }
            SaveLoadUtils.removeForcedPositionTag(serverPlayer);
            ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.add(serverPlayer.method_5667());
            SaveLoadUtils.savePlayerData((class_1657)serverPlayer);
        }, (int)totalDelay);
    }
}

