/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_fabric.parts.vanguard.functions;

import com.mojang.authlib.GameProfile;
import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.EntityFunctions;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.collective_common_fabric.functions.TaskFunctions;
import com.natamus.collective_common_fabric.functions.TileEntityFunctions;
import com.natamus.voidvanguards_common_fabric.data.HeadData;
import com.natamus.voidvanguards_common_fabric.data.ServerSaveData;
import com.natamus.voidvanguards_common_fabric.parts.cosmos.functions.CosmosDimensionFunctions;
import com.natamus.voidvanguards_common_fabric.parts.story.functions.StoryFunctions;
import com.natamus.voidvanguards_common_fabric.parts.vanguard.data.VanguardVariables;
import com.natamus.voidvanguards_common_fabric.parts.vanguard.util.VanguardUtil;
import com.natamus.voidvanguards_common_fabric.parts.voidborn.util.VoidbornUtil;
import com.natamus.voidvanguards_common_fabric.registry.objects.VanguardItems;
import com.natamus.voidvanguards_common_fabric.util.SaveLoadUtils;
import com.natamus.voidvanguards_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1543;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2435;
import net.minecraft.class_2510;
import net.minecraft.class_2551;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5915;
import net.minecraft.class_8242;
import net.minecraft.class_9296;
import net.minecraft.server.MinecraftServer;

public class VanguardFunctions {
    public static void initialPostSkyShipEventTrigger(class_3218 serverLevel, class_3222 serverPlayer) {
        MessageFunctions.broadcastMessage((class_1937)serverLevel, (class_5250)class_2561.method_43469((String)"voidvanguards.message.skyship.server_trigger", (Object[])new Object[]{serverPlayer.method_5477().getString()}).method_27692(class_124.field_1065));
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.method_8503(), () -> VanguardFunctions.spawnInitialVanguardsAroundPlayer(serverLevel, serverPlayer), (int)100);
    }

    public static void spawnInitialVanguardsAroundPlayer(class_3218 serverLevel, class_3222 serverPlayer) {
        VanguardFunctions.spawnInitialVanguardsAroundPlayer(serverLevel, serverPlayer, serverPlayer.method_24515());
    }

    public static void spawnInitialVanguardsAroundPlayer(class_3218 serverLevel, class_3222 serverPlayer, class_2338 spawnPos) {
        int vanguardCount = 8;
        List<class_2338> vanguardPositions = VanguardUtil.getVanguardPositions(spawnPos, vanguardCount);
        List<class_1309> vanguards = VanguardUtil.getVanguardsToSummon((class_1937)serverLevel, vanguardCount);
        VanguardFunctions.spawnVanguardsAroundPlayer(serverLevel, serverPlayer, spawnPos, vanguardCount, true, vanguardPositions, vanguards);
        int i = 0;
        for (class_1309 vanguard : vanguards) {
            class_2338 rawSpawnPos = vanguardPositions.get(i);
            class_2338 vanguardSpawnPos = BlockPosFunctions.getSurfaceBlockPos((class_3218)serverLevel, (int)rawSpawnPos.method_10263(), (int)rawSpawnPos.method_10260());
            vanguard.method_5814((double)vanguardSpawnPos.method_10263() + 0.5, (double)vanguardSpawnPos.method_10264(), (double)vanguardSpawnPos.method_10260() + 0.5);
            if (vanguard instanceof class_1308) {
                ((class_1308)vanguard).method_5952(false);
            }
            serverLevel.method_8649((class_1297)vanguard);
            vanguard.method_5702(class_2183.class_2184.field_9851, serverPlayer.method_19538());
            VanguardUtil.spawnTeleportParticles(serverLevel, vanguardSpawnPos);
            ++i;
        }
        for (class_2338 torchPos : VanguardUtil.getTorchLocations(spawnPos)) {
            if (!serverLevel.method_8320(torchPos).method_26215()) continue;
            if (serverLevel.method_8320(torchPos.method_10074()).method_26215()) {
                serverLevel.method_8652(torchPos.method_10074(), class_2246.field_22092.method_9564(), 3);
                continue;
            }
            serverLevel.method_8652(torchPos, class_2246.field_22092.method_9564(), 3);
        }
        SaveLoadUtils.setForcedPositionTag(serverPlayer, 4);
        if (!Util.isCosmosDimension(serverLevel)) {
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.method_8503(), () -> {
                SaveLoadUtils.removeForcedPositionTag(serverPlayer);
                CosmosDimensionFunctions.teleportPlayerToVanguardStation(serverLevel, serverPlayer, true);
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.method_8503(), () -> {
                    for (class_1309 vanguard : vanguards) {
                        vanguard.method_5650(class_1297.class_5529.field_26999);
                    }
                }, (int)10);
            }, (int)100);
        } else {
            VanguardUtil.removeGrassBetweenVanguards((class_1937)serverLevel, vanguardPositions);
            StoryFunctions.processVanguardInitialCosmos(serverLevel, serverPlayer, spawnPos, vanguards);
        }
    }

    public static void spawnVanguardsAroundPlayer(class_3218 serverLevel, class_3222 serverPlayer, class_2338 spawnPos, int amount, boolean onSurface) {
        List<class_2338> vanguardPositions = VanguardUtil.getVanguardPositions(spawnPos, amount);
        List<class_1309> vanguards = VanguardUtil.getVanguardsToSummon((class_1937)serverLevel, amount);
        VanguardFunctions.spawnVanguardsAroundPlayer(serverLevel, serverPlayer, spawnPos, amount, onSurface, vanguardPositions, vanguards);
    }

    public static void spawnVanguardsAroundPlayer(class_3218 serverLevel, class_3222 serverPlayer, class_2338 spawnPos, int amount, boolean onSurface, List<class_2338> vanguardPositions, List<class_1309> vanguards) {
        int i = 0;
        for (class_1309 vanguard : vanguards) {
            class_2338 rawSpawnPos = vanguardPositions.get(i);
            class_2338 vanguardSpawnPos = onSurface ? BlockPosFunctions.getSurfaceBlockPos((class_3218)serverLevel, (int)rawSpawnPos.method_10263(), (int)rawSpawnPos.method_10260()) : rawSpawnPos.method_10062();
            vanguard.method_5814((double)vanguardSpawnPos.method_10263() + 0.5, (double)vanguardSpawnPos.method_10264(), (double)vanguardSpawnPos.method_10260() + 0.5);
            serverLevel.method_8649((class_1297)vanguard);
            vanguard.method_5702(class_2183.class_2184.field_9851, serverPlayer.method_19538());
            VanguardUtil.spawnTeleportParticles(serverLevel, vanguardSpawnPos);
            ++i;
        }
    }

    public static void createGravesAfterInitialEncounter(class_3218 serverLevel, class_3222 serverPlayer, class_2338 spawnPos, List<class_1309> vanguards) {
        for (class_1309 vanguard : vanguards) {
            vanguard.method_5650(class_1297.class_5529.field_26999);
        }
        class_2338 firstGravePos = spawnPos.method_10069(-1, 0, -16);
        ArrayList<class_2338> gravePositions = new ArrayList<class_2338>();
        for (int i = 0; i <= 3; ++i) {
            gravePositions.add(firstGravePos.method_10069(2 * i, 0, 0));
        }
        int n = 1;
        for (class_2338 gravePos : gravePositions) {
            for (class_2338 aroundPos : class_2338.method_10097((class_2338)gravePos.method_10069(-1, 0, -1), (class_2338)gravePos.method_10069(1, 0, 3))) {
                serverLevel.method_8652(aroundPos, class_2246.field_10124.method_9564(), 3);
            }
            serverLevel.method_8652(gravePos, (class_2680)class_2246.field_23878.method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11035), 3);
            class_2338 signPos = gravePos.method_10072();
            serverLevel.method_8501(signPos, (class_2680)class_2246.field_22107.method_9564().method_11657((class_2769)class_2551.field_11726, (Comparable)class_2350.field_11035));
            class_2586 class_25862 = serverLevel.method_8321(signPos);
            if (class_25862 instanceof class_2625) {
                class_2625 signBlockEntity = (class_2625)class_25862;
                class_8242 signText = signBlockEntity.method_49853();
                signText = signText.method_49857(1, (class_2561)class_2561.method_43470((String)VanguardVariables.vanguardNames.get(n)));
                signText = signText.method_49857(2, (class_2561)class_2561.method_43470((String)(String.valueOf(VanguardVariables.vanguardBirthYears.get(n)) + " - " + Util.getCurrentYearString())));
                signBlockEntity.method_49840(signText, true);
                TileEntityFunctions.updateTileEntity((class_1937)serverLevel, (class_2338)signPos, (class_2586)signBlockEntity);
            }
            class_2338 playerHeadPos = gravePos.method_10077(2);
            serverLevel.method_8652(playerHeadPos, (class_2680)class_2246.field_10432.method_9564().method_11657((class_2769)class_2435.field_11505, (Comparable)Integer.valueOf(8)), 3);
            class_2586 class_25863 = serverLevel.method_8321(playerHeadPos);
            if (class_25863 instanceof class_2631) {
                class_2631 skullBlockEntity = (class_2631)class_25863;
                GameProfile headGameProfile = HeadData.getHeadGameProfile(HeadData.HeadType.VANGUARD);
                if (headGameProfile != null) {
                    EntityFunctions.setSkullBlockOwner((class_2631)skullBlockEntity, (class_9296)new class_9296(headGameProfile));
                }
            }
            serverLevel.method_8652(gravePos.method_10074(), class_2246.field_23874.method_9564(), 3);
            serverLevel.method_8652(gravePos.method_10074().method_10072(), class_2246.field_10520.method_9564(), 3);
            serverLevel.method_8652(gravePos.method_10074().method_10077(2), class_2246.field_10520.method_9564(), 3);
            ++n;
        }
    }

    public static void generateRadioAtPlayerPosition(class_3222 serverPlayer) {
        VanguardFunctions.generateRadioAtPlayerPosition(serverPlayer, 2);
    }

    public static void generateRadioAtPlayerPosition(class_3222 serverPlayer, int n) {
        class_3218 serverLevel = serverPlayer.method_51469();
        class_243 eyePos = serverPlayer.method_33571();
        class_243 lookVec = serverPlayer.method_5720();
        class_2350 facing = serverPlayer.method_5735();
        for (int i = n; i <= 2; ++i) {
            class_2338 checkPos = class_2338.method_49638((class_2374)eyePos.method_1019(lookVec.method_1021((double)i)));
            if (!serverLevel.method_22347(checkPos)) continue;
            class_5915 frame = new class_5915((class_1937)serverLevel, checkPos, facing.method_10153());
            frame.method_6935(new class_1799((class_1935)VanguardItems.ORBITAL_RADIO));
            frame.method_5648(true);
            frame.method_5780("voidvanguards.tempframe");
            if (facing == class_2350.field_11036 || facing == class_2350.field_11033) {
                float yaw = class_3532.method_15393((float)serverPlayer.method_36454());
                int rotationIndex = class_3532.method_15375((float)((yaw + 180.0f) / 45.0f)) & 7;
                frame.method_6939(rotationIndex);
            }
            serverLevel.method_8649((class_1297)frame);
            VanguardUtil.spawnGenerationParticles(serverLevel, checkPos);
            if (n > 0 || i == 0) {
                MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)class_2561.method_43471((String)"item.voidvanguards.orbital_radio.spawned.front").method_27692(class_124.field_1078), (boolean)true);
            } else {
                MessageFunctions.sendMessage((class_1657)serverPlayer, (class_5250)class_2561.method_43471((String)"item.voidvanguards.orbital_radio.spawned.behind").method_27692(class_124.field_1078), (boolean)true);
            }
            return;
        }
        if (n > 0) {
            VanguardFunctions.generateRadioAtPlayerPosition(serverPlayer, -2);
        }
    }

    public static void processVanguardTreeTeleportVoidbase(class_3218 cosmosLevel, class_3222 serverPlayer) {
        MinecraftServer minecraftServer = cosmosLevel.method_8503();
        class_2338 bottomTreePos = VoidbornUtil.getVoidbornBaseSpawnPos(serverPlayer).method_10069(4, 0, 0);
        cosmosLevel.method_8652(bottomTreePos, class_2246.field_10124.method_9564(), 3);
        cosmosLevel.method_8652(bottomTreePos.method_10086(1), class_2246.field_10124.method_9564(), 3);
        cosmosLevel.method_8652(bottomTreePos.method_10086(2), class_2246.field_10124.method_9564(), 3);
        serverPlayer.method_5859((double)bottomTreePos.method_10263() + 0.5, (double)bottomTreePos.method_10264(), (double)bottomTreePos.method_10260() + 0.5);
        List nearbyVoidborn = cosmosLevel.method_8390(class_1543.class, serverPlayer.method_5829().method_1014(32.0), illager -> illager.method_5752().contains("voidvanguards.voidborn"));
        for (class_1543 voidborn : nearbyVoidborn) {
            Util.spawnLightning(cosmosLevel, voidborn.method_24515(), serverPlayer);
            voidborn.method_5650(class_1297.class_5529.field_26998);
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            List<class_2338> vanguardPositions = VanguardUtil.getVanguardPositions(bottomTreePos, 4);
            List<class_1309> vanguards = VanguardUtil.getVanguardsToSummon((class_1937)cosmosLevel, 4);
            for (class_2338 vanguardPos : vanguardPositions) {
                for (class_2338 nearbyPos : class_2338.method_10097((class_2338)vanguardPos.method_10069(-1, -1, -1), (class_2338)vanguardPos.method_10069(1, 1, 1))) {
                    if (!cosmosLevel.method_8320(nearbyPos).method_27852(class_2246.field_10036)) continue;
                    cosmosLevel.method_8650(nearbyPos, false);
                }
            }
            VanguardFunctions.spawnVanguardsAroundPlayer(cosmosLevel, serverPlayer, bottomTreePos, 4, false, vanguardPositions, vanguards);
            SaveLoadUtils.setForcedPositionTag(serverPlayer, 4);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> VanguardUtil.oblibirateTreeAbovePosition(cosmosLevel, bottomTreePos, 10, 2), (int)10);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> StoryFunctions.processVanguardsInVoidbornBase(serverPlayer.method_51469(), serverPlayer, vanguards), (int)20);
        }, (int)20);
    }

    public static void resetVanguardVariables(class_1657 player) {
        SaveLoadUtils.removeOldSaveTag(player);
        ServerSaveData.removeUUID(player.method_5667());
    }
}

