/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_forge.events;

import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.voidvanguards_common_forge.data.ServerSaveData;
import com.natamus.voidvanguards_common_forge.parts.cosmos.util.CosmosDimensionUtil;
import com.natamus.voidvanguards_common_forge.parts.story.functions.StoryFunctions;
import com.natamus.voidvanguards_common_forge.parts.vanguard.util.VanguardUtil;
import com.natamus.voidvanguards_common_forge.parts.voidborn.functions.VoidbornFunctions;
import com.natamus.voidvanguards_common_forge.util.SaveLoadUtils;
import com.natamus.voidvanguards_common_forge.util.Util;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VoidLivingEntityEvents {
    public static void onLivingEntityTick(Level level, LivingEntity livingEntity) {
        if (level.isClientSide) {
            return;
        }
        if (livingEntity instanceof Villager) {
            if (!livingEntity.getTags().contains("voidvanguards.vanguard")) {
                return;
            }
            List nearbyPlayers = level.getEntitiesOfClass(Player.class, livingEntity.getBoundingBox().inflate(10.0));
            if (!nearbyPlayers.isEmpty()) {
                Player nearestPlayer = (Player)nearbyPlayers.get(0);
                livingEntity.lookAt(EntityAnchorArgument.Anchor.EYES, nearestPlayer.position());
            }
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (serverPlayer.tickCount % 10 == 0) {
                Object forcedTag = null;
                for (String tag : serverPlayer.getTags()) {
                    if (tag.startsWith("voidvanguards.forceposition")) {
                        VanguardUtil.keepPlayersWithinVanguardCircle(serverPlayer, tag);
                        continue;
                    }
                    if (!tag.startsWith("voidvanguards.sendmessage")) continue;
                    String message = tag.split("--")[1];
                    MessageFunctions.sendMessage((Player)serverPlayer, (String)message, (ChatFormatting)ChatFormatting.DARK_GRAY, (boolean)true);
                    Util.removeTag(serverPlayer, tag);
                }
            }
            if (serverPlayer.tickCount % 20 == 0 && Util.isInCosmosDimension(serverPlayer) && CosmosDimensionUtil.playerIsInVoidbornBase(serverPlayer) && !ServerSaveData.get().triggeredVoidbornBaseStoryPlayerUUIDS.contains(serverPlayer.getUUID())) {
                VoidbornFunctions.checkVoidbornLeftForStoryTrigger(serverPlayer.serverLevel(), serverPlayer);
            }
        }
    }

    public static boolean onEntityDamage(Level level, Entity entity, DamageSource damageSource, float damageAmount) {
        AbstractIllager abstractIllager;
        Set tags;
        if (level.isClientSide) {
            return true;
        }
        Entity sourceEntity = damageSource.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (Util.isInCosmosDimension(serverPlayer) && damageSource.getMsgId().equals("lightningBolt")) {
                return false;
            }
        } else if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (villager.getTags().contains("voidvanguards.vanguard") && !villager.getTags().contains("voidvanguards.vulnerable")) {
                return false;
            }
        } else if (entity instanceof AbstractIllager && (tags = (abstractIllager = (AbstractIllager)entity).getTags()).contains("voidvanguards.voidborn_leader")) {
            if (tags.contains("voidvanguards.vulnerable") && !tags.contains("voidvanguards.attacked") && sourceEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)sourceEntity;
                StoryFunctions.processVoidbornLeaderAttacked(serverPlayer.serverLevel(), serverPlayer, (Mob)abstractIllager);
                return true;
            }
            return tags.contains("voidvanguards.vulnerable");
        }
        return true;
    }

    public static void onPlayerDeath(ServerPlayer player, DamageSource damageSource, float damageAmount) {
        SaveLoadUtils.removeForcedPositionTag(player);
    }
}

