/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_forge.parts.skyship.functions;

import com.natamus.collective_common_forge.implementations.networking.api.Dispatcher;
import com.natamus.voidvanguards_common_forge.config.ConfigHandler;
import com.natamus.voidvanguards_common_forge.data.ClientConstants;
import com.natamus.voidvanguards_common_forge.networking.packets.ToServerTriggerSkyShipEventPacket;
import com.natamus.voidvanguards_common_forge.parts.skyship.data.SkyShipPatterns;
import com.natamus.voidvanguards_common_forge.parts.skyship.data.SkyShipVariables;
import com.natamus.voidvanguards_common_forge.parts.skyship.util.SkyShipUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SkyShipFunctions {
    public static boolean isLookingAtSkyShip() {
        LocalPlayer player = ClientConstants.mc.player;
        if (!player.isUsingItem() || player.getUseItem().getItem() != Items.SPYGLASS) {
            return false;
        }
        long time = ClientConstants.mc.level.getGameTime();
        float partialTicks = ClientConstants.mc.getFrameTimeNs();
        float orbitAngle = (float)time * 0.001f;
        float sunAngle = SkyShipUtil.getShipSunAngle(ClientConstants.mc, partialTicks);
        Vector3f sunPos = new Vector3f((float)Math.sin(sunAngle), (float)Math.cos(sunAngle), 0.0f).normalize();
        Vector3f offset = new Vector3f((float)Math.cos(orbitAngle) * 15.0f, (float)Math.sin(orbitAngle) * 15.0f, 90.0f);
        Quaternionf rotToSun = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)sunPos);
        offset.rotate((Quaternionfc)rotToSun);
        Vector3f shipPos = new Vector3f((Vector3fc)sunPos).mul(100.0f).add((Vector3fc)offset);
        shipPos.y += 0.1f * (float)Math.sin((double)time * 0.08);
        Vector3f shipDirection = new Vector3f((Vector3fc)shipPos).normalize();
        return SkyShipFunctions.isShipVisible(shipDirection, (Player)player, partialTicks);
    }

    private static boolean isShipVisible(Vector3f shipDirection, Player player, float partialTicks) {
        float maxAngleDegrees;
        Vec3 lookDir = player.getViewVector(partialTicks);
        Vector3f playerLookDir = new Vector3f((float)lookDir.x, (float)lookDir.y, (float)lookDir.z);
        float dot = shipDirection.dot((Vector3fc)playerLookDir);
        float angle = (float)Math.acos(dot);
        float angleDegrees = (float)Math.toDegrees(angle);
        return angleDegrees <= (maxAngleDegrees = 2.0f);
    }

    public static void onLookingAtSkyShip() {
        LocalPlayer player = ClientConstants.mc.player;
        if (player == null) {
            return;
        }
        if (SkyShipVariables.triggeredSkyShipEvent) {
            return;
        }
        SkyShipVariables.focusedOnSkyShip = true;
        if (--SkyShipVariables.ticksLeftForMoreDetail == 0) {
            if (SkyShipVariables.skyShipDetailLevel == SkyShipPatterns.SHIP_PATTERNS.length - 1) {
                SkyShipFunctions.triggerSkyShipEvent((Player)player);
                return;
            }
            ++SkyShipVariables.skyShipDetailLevel;
            SkyShipVariables.ticksLeftForMoreDetail = ConfigHandler.ticksNeededForMoreSkyShipDetail;
            player.displayClientMessage((Component)Component.translatable((String)"voidvanguards.message.skyship.more_detailed").withStyle(ChatFormatting.GREEN), true);
            SkyShipVariables.sentFocusMessage = true;
        }
    }

    public static void triggerSkyShipEvent(Player player) {
        if (SkyShipVariables.triggeredSkyShipEvent) {
            return;
        }
        SkyShipVariables.triggeredSkyShipEvent = true;
        player.displayClientMessage((Component)Component.translatable((String)"voidvanguards.message.skyship.explosion").withStyle(ChatFormatting.BLUE), true);
        Dispatcher.sendToServer((Object)new ToServerTriggerSkyShipEventPacket());
    }

    public static void resetSkyShipVariables() {
        SkyShipVariables.skyShipVisible = false;
        SkyShipVariables.triggeredSkyShipEvent = false;
        SkyShipVariables.focusedOnSkyShip = false;
        SkyShipVariables.sentFocusMessage = false;
        SkyShipVariables.ticksLeftForMoreDetail = ConfigHandler.ticksNeededForMoreSkyShipDetail;
        SkyShipVariables.skyShipDetailLevel = 0;
    }
}

