/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_forge.parts.story.functions;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.collective_common_forge.functions.TaskFunctions;
import com.natamus.collective_common_forge.implementations.networking.api.Dispatcher;
import com.natamus.collective_common_forge.services.Services;
import com.natamus.voidvanguards_common_forge.data.ServerSaveData;
import com.natamus.voidvanguards_common_forge.networking.packets.ToClientQueueScreenFlickerEffectPacket;
import com.natamus.voidvanguards_common_forge.parts.cosmos.functions.CosmosDimensionFunctions;
import com.natamus.voidvanguards_common_forge.parts.story.util.StoryUtil;
import com.natamus.voidvanguards_common_forge.parts.vanguard.data.VanguardVariables;
import com.natamus.voidvanguards_common_forge.parts.vanguard.functions.VanguardFunctions;
import com.natamus.voidvanguards_common_forge.parts.vanguard.util.VanguardUtil;
import com.natamus.voidvanguards_common_forge.parts.voidborn.data.VoidbornConstants;
import com.natamus.voidvanguards_common_forge.parts.voidborn.functions.VoidbornFunctions;
import com.natamus.voidvanguards_common_forge.parts.voidborn.util.VoidbornUtil;
import com.natamus.voidvanguards_common_forge.registry.block.CosmosPortalBlock;
import com.natamus.voidvanguards_common_forge.registry.objects.VanguardItems;
import com.natamus.voidvanguards_common_forge.util.SaveLoadUtils;
import com.natamus.voidvanguards_common_forge.util.Util;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class StoryFunctions {
    public static void processVanguardInitialCosmos(ServerLevel serverLevel, ServerPlayer serverPlayer, BlockPos spawnPos, List<LivingEntity> vanguards) {
        String baseKey = "voidvanguards.message.vanguards.cosmos.initial.";
        MutableComponent speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.vanguard.name.leader", ChatFormatting.DARK_RED, true);
        int flickerDelay = -1;
        int totalDelay = 20;
        int lastDelay = 0;
        for (int i = 1; i <= 12; ++i) {
            MutableComponent messageTextComponent = Component.translatable((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                messageTextComponent = i == 8 ? Component.translatable((String)(baseKey + i), (Object[])new Object[]{Component.translatable((String)"voidvanguards.voidborn.name").withStyle(ChatFormatting.DARK_PURPLE)}) : Component.translatable((String)(baseKey + i), (Object[])new Object[]{serverPlayer.getName()});
                rawMessage = messageTextComponent.getString();
            }
            ChatFormatting messageColour = StoryUtil.getMessageColour(rawMessage, "...", ChatFormatting.WHITE, ChatFormatting.RED);
            if (flickerDelay <= 0 && messageColour.equals((Object)ChatFormatting.RED)) {
                flickerDelay = totalDelay;
            }
            MutableComponent messageComponent = speakerComponent.copy().append((Component)messageTextComponent.withStyle(messageColour));
            int delay = StoryUtil.getSentenceTickDelay((Component)messageComponent);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.getServer(), () -> MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)messageComponent), (int)totalDelay);
            totalDelay += delay;
            lastDelay = delay;
        }
        Dispatcher.sendToClient((Object)new ToClientQueueScreenFlickerEffectPacket(flickerDelay, totalDelay - lastDelay - flickerDelay), (ServerPlayer)serverPlayer);
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.getServer(), () -> {
            SaveLoadUtils.removeForcedPositionTag(serverPlayer);
            if (Util.teleportPlayerToOriginalPosition(serverPlayer)) {
                MinecraftServer minecraftServer = serverLevel.getServer();
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> VanguardFunctions.createGravesAfterInitialEncounter(serverLevel, serverPlayer, spawnPos, vanguards), (int)1);
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> VanguardFunctions.generateRadioAtPlayerPosition(serverPlayer), (int)100);
                MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"voidvanguards.message.vanguards.home.initial.1").withStyle(ChatFormatting.GOLD), (boolean)true);
            }
        }, (int)(totalDelay - lastDelay));
    }

    public static void processUsingOrbitalRadio(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        MinecraftServer minecraftServer = serverLevel.getServer();
        UUID playerUUID = serverPlayer.getUUID();
        String baseKey = "voidvanguards.message.vanguards.radio.initial.";
        MutableComponent speakerComponent = StoryUtil.getSpeakerComponent("item.voidvanguards.orbital_radio", ChatFormatting.AQUA, true);
        if (!ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.containsKey(playerUUID)) {
            BlockPos voidbornBaseBlockPos = Util.getRANDOMVoidbornCosmosGateCoordinates(serverLevel, serverPlayer);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> VoidbornFunctions.generateVoidbornCosmosGate(serverLevel, serverPlayer, voidbornBaseBlockPos), (int)0);
            int totalDelay = 20;
            for (int i = 1; i <= 14; ++i) {
                MutableComponent messageTextComponent = Component.translatable((String)(baseKey + i));
                String rawMessage = messageTextComponent.getString();
                if (rawMessage.contains("%s")) {
                    messageTextComponent = i == 8 ? Component.translatable((String)(baseKey + i), (Object[])new Object[]{Component.translatable((String)"voidvanguards.voidborn.name").withStyle(ChatFormatting.DARK_PURPLE)}) : (i == 11 ? Component.translatable((String)(baseKey + i), (Object[])new Object[]{Component.literal((String)(voidbornBaseBlockPos.getX() + ", " + voidbornBaseBlockPos.getY() + ", " + voidbornBaseBlockPos.getZ())).withStyle(ChatFormatting.GOLD)}) : Component.translatable((String)(baseKey + i), (Object[])new Object[]{serverPlayer.getName()}));
                    rawMessage = messageTextComponent.getString();
                }
                ChatFormatting messageColour = ChatFormatting.WHITE;
                MutableComponent messageComponent = speakerComponent.copy().append((Component)messageTextComponent.withStyle(messageColour));
                int delay = StoryUtil.getSentenceTickDelay((Component)messageComponent);
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)messageComponent), (int)totalDelay);
                totalDelay += delay;
            }
            ServerSaveData.get().answeredRadioPlayerUUIDS.add(playerUUID);
            SaveLoadUtils.savePlayerData((Player)serverPlayer);
        } else {
            Pair<ResourceKey<Level>, BlockPos> voidbornBasePosPair = ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.get(playerUUID);
            ResourceKey levelResourceKey = (ResourceKey)voidbornBasePosPair.getFirst();
            BlockPos voidbornBasePos = (BlockPos)voidbornBasePosPair.getSecond();
            MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"voidvanguards.message.vanguards.radio.coordinates.1"));
            MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"voidvanguards.message.vanguards.radio.coordinates.2", (Object[])new Object[]{Component.literal((String)(voidbornBasePos.getX() + ", " + voidbornBasePos.getY() + ", " + voidbornBasePos.getZ())).withStyle(ChatFormatting.GOLD)}));
        }
    }

    public static void processInitialVoidbornLeaderEncounter(ServerLevel serverLevel, ServerPlayer serverPlayer, Mob voidbornLeader) {
        MinecraftServer minecraftServer = serverLevel.getServer();
        ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.add(serverPlayer.getUUID());
        SaveLoadUtils.savePlayerData((Player)serverPlayer);
        for (Mob mob : serverLevel.getEntitiesOfClass(Mob.class, voidbornLeader.getBoundingBox().inflate(120.0))) {
            if (mob instanceof Vex) {
                mob.remove(Entity.RemovalReason.DISCARDED);
                continue;
            }
            if (!mob.getTags().contains("voidvanguards.voidborn")) continue;
            mob.addTag("voidvanguards.notarget");
            mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
            mob.setTarget(null);
        }
        String baseKey = "voidvanguards.message.voidborn.initial.";
        MutableComponent speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.voidborn.name.leader", ChatFormatting.DARK_PURPLE, true);
        int totalDelay = 20;
        int lastDelay = 0;
        for (int i = 1; i <= 11; ++i) {
            MutableComponent messageTextComponent = Component.translatable((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                messageTextComponent = Component.translatable((String)(baseKey + i), (Object[])new Object[]{serverPlayer.getName()});
                rawMessage = messageTextComponent.getString();
            }
            ChatFormatting messageColour = i == 8 ? ChatFormatting.RED : (i == 11 ? ChatFormatting.GRAY : ChatFormatting.WHITE);
            MutableComponent messageComponent = !rawMessage.startsWith(" ~") ? speakerComponent.copy().append((Component)messageTextComponent.withStyle(messageColour)) : messageTextComponent.withStyle(messageColour);
            int delay = StoryUtil.getSentenceTickDelay((Component)messageComponent);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)messageComponent, (boolean)messageColour.equals((Object)ChatFormatting.GRAY)), (int)totalDelay);
            totalDelay += delay;
            lastDelay = delay;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> voidbornLeader.addTag("voidvanguards.vulnerable"), (int)(totalDelay - lastDelay));
    }

    public static void processVoidbornLeaderGiveRadio(ServerLevel serverLevel, ServerPlayer serverPlayer, Mob voidbornLeader, ItemStack orbitalRadioStack) {
        MinecraftServer minecraftServer = serverLevel.getServer();
        UUID playerUUID = serverPlayer.getUUID();
        if (ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.contains(playerUUID)) {
            return;
        }
        ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.add(playerUUID);
        SaveLoadUtils.savePlayerData((Player)serverPlayer);
        SaveLoadUtils.removeForcedPositionTag(serverPlayer);
        orbitalRadioStack.shrink(1);
        String baseKey = "voidvanguards.message.voidborn.givenradio.";
        MutableComponent speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.voidborn.name.leader", ChatFormatting.DARK_PURPLE, true);
        int totalDelay = 0;
        int i = 1;
        while (i <= 3) {
            MutableComponent messageTextComponent = Component.translatable((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                messageTextComponent = Component.translatable((String)(baseKey + i), (Object[])new Object[]{serverPlayer.getName()});
                rawMessage = messageTextComponent.getString();
            }
            ChatFormatting messageColour = ChatFormatting.WHITE;
            MutableComponent messageComponent = speakerComponent.copy().append((Component)messageTextComponent.withStyle(messageColour));
            int delay = StoryUtil.getSentenceTickDelay((Component)messageComponent);
            int finalI = i++;
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)messageComponent, (finalI == 1 ? 1 : 0) != 0), (int)totalDelay);
            totalDelay += delay;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)speakerComponent.copy().append((Component)Component.translatable((String)(baseKey + "4")).withStyle(ChatFormatting.DARK_PURPLE)), (boolean)true);
            for (Mob mob : serverLevel.getEntitiesOfClass(Mob.class, serverPlayer.getBoundingBox().inflate(120.0))) {
                Set tags = mob.getTags();
                if (!tags.contains("voidvanguards.voidborn") || tags.contains("voidvanguards.voidborn_leader")) continue;
                VanguardUtil.spawnTeleportParticles(serverLevel, mob.blockPosition());
                mob.remove(Entity.RemovalReason.DISCARDED);
            }
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                VanguardUtil.spawnTeleportParticles(serverLevel, voidbornLeader.blockPosition());
                voidbornLeader.remove(Entity.RemovalReason.DISCARDED);
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                    CosmosDimensionFunctions.teleportPlayerToVanguardStation(serverLevel, serverPlayer, false);
                    StoryFunctions.processPostGivingRadioVanguardStation(Util.getCosmosLevel(serverLevel.getServer()), serverPlayer);
                }, (int)20);
            }, (int)20);
        }, (int)(totalDelay + 100));
    }

    public static void processVoidbornLeaderAttacked(ServerLevel serverLevel, ServerPlayer serverPlayer, Mob voidbornLeader) {
        MinecraftServer minecraftServer = serverLevel.getServer();
        voidbornLeader.addTag("voidvanguards.attacked");
        for (Mob mob : serverLevel.getEntitiesOfClass(Mob.class, voidbornLeader.getBoundingBox().inflate(120.0))) {
            if (!mob.getTags().contains("voidvanguards.voidborn")) {
                return;
            }
            mob.removeTag("voidvanguards.notarget");
            float movementValue = VoidbornConstants.voidbornMovementSpeeds.get(mob.getType()).floatValue();
            mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)movementValue);
        }
        SaveLoadUtils.removeForcedPositionTag(serverPlayer);
        String baseKey = "voidvanguards.message.voidborn.attacked.";
        MutableComponent speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.voidborn.name.leader", ChatFormatting.DARK_PURPLE, true);
        int totalDelay = 0;
        int i = 1;
        while (i <= 4) {
            MutableComponent messageTextComponent = Component.translatable((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                messageTextComponent = Component.translatable((String)(baseKey + i), (Object[])new Object[]{serverPlayer.getName()});
                rawMessage = messageTextComponent.getString();
            }
            ChatFormatting messageColour = i == 1 ? ChatFormatting.RED : (i == 4 ? ChatFormatting.GRAY : ChatFormatting.WHITE);
            MutableComponent messageComponent = !rawMessage.startsWith(" ~") ? speakerComponent.copy().append((Component)messageTextComponent.withStyle(messageColour)) : messageTextComponent.withStyle(messageColour);
            int delay = StoryUtil.getSentenceTickDelay((Component)messageComponent);
            int finalI = i++;
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)messageComponent, (finalI == 1 || messageColour.equals((Object)ChatFormatting.GRAY) ? 1 : 0) != 0), (int)totalDelay);
            totalDelay += delay;
        }
    }

    public static void processVanguardsInVoidbornBase(ServerLevel serverLevel, ServerPlayer serverPlayer, List<LivingEntity> vanguards) {
        MinecraftServer minecraftServer = serverLevel.getServer();
        String baseKey = "voidvanguards.message.vanguards.voidbornBase.";
        MutableComponent speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.vanguard.name.leader", ChatFormatting.DARK_RED, true);
        int totalDelay = 20;
        int i = 1;
        while (i <= 6) {
            MutableComponent messageTextComponent = Component.translatable((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                messageTextComponent = i == 2 ? Component.translatable((String)(baseKey + i), (Object[])new Object[]{Component.translatable((String)"voidvanguards.voidborn.name").withStyle(ChatFormatting.DARK_PURPLE)}) : Component.translatable((String)(baseKey + i), (Object[])new Object[]{serverPlayer.getName()});
                rawMessage = messageTextComponent.getString();
            }
            ChatFormatting messageColour = ChatFormatting.WHITE;
            MutableComponent messageComponent = speakerComponent.copy().append((Component)messageTextComponent.withStyle(messageColour));
            int delay = StoryUtil.getSentenceTickDelay((Component)messageComponent);
            int finalI = i++;
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)messageComponent, (finalI == 1 ? 1 : 0) != 0), (int)totalDelay);
            totalDelay += delay;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            SaveLoadUtils.removeForcedPositionTag(serverPlayer);
            ServerLevel overworldLevel = minecraftServer.overworld();
            Pair<ResourceKey<Level>, BlockPos> cosmosGatePair = ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.get(serverPlayer.getUUID());
            BlockPos gatePos = cosmosGatePair == null ? Util.getRANDOMVoidbornCosmosGateCoordinates(overworldLevel, serverPlayer) : (BlockPos)cosmosGatePair.getSecond();
            Services.TELEPORT.teleportEntity((Entity)serverPlayer, overworldLevel, gatePos);
            for (LivingEntity vanguard : vanguards) {
                vanguard.remove(Entity.RemovalReason.DISCARDED);
            }
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                for (BlockPos aroundPos : BlockPos.betweenClosed((BlockPos)gatePos.offset(-10, -10, -10), (BlockPos)gatePos.offset(10, 10, 10))) {
                    if (!(overworldLevel.getBlockState(aroundPos).getBlock() instanceof CosmosPortalBlock)) continue;
                    overworldLevel.setBlock(aroundPos, Blocks.AIR.defaultBlockState(), 3);
                }
            }, (int)50);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> StoryFunctions.processPostVoidbornBaseVanguardLeader(overworldLevel, serverPlayer), (int)200);
        }, (int)totalDelay);
    }

    public static void processPostGivingRadioVanguardStation(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        MinecraftServer minecraftServer = serverLevel.getServer();
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            int vanguardCount = 4;
            List<BlockPos> vanguardPositions = VanguardUtil.getVanguardPositions(serverPlayer.blockPosition(), vanguardCount);
            List<LivingEntity> vanguards = VanguardUtil.getVanguardsToSummon((Level)serverLevel, vanguardCount);
            VanguardFunctions.spawnVanguardsAroundPlayer(serverLevel, serverPlayer, serverPlayer.blockPosition(), vanguardCount, true, vanguardPositions, vanguards);
            for (LivingEntity vanguard : vanguards) {
                vanguard.addTag("voidvanguards.vulnerable");
            }
            String baseKey = "voidvanguards.message.voidborn.vanguardStation.";
            MutableComponent vanguardSpeakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.vanguard.name.leader", ChatFormatting.DARK_RED, true);
            MutableComponent voidbornSpeakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.voidborn.name.leader", ChatFormatting.DARK_PURPLE, true);
            int totalDelay = 20;
            for (int i = 1; i <= 4; ++i) {
                MutableComponent messageTextComponent = Component.translatable((String)(baseKey + i));
                String rawMessage = messageTextComponent.getString();
                if (rawMessage.contains("%s")) {
                    messageTextComponent = Component.translatable((String)(baseKey + i), (Object[])new Object[]{serverPlayer.getName()});
                    rawMessage = messageTextComponent.getString();
                }
                ChatFormatting messageColour = StoryUtil.getMessageColour(rawMessage, "...", ChatFormatting.WHITE, ChatFormatting.RED);
                MutableComponent messageComponent = vanguardSpeakerComponent.copy().append((Component)messageTextComponent.withStyle(messageColour));
                int delay = StoryUtil.getSentenceTickDelay((Component)messageComponent);
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)messageComponent), (int)totalDelay);
                totalDelay += delay;
            }
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                BlockPos voidbornLeaderPos = serverPlayer.blockPosition().north();
                Mob voidbornLeader = VoidbornUtil.getVoidbornLeader(serverLevel, voidbornLeaderPos);
                voidbornLeader.addTag("voidvanguards.notarget");
                serverLevel.addFreshEntity((Entity)voidbornLeader);
                VanguardUtil.spawnTeleportParticles(serverLevel, voidbornLeaderPos);
                int newTotalDelay = 20;
                int i = 5;
                while (i <= 8) {
                    MutableComponent messageTextComponent = Component.translatable((String)(baseKey + i));
                    String rawMessage = messageTextComponent.getString();
                    if (rawMessage.contains("%s")) {
                        messageTextComponent = Component.translatable((String)(baseKey + i), (Object[])new Object[]{serverPlayer.getName()});
                        rawMessage = messageTextComponent.getString();
                    }
                    ChatFormatting messageColour = StoryUtil.getMessageColour(rawMessage, "...", ChatFormatting.WHITE, ChatFormatting.RED);
                    MutableComponent messageComponent = voidbornSpeakerComponent.copy().append((Component)messageTextComponent.withStyle(messageColour));
                    int delay = StoryUtil.getSentenceTickDelay((Component)messageComponent);
                    int finalI = i++;
                    TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)messageComponent, (finalI == 5 ? 1 : 0) != 0), (int)newTotalDelay);
                    newTotalDelay += delay;
                }
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                    Registry enchantmentRegistry = minecraftServer.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
                    for (LivingEntity vanguard : vanguards) {
                        vanguard.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.5);
                        for (int n = 1; n <= 4; ++n) {
                            Mob voidborn = VoidbornUtil.getVoidbornMob(serverLevel, vanguard.blockPosition(), (Registry<Enchantment>)enchantmentRegistry, false);
                            voidborn.setPos(voidborn.getX() - (double)n, voidborn.getY(), voidborn.getZ() + (double)n);
                            serverLevel.addFreshEntity((Entity)voidborn);
                        }
                    }
                    TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                        int newNewTotalDelay = 0;
                        for (int i = 9; i <= 11; ++i) {
                            MutableComponent messageTextComponent = Component.translatable((String)(baseKey + i));
                            String rawMessage = messageTextComponent.getString();
                            if (rawMessage.contains("%s")) {
                                messageTextComponent = Component.translatable((String)(baseKey + i), (Object[])new Object[]{serverPlayer.getName()});
                                rawMessage = messageTextComponent.getString();
                            }
                            ChatFormatting messageColour = StoryUtil.getMessageColour(rawMessage, "...", ChatFormatting.WHITE, ChatFormatting.RED);
                            MutableComponent messageComponent = voidbornSpeakerComponent.copy().append((Component)messageTextComponent.withStyle(messageColour));
                            int delay = StoryUtil.getSentenceTickDelay((Component)messageComponent);
                            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)messageComponent), (int)newNewTotalDelay);
                            newNewTotalDelay += delay;
                        }
                        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                            ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.add(serverPlayer.getUUID());
                            SaveLoadUtils.savePlayerData((Player)serverPlayer);
                            CosmosDimensionFunctions.teleportPlayerToVoidbornBase(serverPlayer.serverLevel(), serverPlayer);
                            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                                MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"voidvanguards.message.voidborn.endAsteroid.1").withStyle(ChatFormatting.DARK_GREEN), (boolean)true);
                                MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"voidvanguards.message.voidborn.endAsteroid.2").withStyle(ChatFormatting.DARK_GRAY));
                            }, (int)10);
                        }, (int)newNewTotalDelay);
                    }, (int)200);
                }, (int)newTotalDelay);
            }, (int)totalDelay);
        }, (int)10);
    }

    public static void processPostVoidbornBaseVanguardLeader(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        MinecraftServer minecraftServer = serverLevel.getServer();
        int vanguardCount = 1;
        BlockPos playerPos = serverPlayer.blockPosition();
        List<BlockPos> vanguardPositions = VanguardUtil.getVanguardPositions(playerPos, vanguardCount);
        List<LivingEntity> vanguards = VanguardUtil.getVanguardsToSummon((Level)serverLevel, vanguardCount);
        VanguardFunctions.spawnVanguardsAroundPlayer(serverLevel, serverPlayer, playerPos, vanguardCount, true, vanguardPositions, vanguards);
        SaveLoadUtils.setForcedPositionTag(serverPlayer, 4);
        String baseKey = "voidvanguards.message.vanguards.voidbornBaseDestroyed.";
        MutableComponent speakerComponent = StoryUtil.getSpeakerComponent("voidvanguards.vanguard.name.leader", ChatFormatting.DARK_RED, true);
        int totalDelay = 40;
        int i = 1;
        while (i <= 8) {
            MutableComponent messageTextComponent = Component.translatable((String)(baseKey + i));
            String rawMessage = messageTextComponent.getString();
            if (rawMessage.contains("%s")) {
                if (i == 2) {
                    messageTextComponent = Component.translatable((String)(baseKey + i), (Object[])new Object[]{Component.translatable((String)"voidvanguards.voidborn.name").withStyle(ChatFormatting.DARK_PURPLE)});
                } else if (i == 8) {
                    MutableComponent lyraName = Component.literal((String)VanguardVariables.vanguardNames.get(0)).withStyle(ChatFormatting.DARK_RED);
                    messageTextComponent = Component.translatable((String)(baseKey + i), (Object[])new Object[]{lyraName});
                    vanguards.get(0).setCustomName((Component)lyraName);
                } else {
                    messageTextComponent = Component.translatable((String)(baseKey + i), (Object[])new Object[]{serverPlayer.getName()});
                }
                rawMessage = messageTextComponent.getString();
            }
            ChatFormatting messageColour = ChatFormatting.WHITE;
            if (i == 4) {
                messageColour = ChatFormatting.DARK_GRAY;
            }
            MutableComponent messageComponent = i == 8 ? StoryUtil.getSpeakerComponent(VanguardVariables.vanguardNames.get(0), ChatFormatting.DARK_RED, false).copy().append((Component)messageTextComponent.withStyle(messageColour)) : speakerComponent.copy().append((Component)messageTextComponent.withStyle(messageColour));
            int delay = StoryUtil.getSentenceTickDelay((Component)messageComponent);
            int finalI = i++;
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)messageComponent, (finalI == 1 ? 1 : 0) != 0);
                if (finalI == 4) {
                    ItemFunctions.giveOrDropItemStack((Player)serverPlayer, (ItemStack)new ItemStack((ItemLike)VanguardItems.ORBITAL_TRANSPONDER));
                }
            }, (int)totalDelay);
            totalDelay += delay;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            for (LivingEntity vanguard : vanguards) {
                VanguardUtil.spawnTeleportParticles(serverLevel, vanguard.blockPosition());
                vanguard.remove(Entity.RemovalReason.DISCARDED);
            }
            SaveLoadUtils.removeForcedPositionTag(serverPlayer);
            ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.add(serverPlayer.getUUID());
            SaveLoadUtils.savePlayerData((Player)serverPlayer);
        }, (int)totalDelay);
    }
}

