/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_forge.parts.voidborn.functions;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.collective_common_forge.functions.TaskFunctions;
import com.natamus.collective_common_forge.functions.TileEntityFunctions;
import com.natamus.collective_common_forge.schematic.ParseSchematicFile;
import com.natamus.collective_common_forge.schematic.ParsedSchematicObject;
import com.natamus.collective_common_forge.services.Services;
import com.natamus.voidvanguards_common_forge.data.ServerSaveData;
import com.natamus.voidvanguards_common_forge.parts.story.functions.StoryFunctions;
import com.natamus.voidvanguards_common_forge.parts.vanguard.functions.VanguardFunctions;
import com.natamus.voidvanguards_common_forge.parts.voidborn.data.VoidbornConstants;
import com.natamus.voidvanguards_common_forge.parts.voidborn.util.VoidbornUtil;
import com.natamus.voidvanguards_common_forge.util.SaveLoadUtils;
import com.natamus.voidvanguards_common_forge.util.Util;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class VoidbornFunctions {
    private static final HashMap<UUID, Integer> skipCheck = new HashMap();

    public static void generateVoidbornCosmosGate(ServerLevel serverLevel, ServerPlayer serverPlayer, BlockPos middlePos) {
        MinecraftServer minecraftServer = serverLevel.getServer();
        ServerLevel overworldLevel = minecraftServer.overworld();
        InputStream schematicInputstream = Util.getSchematicsInputStream(minecraftServer, "cosmos_gate");
        if (schematicInputstream == null) {
            return;
        }
        ParsedSchematicObject parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)schematicInputstream, (Level)overworldLevel, (BlockPos)middlePos, (int)-1, (boolean)false);
        if (!parsedSchematicObject.parsedCorrectly) {
            return;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            for (Pair blockPair : parsedSchematicObject.blocks) {
                overworldLevel.setBlock((BlockPos)blockPair.getFirst(), (BlockState)blockPair.getSecond(), 3);
            }
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                Registry enchantmentRegistry = overworldLevel.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
                for (BlockPos blockEntityPos : parsedSchematicObject.blockEntityPositions) {
                    BlockEntity blockEntity = overworldLevel.getBlockEntity(blockEntityPos);
                    if (blockEntity == null) continue;
                    BlockState blockState = overworldLevel.getBlockState(blockEntityPos);
                    Block block = blockState.getBlock();
                    if (block.equals(Blocks.CRIMSON_SIGN)) {
                        VoidbornUtil.replaceSignWithVoidbornMob(overworldLevel, blockEntityPos, (Registry<Enchantment>)enchantmentRegistry);
                        continue;
                    }
                    if (!block.equals(Blocks.CHEST)) continue;
                    VoidbornUtil.fillChestWithItems(overworldLevel, blockEntity, blockEntityPos, blockState, (Registry<Enchantment>)enchantmentRegistry);
                }
                UUID playerUUID = serverPlayer.getUUID();
                ServerSaveData.get().voidbornGateGeneratedPlayerUUIDS.add(playerUUID);
                ServerSaveData.get().voidbornCosmosGatePositionPlayerUUIDS.put(playerUUID, (Pair<ResourceKey<Level>, BlockPos>)Pair.of((Object)overworldLevel.dimension(), (Object)middlePos));
                SaveLoadUtils.savePlayerData((Player)serverPlayer);
            }, (int)0);
        }, (int)0);
    }

    public static void prepareCosmosVoidbornBase(ServerLevel cosmosLevel, ServerPlayer serverPlayer, BlockPos voidbornCosmosBasePos, BlockPos spawnPos) {
        MinecraftServer minecraftServer = cosmosLevel.getServer();
        InputStream schematicInputstream = Util.getSchematicsInputStream(minecraftServer, "enemy_base_orbit");
        if (schematicInputstream == null) {
            return;
        }
        ParsedSchematicObject parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)schematicInputstream, (Level)cosmosLevel, (BlockPos)voidbornCosmosBasePos, (int)-54, (boolean)false);
        if (!parsedSchematicObject.parsedCorrectly) {
            return;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            for (Pair blockPair : parsedSchematicObject.blocks) {
                cosmosLevel.setBlock((BlockPos)blockPair.getFirst(), (BlockState)blockPair.getSecond(), 3);
            }
            VoidbornFunctions.generateRadarStructure(cosmosLevel, serverPlayer, voidbornCosmosBasePos);
            BlockPos teleportBackButtonPos = VoidbornUtil.getTeleportBackButtonPosition(serverPlayer);
            cosmosLevel.setBlock(teleportBackButtonPos, (BlockState)Blocks.WARPED_BUTTON.defaultBlockState().setValue((Property)ButtonBlock.FACING, (Comparable)Direction.WEST), 3);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                Registry enchantmentRegistry = cosmosLevel.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
                for (BlockPos entityBlockPos : parsedSchematicObject.blockEntityPositions) {
                    if (!cosmosLevel.getBlockState(entityBlockPos).getBlock().equals(Blocks.CRIMSON_SIGN)) continue;
                    VoidbornUtil.replaceSignWithVoidbornMob(cosmosLevel, entityBlockPos, (Registry<Enchantment>)enchantmentRegistry);
                }
                ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.add(serverPlayer.getUUID());
                SaveLoadUtils.savePlayerData((Player)serverPlayer);
                Services.TELEPORT.teleportEntity((Entity)serverPlayer, cosmosLevel, spawnPos);
                Util.removeTag(serverPlayer, "voidvanguards.triggeredEntityInside");
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
                    for (ItemEntity itemEntity : cosmosLevel.getEntitiesOfClass(ItemEntity.class, new AABB(spawnPos).inflate(120.0), e -> true)) {
                        itemEntity.discard();
                    }
                }, (int)10);
            }, (int)0);
        }, (int)0);
    }

    public static void generateRadarStructure(ServerLevel serverLevel, ServerPlayer serverPlayer, BlockPos voidbornCosmosBasePos) {
        MinecraftServer minecraftServer = serverLevel.getServer();
        BlockPos voidbornBaseBlockPos = Util.getRANDOMVoidbornCosmosGateCoordinates(serverLevel, serverPlayer);
        BlockPos radarPos = voidbornCosmosBasePos.offset(-26, 7, -37);
        InputStream schematicInputstream = Util.getSchematicsInputStream(minecraftServer, "radar");
        if (schematicInputstream == null) {
            return;
        }
        ParsedSchematicObject parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)schematicInputstream, (Level)serverLevel, (BlockPos)radarPos, (int)0, (boolean)true);
        if (!parsedSchematicObject.parsedCorrectly) {
            return;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            for (Pair blockPair : parsedSchematicObject.blocks) {
                serverLevel.setBlock((BlockPos)blockPair.getFirst(), (BlockState)blockPair.getSecond(), 3);
            }
            BlockPos signPos = radarPos.offset(-2, 2, 0);
            serverLevel.setBlockAndUpdate(signPos, (BlockState)Blocks.WARPED_WALL_SIGN.defaultBlockState().setValue((Property)WallSignBlock.FACING, (Comparable)Direction.WEST));
            BlockEntity patt0$temp = serverLevel.getBlockEntity(signPos);
            if (patt0$temp instanceof SignBlockEntity) {
                SignBlockEntity signBlockEntity = (SignBlockEntity)patt0$temp;
                SignText signText = signBlockEntity.getFrontText();
                signText = signText.setMessage(0, (Component)Component.translatable((String)"voidvanguards.message.voidborn.base.radarSign.text.0").withStyle(ChatFormatting.WHITE));
                signText = signText.setMessage(1, (Component)Component.translatable((String)"voidvanguards.message.voidborn.base.radarSign.text.1").withStyle(ChatFormatting.WHITE));
                signText = signText.setMessage(2, (Component)Component.translatable((String)"voidvanguards.message.voidborn.base.radarSign.text.2").withStyle(ChatFormatting.WHITE));
                signText = signText.setMessage(3, (Component)Component.translatable((String)"voidvanguards.message.voidborn.base.radarSign.text.3").withStyle(ChatFormatting.WHITE));
                signBlockEntity.setText(signText, true);
                TileEntityFunctions.updateTileEntity((Level)serverLevel, (BlockPos)signPos, (BlockEntity)signBlockEntity);
            }
            BlockPos leverPos = signPos.offset(0, -1, 0);
            serverLevel.setBlock(leverPos, (BlockState)Blocks.LEVER.defaultBlockState().setValue((Property)LeverBlock.FACING, (Comparable)Direction.WEST), 3);
        }, (int)0);
    }

    public static void checkVoidbornLeftForStoryTrigger(ServerLevel cosmosLevel, ServerPlayer serverPlayer) {
        if (cosmosLevel.getDifficulty().equals((Object)Difficulty.PEACEFUL)) {
            return;
        }
        if (!Util.isInCosmosDimension(serverPlayer)) {
            return;
        }
        UUID playerUUID = serverPlayer.getUUID();
        if (ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.contains(playerUUID)) {
            return;
        }
        if (ServerSaveData.get().triggeredVoidbornLeaderPlayerUUIDS.contains(playerUUID)) {
            return;
        }
        if (skipCheck.containsKey(playerUUID)) {
            int playerSkipCheckCount = skipCheck.get(playerUUID);
            if (playerSkipCheckCount > 0) {
                skipCheck.put(playerUUID, playerSkipCheckCount - 1);
                return;
            }
        } else {
            skipCheck.put(playerUUID, 5);
            return;
        }
        List nearbyEntities = cosmosLevel.getEntitiesOfClass(Mob.class, serverPlayer.getBoundingBox().inflate(120.0), e -> e.getTags().contains("voidvanguards.voidborn"));
        int voidbornCount = nearbyEntities.size();
        if (voidbornCount > VoidbornConstants.voidbornBaseMobCountStoryTrigger || voidbornCount < 5) {
            return;
        }
        BlockPos basePos = serverPlayer.blockPosition();
        Direction facing = serverPlayer.getDirection();
        BlockPos voidbornLeaderPos = null;
        for (int i = 1; i <= 3; ++i) {
            boolean isClear;
            BlockPos checkPos = basePos.relative(facing, i);
            boolean bl = isClear = cosmosLevel.getBlockState(checkPos).isAir() && cosmosLevel.getBlockState(checkPos.above()).isAir();
            if (!isClear) continue;
            voidbornLeaderPos = checkPos;
            break;
        }
        if (voidbornLeaderPos == null) {
            voidbornLeaderPos = basePos.relative(facing, 2);
        }
        Mob voidbornLeader = VoidbornUtil.spawnVoidbornLeader(cosmosLevel, voidbornLeaderPos);
        SaveLoadUtils.setForcedPositionTag(serverPlayer, 5, basePos);
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)cosmosLevel.getServer(), () -> StoryFunctions.processInitialVoidbornLeaderEncounter(cosmosLevel, serverPlayer, voidbornLeader), (int)10);
    }

    public static void voidbornRadarLeverWasTriggered(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        UUID playerUUID = serverPlayer.getUUID();
        VoidbornUtil.spawnLightningAtRadarEndRods(serverPlayer);
        MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"voidvanguards.message.voidborn.base.radarLever.flip").withStyle(ChatFormatting.RED));
        ServerSaveData.get().sabotagedVoidbornRadarPlayerUUIDS.add(playerUUID);
        SaveLoadUtils.savePlayerData((Player)serverPlayer);
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.getServer(), () -> VanguardFunctions.processVanguardTreeTeleportVoidbase(serverLevel, serverPlayer), (int)100);
    }
}

