/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.mixin;

import com.natamus.voidvanguards_common_neoforge.data.HeadData;
import com.natamus.voidvanguards_common_neoforge.data.ServerSaveData;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NearestAttackableTargetGoal.class}, priority=1001)
public abstract class NearestAttackableTargetGoalMixin
extends TargetGoal {
    @Shadow
    protected LivingEntity target;

    public NearestAttackableTargetGoalMixin(Mob mob, boolean b) {
        super(mob, b);
    }

    @Inject(method={"findTarget"}, at={@At(value="TAIL")})
    private void onFindTarget(CallbackInfo ci) {
        if (this.mob.level().isClientSide) {
            return;
        }
        if (!this.mob.getTags().contains("voidvanguards.voidborn")) {
            return;
        }
        LivingEntity livingEntity = this.target;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        boolean preventTargeting = this.mob.getTags().contains("voidvanguards.notarget");
        if (!preventTargeting && ServerSaveData.get().gaveVoidbornLeaderRadioPlayerUUIDS.contains(player.getUUID())) {
            preventTargeting = true;
        }
        if (!preventTargeting) {
            ItemStack helmet = player.getInventory().getArmor(3);
            ItemStack voidbornHead = HeadData.HeadType.VOIDBORN.headStack;
            if (helmet.is(Items.PLAYER_HEAD) && helmet.has(DataComponents.PROFILE) && voidbornHead.has(DataComponents.PROFILE)) {
                ResolvableProfile wornProfile = (ResolvableProfile)helmet.get(DataComponents.PROFILE);
                ResolvableProfile voidbornProfile = (ResolvableProfile)voidbornHead.get(DataComponents.PROFILE);
                if (wornProfile != null && wornProfile.equals((Object)voidbornProfile)) {
                    preventTargeting = true;
                }
            }
        }
        if (preventTargeting) {
            this.target = null;
            this.mob.setTarget(null);
        }
    }
}

