/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.mixin;

import com.natamus.voidvanguards_common_neoforge.parts.voidborn.util.VoidbornUtil;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.monster.Pillager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Pillager.class}, priority=1001)
public class PillagerMixin {
    @Inject(method={"getAmbientSound()Lnet/minecraft/sounds/SoundEvent;"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getAmbientSound(CallbackInfoReturnable<SoundEvent> cir) {
        Pillager pillager = (Pillager)this;
        if (pillager.getTags().contains("voidvanguards.voidborn")) {
            if (VoidbornUtil.shouldMakeAmbientSound(pillager.level())) {
                cir.setReturnValue((Object)SoundEvents.WARDEN_HEARTBEAT);
            } else {
                cir.setReturnValue(null);
            }
        }
    }

    @Inject(method={"getDeathSound()Lnet/minecraft/sounds/SoundEvent;"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (((Pillager)this).getTags().contains("voidvanguards.voidborn")) {
            cir.setReturnValue((Object)SoundEvents.VILLAGER_HURT);
        }
    }
}

