/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.networking.packets;

import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import com.natamus.collective_common_neoforge.implementations.networking.data.PacketContext;
import com.natamus.collective_common_neoforge.implementations.networking.data.Side;
import com.natamus.voidvanguards_common_neoforge.data.ClientVariables;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ToClientQueueScreenFlickerEffectPacket {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"voidvanguards", (String)"to_client_queue_screen_flicker_effect_packet");
    private final int startDelay;
    private final int flickerTicks;

    public ToClientQueueScreenFlickerEffectPacket(int startDelayIn, int flickerTicksIn) {
        this.startDelay = startDelayIn;
        this.flickerTicks = flickerTicksIn;
    }

    public static ToClientQueueScreenFlickerEffectPacket decode(FriendlyByteBuf buf) {
        int startDelayIn = buf.readInt();
        int flickerTicksIn = buf.readInt();
        return new ToClientQueueScreenFlickerEffectPacket(startDelayIn, flickerTicksIn);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.startDelay);
        buf.writeInt(this.flickerTicks);
    }

    public static void handle(PacketContext<ToClientQueueScreenFlickerEffectPacket> ctx) {
        if (ctx.side().equals((Object)Side.CLIENT)) {
            ToClientQueueScreenFlickerEffectPacket packet = (ToClientQueueScreenFlickerEffectPacket)ctx.message();
            int delay = packet.startDelay;
            if (delay < 0) {
                return;
            }
            TaskFunctions.enqueueCollectiveClientTask(() -> {
                ClientVariables.flickerTicksLeft = packet.flickerTicks;
            }, (int)delay);
        }
    }
}

