/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.parts.cosmos.functions;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import com.natamus.collective_common_neoforge.schematic.ParseSchematicFile;
import com.natamus.collective_common_neoforge.schematic.ParsedSchematicObject;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.voidvanguards_common_neoforge.data.ServerSaveData;
import com.natamus.voidvanguards_common_neoforge.parts.cosmos.util.CosmosDimensionUtil;
import com.natamus.voidvanguards_common_neoforge.parts.vanguard.functions.VanguardFunctions;
import com.natamus.voidvanguards_common_neoforge.parts.voidborn.functions.VoidbornFunctions;
import com.natamus.voidvanguards_common_neoforge.parts.voidborn.util.VoidbornUtil;
import com.natamus.voidvanguards_common_neoforge.registry.identifier.CosmosLocation;
import com.natamus.voidvanguards_common_neoforge.util.SaveLoadUtils;
import com.natamus.voidvanguards_common_neoforge.util.Util;
import java.io.InputStream;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CosmosDimensionFunctions {
    public static void teleportPlayerToVanguardStation(ServerLevel serverLevel, ServerPlayer serverPlayer, boolean fromSkyShipTrigger) {
        BlockPos spawnPos;
        MinecraftServer minecraftServer = serverLevel.getServer();
        UUID playerUUID = serverPlayer.getUUID();
        ServerSaveData.get().originalPlayerPositions.put(playerUUID, (Pair<ResourceKey<Level>, BlockPos>)Pair.of((Object)serverLevel.dimension(), (Object)serverPlayer.blockPosition()));
        SaveLoadUtils.savePlayerData((Player)serverPlayer);
        ServerLevel cosmosLevel = Util.getCosmosLevel(serverLevel.getServer());
        BlockPos vanguardStationPos = CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.getUUID(), CosmosLocation.VANGUARD_STATION);
        if (!ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.contains(playerUUID)) {
            CosmosDimensionFunctions.prepareCosmosSpawnArea(cosmosLevel, serverPlayer, vanguardStationPos);
            spawnPos = vanguardStationPos.offset(0, 51, -10);
        } else {
            spawnPos = vanguardStationPos;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            Services.TELEPORT.teleportEntity((Entity)serverPlayer, cosmosLevel, spawnPos);
            if (fromSkyShipTrigger) {
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.getServer(), () -> VanguardFunctions.spawnInitialVanguardsAroundPlayer(cosmosLevel, serverPlayer, spawnPos), (int)50);
            } else {
                MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"item.voidvanguards.orbital_transponder.useSuccess").withStyle(ChatFormatting.DARK_GREEN));
            }
        }, (int)10);
    }

    private static void prepareCosmosSpawnArea(ServerLevel cosmosLevel, ServerPlayer serverPlayer, BlockPos middlePos) {
        MinecraftServer minecraftServer = cosmosLevel.getServer();
        InputStream schematicInputstream = Util.getSchematicsInputStream(minecraftServer, "vanguard_station");
        if (schematicInputstream == null) {
            System.out.println("Error generating vanguard station: inputstream is null.");
            return;
        }
        ParsedSchematicObject parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)schematicInputstream, (Level)cosmosLevel, (BlockPos)middlePos, (int)-73, (boolean)false);
        if (!parsedSchematicObject.parsedCorrectly) {
            System.out.println("Error generating vanguard station: schematic object didn't parse.");
            return;
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            for (Pair blockPair : parsedSchematicObject.blocks) {
                cosmosLevel.setBlock((BlockPos)blockPair.getFirst(), (BlockState)blockPair.getSecond(), 3);
            }
            ServerSaveData.get().vanguardStationGeneratedPlayerUUIDS.add(serverPlayer.getUUID());
            SaveLoadUtils.savePlayerData((Player)serverPlayer);
        }, (int)0);
    }

    public static void teleportPlayerToVoidbornBase(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        boolean firstWarp;
        UUID playerUUID = serverPlayer.getUUID();
        ServerLevel cosmosLevel = Util.getCosmosLevel(serverLevel.getServer());
        BlockPos voidbornCosmosBasePos = CosmosDimensionUtil.getUniqueBlockPositionFromUUID(serverPlayer.getUUID(), CosmosLocation.VOIDBORN_BASE);
        BlockPos spawnPos = VoidbornUtil.getVoidbornBaseSpawnPos(serverPlayer, voidbornCosmosBasePos);
        boolean bl = firstWarp = !ServerSaveData.get().cosmosVoidbornBaseGeneratedPlayerUUIDS.contains(playerUUID);
        if (firstWarp) {
            VoidbornFunctions.prepareCosmosVoidbornBase(cosmosLevel, serverPlayer, voidbornCosmosBasePos, spawnPos);
        }
        if (firstWarp) {
            MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"voidvanguards.message.voidborn.cosmos_gate.enterSuccess.first").withStyle(ChatFormatting.DARK_PURPLE), (boolean)true);
        } else {
            MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"voidvanguards.message.voidborn.cosmos_gate.enterSuccess.again").withStyle(ChatFormatting.DARK_PURPLE), (boolean)true);
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.getServer(), () -> {
            if (!firstWarp) {
                Services.TELEPORT.teleportEntity((Entity)serverPlayer, cosmosLevel, spawnPos);
                Util.removeTag(serverPlayer, "voidvanguards.triggeredEntityInside");
            }
        }, (int)10);
    }
}

