/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.parts.vanguard.functions;

import com.mojang.authlib.GameProfile;
import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import com.natamus.collective_common_neoforge.functions.TileEntityFunctions;
import com.natamus.voidvanguards_common_neoforge.data.HeadData;
import com.natamus.voidvanguards_common_neoforge.data.ServerSaveData;
import com.natamus.voidvanguards_common_neoforge.parts.cosmos.functions.CosmosDimensionFunctions;
import com.natamus.voidvanguards_common_neoforge.parts.story.functions.StoryFunctions;
import com.natamus.voidvanguards_common_neoforge.parts.vanguard.data.VanguardVariables;
import com.natamus.voidvanguards_common_neoforge.parts.vanguard.util.VanguardUtil;
import com.natamus.voidvanguards_common_neoforge.parts.voidborn.util.VoidbornUtil;
import com.natamus.voidvanguards_common_neoforge.registry.objects.VanguardItems;
import com.natamus.voidvanguards_common_neoforge.util.SaveLoadUtils;
import com.natamus.voidvanguards_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PlayerHeadBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class VanguardFunctions {
    public static void initialPostSkyShipEventTrigger(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        MessageFunctions.broadcastMessage((Level)serverLevel, (MutableComponent)Component.translatable((String)"voidvanguards.message.skyship.server_trigger", (Object[])new Object[]{serverPlayer.getName().getString()}).withStyle(ChatFormatting.GOLD));
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.getServer(), () -> VanguardFunctions.spawnInitialVanguardsAroundPlayer(serverLevel, serverPlayer), (int)100);
    }

    public static void spawnInitialVanguardsAroundPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        VanguardFunctions.spawnInitialVanguardsAroundPlayer(serverLevel, serverPlayer, serverPlayer.blockPosition());
    }

    public static void spawnInitialVanguardsAroundPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer, BlockPos spawnPos) {
        int vanguardCount = 8;
        List<BlockPos> vanguardPositions = VanguardUtil.getVanguardPositions(spawnPos, vanguardCount);
        List<LivingEntity> vanguards = VanguardUtil.getVanguardsToSummon((Level)serverLevel, vanguardCount);
        VanguardFunctions.spawnVanguardsAroundPlayer(serverLevel, serverPlayer, spawnPos, vanguardCount, true, vanguardPositions, vanguards);
        int i = 0;
        for (LivingEntity vanguard : vanguards) {
            BlockPos rawSpawnPos = vanguardPositions.get(i);
            BlockPos vanguardSpawnPos = BlockPosFunctions.getSurfaceBlockPos((ServerLevel)serverLevel, (int)rawSpawnPos.getX(), (int)rawSpawnPos.getZ());
            vanguard.setPos((double)vanguardSpawnPos.getX() + 0.5, (double)vanguardSpawnPos.getY(), (double)vanguardSpawnPos.getZ() + 0.5);
            if (vanguard instanceof Mob) {
                ((Mob)vanguard).setCanPickUpLoot(false);
            }
            serverLevel.addFreshEntity((Entity)vanguard);
            vanguard.lookAt(EntityAnchorArgument.Anchor.EYES, serverPlayer.position());
            VanguardUtil.spawnTeleportParticles(serverLevel, vanguardSpawnPos);
            ++i;
        }
        for (BlockPos torchPos : VanguardUtil.getTorchLocations(spawnPos)) {
            if (!serverLevel.getBlockState(torchPos).isAir()) continue;
            if (serverLevel.getBlockState(torchPos.below()).isAir()) {
                serverLevel.setBlock(torchPos.below(), Blocks.SOUL_TORCH.defaultBlockState(), 3);
                continue;
            }
            serverLevel.setBlock(torchPos, Blocks.SOUL_TORCH.defaultBlockState(), 3);
        }
        SaveLoadUtils.setForcedPositionTag(serverPlayer, 4);
        if (!Util.isCosmosDimension(serverLevel)) {
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.getServer(), () -> {
                SaveLoadUtils.removeForcedPositionTag(serverPlayer);
                CosmosDimensionFunctions.teleportPlayerToVanguardStation(serverLevel, serverPlayer, true);
                TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.getServer(), () -> {
                    for (LivingEntity vanguard : vanguards) {
                        vanguard.remove(Entity.RemovalReason.DISCARDED);
                    }
                }, (int)10);
            }, (int)100);
        } else {
            VanguardUtil.removeGrassBetweenVanguards((Level)serverLevel, vanguardPositions);
            StoryFunctions.processVanguardInitialCosmos(serverLevel, serverPlayer, spawnPos, vanguards);
        }
    }

    public static void spawnVanguardsAroundPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer, BlockPos spawnPos, int amount, boolean onSurface) {
        List<BlockPos> vanguardPositions = VanguardUtil.getVanguardPositions(spawnPos, amount);
        List<LivingEntity> vanguards = VanguardUtil.getVanguardsToSummon((Level)serverLevel, amount);
        VanguardFunctions.spawnVanguardsAroundPlayer(serverLevel, serverPlayer, spawnPos, amount, onSurface, vanguardPositions, vanguards);
    }

    public static void spawnVanguardsAroundPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer, BlockPos spawnPos, int amount, boolean onSurface, List<BlockPos> vanguardPositions, List<LivingEntity> vanguards) {
        int i = 0;
        for (LivingEntity vanguard : vanguards) {
            BlockPos rawSpawnPos = vanguardPositions.get(i);
            BlockPos vanguardSpawnPos = onSurface ? BlockPosFunctions.getSurfaceBlockPos((ServerLevel)serverLevel, (int)rawSpawnPos.getX(), (int)rawSpawnPos.getZ()) : rawSpawnPos.immutable();
            vanguard.setPos((double)vanguardSpawnPos.getX() + 0.5, (double)vanguardSpawnPos.getY(), (double)vanguardSpawnPos.getZ() + 0.5);
            serverLevel.addFreshEntity((Entity)vanguard);
            vanguard.lookAt(EntityAnchorArgument.Anchor.EYES, serverPlayer.position());
            VanguardUtil.spawnTeleportParticles(serverLevel, vanguardSpawnPos);
            ++i;
        }
    }

    public static void createGravesAfterInitialEncounter(ServerLevel serverLevel, ServerPlayer serverPlayer, BlockPos spawnPos, List<LivingEntity> vanguards) {
        for (LivingEntity vanguard : vanguards) {
            vanguard.remove(Entity.RemovalReason.DISCARDED);
        }
        BlockPos firstGravePos = spawnPos.offset(-1, 0, -16);
        ArrayList<BlockPos> gravePositions = new ArrayList<BlockPos>();
        for (int i = 0; i <= 3; ++i) {
            gravePositions.add(firstGravePos.offset(2 * i, 0, 0));
        }
        int n = 1;
        for (BlockPos gravePos : gravePositions) {
            for (BlockPos aroundPos : BlockPos.betweenClosed((BlockPos)gravePos.offset(-1, 0, -1), (BlockPos)gravePos.offset(1, 0, 3))) {
                serverLevel.setBlock(aroundPos, Blocks.AIR.defaultBlockState(), 3);
            }
            serverLevel.setBlock(gravePos, (BlockState)Blocks.POLISHED_BLACKSTONE_BRICK_STAIRS.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)Direction.SOUTH), 3);
            BlockPos signPos = gravePos.south();
            serverLevel.setBlockAndUpdate(signPos, (BlockState)Blocks.WARPED_WALL_SIGN.defaultBlockState().setValue((Property)WallSignBlock.FACING, (Comparable)Direction.SOUTH));
            BlockEntity blockEntity = serverLevel.getBlockEntity(signPos);
            if (blockEntity instanceof SignBlockEntity) {
                SignBlockEntity signBlockEntity = (SignBlockEntity)blockEntity;
                SignText signText = signBlockEntity.getFrontText();
                signText = signText.setMessage(1, (Component)Component.literal((String)VanguardVariables.vanguardNames.get(n)));
                signText = signText.setMessage(2, (Component)Component.literal((String)(String.valueOf(VanguardVariables.vanguardBirthYears.get(n)) + " - " + Util.getCurrentYearString())));
                signBlockEntity.setText(signText, true);
                TileEntityFunctions.updateTileEntity((Level)serverLevel, (BlockPos)signPos, (BlockEntity)signBlockEntity);
            }
            BlockPos playerHeadPos = gravePos.south(2);
            serverLevel.setBlock(playerHeadPos, (BlockState)Blocks.PLAYER_HEAD.defaultBlockState().setValue((Property)PlayerHeadBlock.ROTATION, (Comparable)Integer.valueOf(8)), 3);
            BlockEntity blockEntity2 = serverLevel.getBlockEntity(playerHeadPos);
            if (blockEntity2 instanceof SkullBlockEntity) {
                SkullBlockEntity skullBlockEntity = (SkullBlockEntity)blockEntity2;
                GameProfile headGameProfile = HeadData.getHeadGameProfile(HeadData.HeadType.VANGUARD);
                if (headGameProfile != null) {
                    EntityFunctions.setSkullBlockOwner((SkullBlockEntity)skullBlockEntity, (ResolvableProfile)new ResolvableProfile(headGameProfile));
                }
            }
            serverLevel.setBlock(gravePos.below(), Blocks.POLISHED_BLACKSTONE_BRICKS.defaultBlockState(), 3);
            serverLevel.setBlock(gravePos.below().south(), Blocks.PODZOL.defaultBlockState(), 3);
            serverLevel.setBlock(gravePos.below().south(2), Blocks.PODZOL.defaultBlockState(), 3);
            ++n;
        }
    }

    public static void generateRadioAtPlayerPosition(ServerPlayer serverPlayer) {
        VanguardFunctions.generateRadioAtPlayerPosition(serverPlayer, 2);
    }

    public static void generateRadioAtPlayerPosition(ServerPlayer serverPlayer, int n) {
        ServerLevel serverLevel = serverPlayer.serverLevel();
        Vec3 eyePos = serverPlayer.getEyePosition();
        Vec3 lookVec = serverPlayer.getLookAngle();
        Direction facing = serverPlayer.getDirection();
        for (int i = n; i <= 2; ++i) {
            BlockPos checkPos = BlockPos.containing((Position)eyePos.add(lookVec.scale((double)i)));
            if (!serverLevel.isEmptyBlock(checkPos)) continue;
            GlowItemFrame frame = new GlowItemFrame((Level)serverLevel, checkPos, facing.getOpposite());
            frame.setItem(new ItemStack((ItemLike)VanguardItems.ORBITAL_RADIO));
            frame.setInvisible(true);
            frame.addTag("voidvanguards.tempframe");
            if (facing == Direction.UP || facing == Direction.DOWN) {
                float yaw = Mth.wrapDegrees((float)serverPlayer.getYRot());
                int rotationIndex = Mth.floor((float)((yaw + 180.0f) / 45.0f)) & 7;
                frame.setRotation(rotationIndex);
            }
            serverLevel.addFreshEntity((Entity)frame);
            VanguardUtil.spawnGenerationParticles(serverLevel, checkPos);
            if (n > 0 || i == 0) {
                MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"item.voidvanguards.orbital_radio.spawned.front").withStyle(ChatFormatting.BLUE), (boolean)true);
            } else {
                MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"item.voidvanguards.orbital_radio.spawned.behind").withStyle(ChatFormatting.BLUE), (boolean)true);
            }
            return;
        }
        if (n > 0) {
            VanguardFunctions.generateRadioAtPlayerPosition(serverPlayer, -2);
        }
    }

    public static void processVanguardTreeTeleportVoidbase(ServerLevel cosmosLevel, ServerPlayer serverPlayer) {
        MinecraftServer minecraftServer = cosmosLevel.getServer();
        BlockPos bottomTreePos = VoidbornUtil.getVoidbornBaseSpawnPos(serverPlayer).offset(4, 0, 0);
        cosmosLevel.setBlock(bottomTreePos, Blocks.AIR.defaultBlockState(), 3);
        cosmosLevel.setBlock(bottomTreePos.above(1), Blocks.AIR.defaultBlockState(), 3);
        cosmosLevel.setBlock(bottomTreePos.above(2), Blocks.AIR.defaultBlockState(), 3);
        serverPlayer.teleportTo((double)bottomTreePos.getX() + 0.5, (double)bottomTreePos.getY(), (double)bottomTreePos.getZ() + 0.5);
        List nearbyVoidborn = cosmosLevel.getEntitiesOfClass(AbstractIllager.class, serverPlayer.getBoundingBox().inflate(32.0), illager -> illager.getTags().contains("voidvanguards.voidborn"));
        for (AbstractIllager voidborn : nearbyVoidborn) {
            Util.spawnLightning(cosmosLevel, voidborn.blockPosition(), serverPlayer);
            voidborn.remove(Entity.RemovalReason.KILLED);
        }
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> {
            List<BlockPos> vanguardPositions = VanguardUtil.getVanguardPositions(bottomTreePos, 4);
            List<LivingEntity> vanguards = VanguardUtil.getVanguardsToSummon((Level)cosmosLevel, 4);
            for (BlockPos vanguardPos : vanguardPositions) {
                for (BlockPos nearbyPos : BlockPos.betweenClosed((BlockPos)vanguardPos.offset(-1, -1, -1), (BlockPos)vanguardPos.offset(1, 1, 1))) {
                    if (!cosmosLevel.getBlockState(nearbyPos).is(Blocks.FIRE)) continue;
                    cosmosLevel.removeBlock(nearbyPos, false);
                }
            }
            VanguardFunctions.spawnVanguardsAroundPlayer(cosmosLevel, serverPlayer, bottomTreePos, 4, false, vanguardPositions, vanguards);
            SaveLoadUtils.setForcedPositionTag(serverPlayer, 4);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> VanguardUtil.oblibirateTreeAbovePosition(cosmosLevel, bottomTreePos, 10, 2), (int)10);
            TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)minecraftServer, () -> StoryFunctions.processVanguardsInVoidbornBase(serverPlayer.serverLevel(), serverPlayer, vanguards), (int)20);
        }, (int)20);
    }

    public static void resetVanguardVariables(Player player) {
        SaveLoadUtils.removeOldSaveTag(player);
        ServerSaveData.removeUUID(player.getUUID());
    }
}

